/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.BaseRepositoryManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.Reset;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J$\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0*H\u0016J\u001a\u0010+\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\"H\u0016J\u0018\u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\"H\u0014J\b\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u0002032\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u00104\u001a\u00020 H\u0016J\n\u00105\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u00106\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u00107\u001a\u00020\"H\u0016J\u0010\u00108\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u00109\u001a\u00020\"H\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010<\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001c\u0010=\u001a\u00020\"2\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c0?J \u0010@\u001a\u00020;2\u0006\u0010$\u001a\u00020%2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010BH\u0016J\u0010\u0010C\u001a\u00020;2\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010D\u001a\u00020\u00192\b\u0010E\u001a\u0004\u0018\u00010\u001c2\b\u0010F\u001a\u0004\u0018\u00010\u001cH\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006G"}, d2={"Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "credentialsStore", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "dir", "Ljava/io/File;", "(Lcom/intellij/openapi/util/NotNullLazyValue;Ljava/io/File;)V", "_repository", "Lorg/eclipse/jgit/lib/Repository;", "get_repository", "()Lorg/eclipse/jgit/lib/Repository;", "set_repository", "(Lorg/eclipse/jgit/lib/Repository;)V", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getCredentialsProvider", "()Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsProvider$delegate", "Lkotlin/Lazy;", "ignoreRules", "Lorg/eclipse/jgit/ignore/IgnoreNode;", "repository", "getRepository", "addToIndex", "", "file", "path", "", "content", "", "size", "", "canCommit", "", "commit", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "fixStateIfCannotCommit", "paths", "", "commitIfCan", "state", "Lorg/eclipse/jgit/lib/RepositoryState;", "createRepositoryIfNeed", "deleteFromIndex", "isFile", "deleteRepository", "fetch", "Lorg/jetbrains/settingsRepository/RepositoryManager$Updater;", "getAheadCommitsCount", "getIgnoreRules", "getUpstream", "hasUpstream", "isPathIgnored", "isRepositoryExists", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "push", "renameDirectory", "pairs", "", "resetToMy", "localRepositoryInitializer", "Lkotlin/Function0;", "resetToTheirs", "setUpstream", "url", "branch", "settings-repository"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J$\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0*H\u0016J\u001a\u0010+\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\"H\u0016J\u0018\u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\"H\u0014J\b\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u0002032\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u00104\u001a\u00020 H\u0016J\n\u00105\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u00106\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u00107\u001a\u00020\"H\u0016J\u0010\u00108\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u00109\u001a\u00020\"H\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010<\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001c\u0010=\u001a\u00020\"2\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c0?J \u0010@\u001a\u00020;2\u0006\u0010$\u001a\u00020%2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010BH\u0016J\u0010\u0010C\u001a\u00020;2\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010D\u001a\u00020\u00192\b\u0010E\u001a\u0004\u0018\u00010\u001c2\b\u0010F\u001a\u0004\u0018\u00010\u001cH\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006G"}, strings={"Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "credentialsStore", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "dir", "Ljava/io/File;", "(Lcom/intellij/openapi/util/NotNullLazyValue;Ljava/io/File;)V", "_repository", "Lorg/eclipse/jgit/lib/Repository;", "get_repository", "()Lorg/eclipse/jgit/lib/Repository;", "set_repository", "(Lorg/eclipse/jgit/lib/Repository;)V", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getCredentialsProvider", "()Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsProvider$delegate", "Lkotlin/Lazy;", "ignoreRules", "Lorg/eclipse/jgit/ignore/IgnoreNode;", "repository", "getRepository", "addToIndex", "", "file", "path", "", "content", "", "size", "", "canCommit", "", "commit", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "fixStateIfCannotCommit", "paths", "", "commitIfCan", "state", "Lorg/eclipse/jgit/lib/RepositoryState;", "createRepositoryIfNeed", "deleteFromIndex", "isFile", "deleteRepository", "fetch", "Lorg/jetbrains/settingsRepository/RepositoryManager$Updater;", "getAheadCommitsCount", "getIgnoreRules", "getUpstream", "hasUpstream", "isPathIgnored", "isRepositoryExists", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "push", "renameDirectory", "pairs", "", "resetToMy", "localRepositoryInitializer", "Lkotlin/Function0;", "resetToTheirs", "setUpstream", "url", "branch", "settings-repository"})
public final class GitRepositoryManager
extends BaseRepositoryManager {
    @Nullable
    private Repository _repository;
    @NotNull
    private final Lazy<JGitCredentialsProvider> credentialsProvider$delegate;
    private IgnoreNode ignoreRules;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    public final Repository getRepository() {
        Repository r = this._repository;
        if (r == null) {
            this._repository = r = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).build();
            Application application = ApplicationManager.getApplication();
            if (Intrinsics.areEqual((Object)(application != null ? Boolean.valueOf(application.isUnitTestMode()) : null), (Object)true) ^ true) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(this){
                    final /* synthetic */ GitRepositoryManager this$0;

                    public final void run() {
                        Unit unit;
                        Repository repository2 = this.this$0.get_repository();
                        if (repository2 != null) {
                            repository2.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    {
                        this.this$0 = gitRepositoryManager;
                    }
                });
            }
        }
        Repository repository2 = r;
        if (repository2 == null) {
            Intrinsics.throwNpe();
        }
        return repository2;
    }

    @Nullable
    public final Repository get_repository() {
        return this._repository;
    }

    public final void set_repository(@Nullable Repository repository2) {
        this._repository = repository2;
    }

    @NotNull
    public final CredentialsProvider getCredentialsProvider() {
        return (CredentialsProvider)LazyKt.getValue(this.credentialsProvider$delegate, (Object)this, (KProperty)$$delegatedProperties[0]);
    }

    @Override
    public boolean createRepositoryIfNeed() {
        this.ignoreRules = null;
        if (this.isRepositoryExists()) {
            return false;
        }
        this.getRepository().create();
        GitExKt.disableAutoCrLf(this.getRepository());
        return true;
    }

    @Override
    public void deleteRepository() {
        this.ignoreRules = null;
        super.deleteRepository();
        Repository r = this._repository;
        if (r != null) {
            this._repository = null;
            r.close();
        }
    }

    @Override
    @Nullable
    public String getUpstream() {
        return StringUtil.nullize((String)this.getRepository().getConfig().getString("remote", "origin", "url"));
    }

    @Override
    public void setUpstream(@Nullable String url, @Nullable String branch) {
        Repository repository2 = this.getRepository();
        String string = branch;
        if (string == null) {
            string = "master";
        }
        GitExKt.setUpstream(repository2, url, string);
    }

    @Override
    public boolean isRepositoryExists() {
        Repository repo = this._repository;
        if (repo == null) {
            return this.getDir().exists() && ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).setup()).getObjectDirectory().exists();
        }
        return repo.getObjectDatabase().exists();
    }

    @Override
    public boolean hasUpstream() {
        return this.getUpstream() != null;
    }

    @Override
    protected void addToIndex(@NotNull File file, @NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        DirCacheEditorKt.edit(this.getRepository(), new AddLoadedFile(path, content, size, file.lastModified()));
    }

    @Override
    protected void deleteFromIndex(@NotNull String path, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.deletePath(this.getRepository(), path, isFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public boolean commit(@Nullable ProgressIndicator indicator, @Nullable SyncType syncType, boolean fixStateIfCannotCommit) {
        int it$iv;
        void $receiver$iv;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        int readCount$iv = $receiver$iv.getWriteHoldCount() == 0 ? $receiver$iv.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount$iv - 1;
        if (n <= n2) {
            void index$iv$iv;
            do {
                it$iv = ++index$iv$iv;
                rl$iv.unlock();
            } while (index$iv$iv != n2);
        }
        ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv.writeLock();
        wl$iv.lock();
        try {
            try {
                RepositoryState repositoryState = !fixStateIfCannotCommit || Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? this.getRepository().getRepositoryState() : PullKt.fixAndGetState(this.getRepository());
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"if (!fixStateIfCannotCom\u2026pository.fixAndGetState()");
                boolean bl = this.commitIfCan(indicator, repositoryState);
                return bl;
            }
            catch (UnmergedPathsException e) {
                Unit unit;
                Unit unit2;
                block23: {
                    if (!Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL))) break block23;
                    IcsManagerKt.getLOG().warn("Unmerged detected, ignored because sync type is OVERWRITE_LOCAL", (Throwable)e);
                    boolean bl = false;
                    it$iv = 0;
                    int n3 = readCount$iv - 1;
                    if (it$iv <= n3) {
                        do {
                            int $i$f$repeat = ++it$iv;
                            rl$iv.lock();
                        } while (it$iv != n3);
                    }
                    wl$iv.unlock();
                    return bl;
                }
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                IcsManagerKt.getLOG().warn("Unmerged detected, will be attempted to resolve", (Throwable)e);
                PullKt.resolveUnmergedConflicts(this.getRepository());
                ProgressIndicator progressIndicator2 = indicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                boolean bl = this.commitIfCan(indicator, PullKt.fixAndGetState(this.getRepository()));
                it$iv = 0;
                int n4 = readCount$iv - 1;
                if (it$iv <= n4) {
                    do {
                        int $i$f$repeat = ++it$iv;
                        rl$iv.lock();
                    } while (it$iv != n4);
                }
                wl$iv.unlock();
                return bl;
            }
            catch (NoHeadException e) {
                IcsManagerKt.getLOG().warn("Cannot commit - no HEAD", (Throwable)e);
                boolean bl = false;
                it$iv = 0;
                int n5 = readCount$iv - 1;
                if (it$iv <= n5) {
                    do {
                        int $i$f$repeat = ++it$iv;
                        rl$iv.lock();
                    } while (it$iv != n5);
                }
                wl$iv.unlock();
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            it$iv = 0;
            int n6 = readCount$iv - 1;
            if (it$iv <= n6) {
                do {
                    int $i$f$repeat = ++it$iv;
                    rl$iv.lock();
                } while (it$iv != n6);
            }
            wl$iv.unlock();
        }
    }

    private final boolean commitIfCan(ProgressIndicator indicator, RepositoryState state) {
        if (state.canCommit()) {
            return CommitKt.commit$default(this.getRepository(), indicator, null, 4, null);
        }
        IcsManagerKt.getLOG().warn("Cannot commit, repository in state " + state.getDescription());
        return false;
    }

    @Override
    public int getAheadCommitsCount() {
        return GitExKt.getAheadCommitsCount(this.getRepository());
    }

    @Override
    public void commit(@NotNull List<String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void push(@Nullable ProgressIndicator indicator) {
        Ref head;
        IcsManagerKt.getLOG().debug("Push");
        SmartList refSpecs = new SmartList((Collection)new RemoteConfig((Config)this.getRepository().getConfig(), "origin").getPushRefSpecs());
        if (refSpecs.isEmpty() && (head = this.getRepository().getRef("HEAD")) != null && head.isSymbolic()) {
            refSpecs.add((Object)new RefSpec(head.getLeaf().getName()));
        }
        ProgressMonitor monitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
        block5: for (Transport transport : Transport.openAll((Repository)this.getRepository(), (String)"origin", (Transport.Operation)Transport.Operation.PUSH)) {
            boolean bl = false;
            boolean bl2 = true;
            if (bl > bl2) continue;
            while (true) {
                void attempt;
                transport.setCredentialsProvider(this.getCredentialsProvider());
                try {
                    PushResult result = transport.push(monitor, transport.findRemoteRefUpdatesFor((Collection)refSpecs));
                    if (!IcsManagerKt.getLOG().isDebugEnabled()) continue block5;
                    OperationResult operationResult = (OperationResult)result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)operationResult, (String)"result");
                    GitRepositoryManagerKt.printMessages(operationResult);
                    for (RemoteRefUpdate refUpdate : result.getRemoteUpdates()) {
                        IcsManagerKt.getLOG().debug(refUpdate.toString());
                    }
                    continue block5;
                }
                catch (TransportException e) {
                    if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) {
                        if (attempt != false) throw (Throwable)new AuthenticationException(e);
                        this.getCredentialsProvider().reset(transport.getURI());
                    } else {
                        GitExKt.wrapIfNeedAndReThrow(e);
                    }
                }
                finally {
                    transport.close();
                    continue block5;
                }
                if (attempt == bl2) continue block5;
                ++attempt;
            }
        }
    }

    @Override
    @NotNull
    public RepositoryManager.Updater fetch(@Nullable ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        Pull pullTask = new Pull(this, progressIndicator, null, 4, null);
        Ref refToMerge = Pull.fetch$default(pullTask, null, 1, null);
        return new RepositoryManager.Updater(this, pullTask, refToMerge){
            private boolean definitelySkipPush;
            final /* synthetic */ GitRepositoryManager this$0;
            final /* synthetic */ Pull $pullTask;
            final /* synthetic */ Ref $refToMerge;

            public boolean getDefinitelySkipPush() {
                return this.definitelySkipPush;
            }

            public void setDefinitelySkipPush(boolean bl) {
                this.definitelySkipPush = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public UpdateResult merge() {
                int it$iv;
                ReentrantReadWriteLock $receiver$iv = GitRepositoryManager.access$getLock$p(this.this$0);
                ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
                int readCount$iv = $receiver$iv.getWriteHoldCount() == 0 ? $receiver$iv.getReadHoldCount() : 0;
                int n = 0;
                int n2 = readCount$iv - 1;
                if (n <= n2) {
                    void index$iv$iv;
                    do {
                        it$iv = ++index$iv$iv;
                        rl$iv.unlock();
                    } while (index$iv$iv != n2);
                }
                ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv.writeLock();
                wl$iv.lock();
                try {
                    boolean committed = RepositoryManager.DefaultImpls.commit$default(this.this$0, this.$pullTask.getIndicator(), null, false, 6, null);
                    if (this.$refToMerge == null && !committed && this.this$0.getAheadCommitsCount() == 0) {
                        this.setDefinitelySkipPush(true);
                        UpdateResult updateResult = null;
                        return updateResult;
                    }
                    UpdateResult updateResult = Pull.pull$default(this.$pullTask, null, null, this.$refToMerge, 3, null);
                    return updateResult;
                }
                finally {
                    it$iv = 0;
                    int n3 = readCount$iv - 1;
                    if (it$iv <= n3) {
                        do {
                            int $i$f$repeat = ++it$iv;
                            rl$iv.lock();
                        } while (it$iv != n3);
                    }
                    wl$iv.unlock();
                }
            }
            {
                this.this$0 = $outer;
                this.$pullTask = $captured_local_variable$1;
                this.$refToMerge = $captured_local_variable$2;
            }
        };
    }

    @Override
    @Nullable
    public UpdateResult pull(@Nullable ProgressIndicator indicator) {
        return Pull.pull$default(new Pull(this, indicator, null, 4, null), null, null, null, 7, null);
    }

    @Override
    @NotNull
    public UpdateResult resetToTheirs(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return Reset.reset$default(new Reset(this, indicator), true, null, 2, null);
    }

    @Override
    @NotNull
    public UpdateResult resetToMy(@NotNull ProgressIndicator indicator, @Nullable Function0<Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return new Reset(this, indicator).reset(false, localRepositoryInitializer);
    }

    @Override
    public boolean canCommit() {
        return this.getRepository().getRepositoryState().canCommit();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean renameDirectory(@NotNull Map<String, String> pairs) {
        void receiver$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        AddCommand addCommand = null;
        SmartList toDelete = new SmartList();
        Iterator iterator = MapsKt.iterator(pairs);
        while (iterator.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            object = (Map.Entry)iterator.next();
            Map.Entry entry = object;
            String oldPath = (String)$receiver$iv2.getKey();
            Map.Entry $i$f$component1 = object;
            String newPath = (String)$receiver$iv.getValue();
            File old = new File(this.getDir(), oldPath);
            if (!old.exists()) continue;
            IcsManagerKt.getLOG().info("Rename " + oldPath + " to " + newPath);
            File[] files2 = old.listFiles();
            if (files2 != null) {
                File file = newPath == null ? this.getDir() : new File(this.getDir(), newPath);
                for (int i = 0; i < files2.length; ++i) {
                    File file2 = files2[i];
                    try {
                        if (file2.isHidden()) {
                            FileUtil.delete((File)file2);
                            continue;
                        }
                        file2.renameTo(new File(file, file2.getName()));
                        if (addCommand == null) {
                            addCommand = new AddCommand(this.getRepository());
                        }
                        addCommand.addFilepattern(newPath == null ? file2.getName() : newPath + "/" + file2.getName());
                        continue;
                    }
                    catch (Throwable e) {
                        IcsManagerKt.getLOG().error(e);
                    }
                }
                toDelete.add((Object)new DeleteDirectory(oldPath));
            }
            try {
                FileUtil.delete((File)old);
            }
            catch (Throwable e) {
                IcsManagerKt.getLOG().error(e);
            }
        }
        if (toDelete.isEmpty() && addCommand == null) {
            return false;
        }
        DirCacheEditorKt.edit(this.getRepository(), (List)toDelete);
        if (addCommand != null) {
            addCommand.call();
        }
        object = new IdeaCommitMessageFormatter();
        Repository repository2 = this.getRepository();
        IdeaCommitMessageFormatter $receiver = (IdeaCommitMessageFormatter)receiver$iv;
        StringBuilder stringBuilder = $receiver.appendCommitOwnerInfo(new StringBuilder(), true);
        GitExKt.commit$default(repository2, stringBuilder.append("Get rid of $ROOT_CONFIG$ and $APP_CONFIG").toString(), null, null, null, 14, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IgnoreNode getIgnoreRules() {
        File file;
        void node;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.ignoreRules;
        if ((IgnoreNode)node.element == null && (file = new File(this.getDir(), ".gitignore")).exists()) {
            node.element = new IgnoreNode();
            Closeable $receiver$iv = FilesKt.inputStream((File)file);
            boolean closed$iv = false;
            try {
                FileInputStream it = (FileInputStream)$receiver$iv;
                IgnoreNode ignoreNode = (IgnoreNode)node.element;
                if (ignoreNode == null) {
                    Intrinsics.throwNpe();
                }
                ignoreNode.parse((InputStream)it);
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
            }
            this.ignoreRules = (IgnoreNode)node.element;
        }
        return (IgnoreNode)node.element;
    }

    @Override
    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        IgnoreNode ignoreNode = this.getIgnoreRules();
        return Intrinsics.areEqual(ignoreNode != null ? ignoreNode.isIgnored("/" + path, false) : null, (Object)IgnoreNode.MatchResult.IGNORED);
    }

    public GitRepositoryManager(@NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        super(dir);
        this.credentialsStore = credentialsStore2;
        this.credentialsProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JGitCredentialsProvider>(this){
            final /* synthetic */ GitRepositoryManager this$0;

            @NotNull
            public final JGitCredentialsProvider invoke() {
                return new JGitCredentialsProvider((NotNullLazyValue<CredentialsStore>)GitRepositoryManager.access$getCredentialsStore$p(this.this$0), this.this$0.getRepository());
            }
            {
                this.this$0 = gitRepositoryManager;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GitRepositoryManager.class), "credentialsProvider", "getCredentialsProvider()Lorg/eclipse/jgit/transport/CredentialsProvider;"))};
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(GitRepositoryManager $this) {
        return $this.getLock();
    }

    @NotNull
    public static final /* synthetic */ NotNullLazyValue access$getCredentialsStore$p(GitRepositoryManager $this) {
        return $this.credentialsStore;
    }
}

