/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightPackageReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myPackageName;
    private final PsiPackage myRefPackage;

    public LightPackageReference(PsiManager manager, PsiPackage refPackage) {
        super(manager, JavaLanguage.INSTANCE);
        this.myPackageName = null;
        this.myRefPackage = refPackage;
    }

    public LightPackageReference(PsiManager manager, String packageName) {
        super(manager, JavaLanguage.INSTANCE);
        this.myPackageName = packageName;
        this.myRefPackage = null;
    }

    @Override
    public PsiElement resolve() {
        if (this.myPackageName != null) {
            return JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.myPackageName);
        }
        return this.myRefPackage;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolve2 = this.resolve();
        JavaResolveResult javaResolveResult = resolve2 == null ? JavaResolveResult.EMPTY : new CandidateInfo(resolve2, PsiSubstitutor.EMPTY);
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPackageReference", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPackageReference", "multiResolve"));
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPackageReference", "multiResolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public String getText() {
        if (this.myPackageName != null) {
            return this.myPackageName;
        }
        return this.myRefPackage.getQualifiedName();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPackageReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement copy() {
        if (this.myPackageName != null) {
            return new LightPackageReference(this.myManager, this.myPackageName);
        }
        return new LightPackageReference(this.myManager, this.myRefPackage);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightPackageReference", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightPackageReference", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiPackage)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/light/LightPackageReference", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getText();
    }

    @Override
    public String getReferenceName() {
        if (this.myPackageName != null) {
            return PsiNameHelper.getShortClassName(this.myPackageName);
        }
        return this.myRefPackage.getName();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myRefPackage == null || this.myRefPackage.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPackageReference", "getTypeParameters"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }
}

