/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class IntArrayList
implements Cloneable {
    private int[] myData;
    private int mySize;

    public IntArrayList(int initialCapacity) {
        this.myData = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0, this.mySize);
    }

    public int indexOf(int elem, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList v = (IntArrayList)super.clone();
            v.myData = this.toArray();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @NotNull
    public int[] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntArrayList", "toArray"));
        }
        return nArray;
    }

    @NotNull
    public int[] toArray(int startIndex, int length) {
        int[] result = new int[length];
        System.arraycopy(this.myData, startIndex, result, 0, length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntArrayList", "toArray"));
        }
        return result;
    }

    public int get(int index2) {
        this.checkRange(index2);
        return this.myData[index2];
    }

    public void add(int o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public int remove(int index2) {
        this.checkRange(index2);
        int oldValue = this.myData[index2];
        int numMoved = this.mySize - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index2 + 1, this.myData, index2, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    private void checkRange(int index2) {
        if (index2 >= this.mySize || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

