/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ParametersListUtil {
    public static final Function<String, List<String>> DEFAULT_LINE_PARSER = new Function<String, List<String>>(){

        @Override
        public List<String> fun(String text) {
            return ParametersListUtil.parse(text, true);
        }
    };
    public static final Function<List<String>, String> DEFAULT_LINE_JOINER = new Function<List<String>, String>(){

        @Override
        public String fun(List<String> strings) {
            return StringUtil.join(strings, " ");
        }
    };
    public static final Function<String, List<String>> COLON_LINE_PARSER = new Function<String, List<String>>(){

        @Override
        public List<String> fun(String text) {
            ArrayList<String> result = ContainerUtilRt.newArrayList();
            StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
            return result;
        }
    };
    public static final Function<List<String>, String> COLON_LINE_JOINER = new Function<List<String>, String>(){

        @Override
        public String fun(List<String> strings) {
            return StringUtil.join(strings, ";");
        }
    };

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        if (parameterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterString", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        List<String> list2 = ParametersListUtil.parse(parameterString, false);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        return list2;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        if (parameterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterString", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        parameterString = parameterString.trim();
        ArrayList<String> params = ContainerUtilRt.newArrayList();
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                if (!keepQuotes) continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/execution/ParametersListUtil", "parse"));
        }
        return arrayList;
    }
}

