/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020$H\u0002J\u0006\u0010*\u001a\u00020\u000bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0006\u0010.\u001a\u00020\u000bJ\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00101\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00103\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00104\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001d\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "setConsistentInlineMarkers", "(Z)V", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "getSaveStackMarkerForRestoreMarker", "saveStackNodesForTryStartLabel", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getSaveStackNodesForTryStartLabel", "findMatchingSaveNodes", "", "insnNode", "restoreLabel", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "visitRestoreStackInTryCatch", "visitSaveStackBeforeTry", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020$H\u0002J\u0006\u0010*\u001a\u00020\u000bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0006\u0010.\u001a\u00020\u000bJ\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00101\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00103\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u00104\u001a\u0002002\u0006\u0010(\u001a\u00020\u0013H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001d\u00a8\u00065"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "setConsistentInlineMarkers", "(Z)V", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "getSaveStackMarkerForRestoreMarker", "saveStackNodesForTryStartLabel", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getSaveStackNodesForTryStartLabel", "findMatchingSaveNodes", "", "insnNode", "restoreLabel", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "visitRestoreStackInTryCatch", "visitSaveStackBeforeTry", "kotlin-compiler"})
public final class FixStackContext {
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    @NotNull
    private final HashMap<LabelNode, AbstractInsnNode> saveStackNodesForTryStartLabel;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;
    @NotNull
    private final MethodNode methodNode;

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    @NotNull
    public final HashMap<LabelNode, AbstractInsnNode> getSaveStackNodesForTryStartLabel() {
        return this.saveStackNodesForTryStartLabel;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        Unit unit;
        AbstractInsnNode next = insnNode.getNext();
        boolean value$iv = next.getOpcode() == 167;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = this.indexOf(insnNode) + ": should be followed by GOTO";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        AbstractInsnNode abstractInsnNode = next;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        this.breakContinueGotoNodes.add((JumpInsnNode)abstractInsnNode);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        Unit unit;
        boolean value$iv = insnNode.getNext().getOpcode() == 153;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = this.indexOf(insnNode) + ": should be followed by IFEQ";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        Unit unit;
        boolean value$iv = insnNode.getNext().getOpcode() == 153;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = this.indexOf(insnNode) + ": should be followed by IFEQ";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final void visitSaveStackBeforeTry(AbstractInsnNode insnNode) {
        Unit unit;
        AbstractInsnNode tryStartLabel = insnNode.getNext();
        boolean value$iv = tryStartLabel instanceof LabelNode;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = this.indexOf(insnNode) + ": save should be followed by a label";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        AbstractInsnNode abstractInsnNode = tryStartLabel;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LabelNode");
        }
        MapsKt.set(this.saveStackNodesForTryStartLabel, (LabelNode)abstractInsnNode, insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitRestoreStackInTryCatch(AbstractInsnNode insnNode) {
        Object object;
        void $receiver$iv;
        AbstractInsnNode restoreLabel;
        Object it;
        AbstractInsnNode finger$iv;
        AbstractInsnNode $receiver$iv2 = insnNode;
        for (finger$iv = $receiver$iv2.getPrevious(); finger$iv != null && !UtilKt.hasOpcode((AbstractInsnNode)(it = finger$iv)); finger$iv = finger$iv.getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode = finger$iv;
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        $receiver$iv2 = abstractInsnNode;
        for (finger$iv = $receiver$iv2.getPrevious(); finger$iv != null && !((it = finger$iv) instanceof LabelNode || UtilKt.hasOpcode((AbstractInsnNode)it)); finger$iv = finger$iv.getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode2 = finger$iv;
        if (abstractInsnNode2 == null) {
            Intrinsics.throwNpe();
        }
        if (!((restoreLabel = abstractInsnNode2) instanceof LabelNode)) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": restore should be preceded by a catch block label")));
        }
        List<AbstractInsnNode> saveNodes = this.findMatchingSaveNodes(insnNode, (LabelNode)restoreLabel);
        if (saveNodes.isEmpty()) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is not matched with save")));
        }
        if (saveNodes.size() > 1) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is matched with several saves")));
        }
        AbstractInsnNode saveNode = CollectionsKt.first(saveNodes);
        MapsKt.set(this.saveStackMarkerForRestoreMarker, insnNode, saveNode);
        it = this.restoreStackMarkersForSaveMarker;
        Object value$iv = $receiver$iv.get(saveNode);
        if (value$iv == null) {
            SmartList answer$iv = new SmartList();
            $receiver$iv.put(saveNode, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractInsnNode> findMatchingSaveNodes(AbstractInsnNode insnNode, LabelNode restoreLabel) {
        void $receiver$iv;
        SmartHashSet<AbstractInsnNode> saveNodes = new SmartHashSet<AbstractInsnNode>();
        Iterable iterable = this.methodNode.tryCatchBlocks;
        for (Object element$iv : $receiver$iv) {
            Boolean bl;
            TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
            if (!Intrinsics.areEqual(restoreLabel, tcb.start) && !Intrinsics.areEqual(restoreLabel, tcb.handler)) continue;
            if (this.saveStackNodesForTryStartLabel.get(tcb.start) != null) {
                void $receiver$iv2;
                AbstractInsnNode it = (AbstractInsnNode)$receiver$iv2;
                bl = saveNodes.add(it);
                continue;
            }
            bl = null;
        }
        return new SmartList((Collection)saveNodes);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    public final boolean hasAnyMarkers() {
        return CollectionsKt.isNotEmpty((Collection)this.breakContinueGotoNodes) || CollectionsKt.isNotEmpty((Collection)this.fakeAlwaysTrueIfeqMarkers) || CollectionsKt.isNotEmpty((Collection)this.fakeAlwaysFalseIfeqMarkers) || MapsKt.isNotEmpty((Map)this.saveStackNodesForTryStartLabel) || MapsKt.isNotEmpty((Map)this.openingInlineMethodMarker);
    }

    public final boolean isAnalysisRequired() {
        return CollectionsKt.isNotEmpty((Collection)this.breakContinueGotoNodes) || MapsKt.isNotEmpty((Map)this.saveStackNodesForTryStartLabel) || MapsKt.isNotEmpty((Map)this.openingInlineMethodMarker);
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    /*
     * WARNING - void declaration
     */
    public FixStackContext(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = SetsKt.linkedSetOf(new JumpInsnNode[0]);
        this.fakeAlwaysTrueIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.fakeAlwaysFalseIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.saveStackNodesForTryStartLabel = MapsKt.hashMapOf(new Pair[0]);
        this.saveStackMarkerForRestoreMarker = MapsKt.hashMapOf(new Pair[0]);
        this.restoreStackMarkersForSaveMarker = MapsKt.hashMapOf(new Pair[0]);
        this.openingInlineMethodMarker = MapsKt.hashMapOf(new Pair[0]);
        this.consistentInlineMarkers = true;
        AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        Stack<AbstractInsnNode> inlineMarkersStack = new Stack<AbstractInsnNode>();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        Sequence $receiver$iv = new InsnSequence(insnList);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Unit unit;
            Object element$iv = iterator2.next();
            AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FIX_STACK_BEFORE_JUMP)) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ)) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ)) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.SAVE_STACK_BEFORE_TRY)) {
                this.visitSaveStackBeforeTry(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH)) {
                this.visitRestoreStackInTryCatch(insnNode);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push(insnNode);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(insnNode)) continue;
            boolean bl = CollectionsKt.isNotEmpty((Collection)inlineMarkersStack);
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            Map map2 = this.openingInlineMethodMarker;
            Object t = inlineMarkersStack.pop();
            Intrinsics.checkExpressionValueIsNotNull(t, "inlineMarkersStack.pop()");
            MapsKt.set(map2, insnNode, t);
        }
        if (CollectionsKt.isNotEmpty((Collection)inlineMarkersStack)) {
            this.consistentInlineMarkers = false;
        }
    }
}

