/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;

public class TabledDescriptorRenderer {
    protected final List<TableOrTextRenderer> renderers = Lists.newArrayList();

    public TabledDescriptorRenderer text(@NotNull TextRenderer textRenderer) {
        if (textRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRenderer", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "text"));
        }
        this.renderers.add(textRenderer);
        return this;
    }

    public TabledDescriptorRenderer table(@NotNull TableRenderer tableRenderer) {
        if (tableRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableRenderer", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "table"));
        }
        this.renderers.add(tableRenderer);
        return this;
    }

    public static TextRenderer newText() {
        return new TextRenderer();
    }

    public static TableRenderer newTable() {
        return new TableRenderer();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TableOrTextRenderer tableOrTextRenderer : this.renderers) {
            if (tableOrTextRenderer instanceof TableRenderer) {
                this.renderTable((TableRenderer)tableOrTextRenderer, result);
                continue;
            }
            this.renderText((TextRenderer)tableOrTextRenderer, result);
        }
        return result.toString();
    }

    @NotNull
    public Renderer<KotlinType> getTypeRenderer() {
        Renderer<KotlinType> renderer = Renderers.RENDER_TYPE;
        if (renderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "getTypeRenderer"));
        }
        return renderer;
    }

    protected void renderText(TextRenderer textRenderer, StringBuilder result) {
        for (TextRenderer.TextElement element : textRenderer.elements) {
            result.append(element.text);
        }
    }

    protected void renderTable(TableRenderer table, StringBuilder result) {
        if (table.rows.isEmpty()) {
            return;
        }
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TextRenderer) {
                this.renderText((TextRenderer)row, result);
            }
            if (row instanceof TableRenderer.DescriptorRow) {
                result.append(DescriptorRenderer.COMPACT.render(((TableRenderer.DescriptorRow)row).descriptor));
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, result);
            }
            result.append("\n");
        }
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes, StringBuilder result) {
        boolean hasReceiver;
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer", "renderFunctionArguments"));
        }
        boolean bl = hasReceiver = receiverType != null;
        if (hasReceiver) {
            result.append("receiver: ");
            result.append(this.getTypeRenderer().render(receiverType));
            result.append("  arguments: ");
        }
        if (argumentTypes.isEmpty()) {
            result.append("()");
            return;
        }
        result.append("(");
        Iterator<KotlinType> iterator2 = argumentTypes.iterator();
        while (iterator2.hasNext()) {
            KotlinType argumentType = iterator2.next();
            String renderedArgument = this.getTypeRenderer().render(argumentType);
            result.append(renderedArgument);
            if (!iterator2.hasNext()) continue;
            result.append(",");
        }
        result.append(")");
    }

    public static TabledDescriptorRenderer create() {
        return new TabledDescriptorRenderer();
    }

    public static enum TextElementType {
        STRONG,
        ERROR,
        DEFAULT;

    }

    public static class TextRenderer
    implements TableOrTextRenderer,
    TableRenderer.TableRow {
        public final List<TextElement> elements = Lists.newArrayList();

        public TextRenderer normal(@NotNull Object text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer", "normal"));
            }
            this.elements.add(new TextElement(TextElementType.DEFAULT, text.toString()));
            return this;
        }

        public TextRenderer error(@NotNull Object text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer", "error"));
            }
            this.elements.add(new TextElement(TextElementType.ERROR, text.toString()));
            return this;
        }

        public TextRenderer strong(@NotNull Object text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer", "strong"));
            }
            this.elements.add(new TextElement(TextElementType.STRONG, text.toString()));
            return this;
        }

        public static class TextElement {
            public TextElementType type;
            public String text;

            public TextElement(@NotNull TextElementType type2, @NotNull String text) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer$TextElement", "<init>"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer$TextElement", "<init>"));
                }
                this.type = type2;
                this.text = text;
            }
        }
    }

    public static class TableRenderer
    implements TableOrTextRenderer {
        public final List<TableRow> rows = Lists.newArrayList();

        public TableRenderer descriptor(CallableDescriptor descriptor2) {
            this.rows.add(new DescriptorRow(descriptor2));
            return this;
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes) {
            if (argumentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "functionArgumentTypeList"));
            }
            return this.functionArgumentTypeList(receiverType, argumentTypes, Predicates.<ConstraintPosition>alwaysFalse());
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes, @NotNull Predicate<ConstraintPosition> isErrorPosition) {
            if (argumentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "functionArgumentTypeList"));
            }
            if (isErrorPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isErrorPosition", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "functionArgumentTypeList"));
            }
            this.rows.add(new FunctionArgumentsRow(receiverType, argumentTypes, isErrorPosition));
            return this;
        }

        public TableRenderer text(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "text"));
            }
            this.rows.add(TabledDescriptorRenderer.newText().normal(text));
            return this;
        }

        public TableRenderer text(@NotNull TextRenderer textRenderer) {
            if (textRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRenderer", "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer", "text"));
            }
            this.rows.add(textRenderer);
            return this;
        }

        public static class FunctionArgumentsRow
        implements TableRow {
            public final KotlinType receiverType;
            public final List<KotlinType> argumentTypes;
            public final Predicate<ConstraintPosition> isErrorPosition;

            public FunctionArgumentsRow(KotlinType receiverType, List<KotlinType> argumentTypes, Predicate<ConstraintPosition> isErrorPosition) {
                this.receiverType = receiverType;
                this.argumentTypes = argumentTypes;
                this.isErrorPosition = isErrorPosition;
            }
        }

        public static class DescriptorRow
        implements TableRow {
            public final CallableDescriptor descriptor;

            public DescriptorRow(CallableDescriptor descriptor2) {
                this.descriptor = descriptor2;
            }
        }

        public static interface TableRow {
        }
    }

    public static interface TableOrTextRenderer {
    }
}

