/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "resultRef", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "breakLabel", "(Lcom/google/dart/compiler/backend/js/ast/JsNameRef;Lcom/google/dart/compiler/backend/js/ast/JsNameRef;)V", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsReturn;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "getReturnReplacement", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "returnExpression", "visit", "", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "Lcom/google/dart/compiler/backend/js/ast/JsObjectLiteral;", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "resultRef", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "breakLabel", "(Lcom/google/dart/compiler/backend/js/ast/JsNameRef;Lcom/google/dart/compiler/backend/js/ast/JsNameRef;)V", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsReturn;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "getReturnReplacement", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "returnExpression", "visit", "", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "Lcom/google/dart/compiler/backend/js/ast/JsObjectLiteral;", "kotlin-compiler"})
public final class ReturnReplacingVisitor
extends JsVisitorWithContextImpl {
    private final JsNameRef resultRef;
    private final JsNameRef breakLabel;

    public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public void endVisit(@NotNull JsReturn x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        ctx.removeMe();
        JsExpression returnReplacement = this.getReturnReplacement(x.getExpression());
        if (returnReplacement != null) {
            ctx.addNext((JsNode)new JsExpressionStatement(returnReplacement));
        }
        if (this.breakLabel != null) {
            ctx.addNext((JsNode)new JsBreak(this.breakLabel));
        }
    }

    private final JsExpression getReturnReplacement(JsExpression returnExpression) {
        if (returnExpression != null) {
            if (this.resultRef != null) {
                return JsAstUtils.assignment(this.resultRef, returnExpression);
            }
            if (SideEffectUtilsKt.canHaveSideEffect(returnExpression)) {
                return returnExpression;
            }
        }
        return null;
    }

    public ReturnReplacingVisitor(@Nullable JsNameRef resultRef, @Nullable JsNameRef breakLabel) {
        this.resultRef = resultRef;
        this.breakLabel = breakLabel;
    }
}

