/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"generateDelegateCall", "Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "kotlin-compiler"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, strings={"generateDelegateCall", "Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "kotlin-compiler"})
public final class UtilsKt {
    @NotNull
    public static final JsPropertyInitializer generateDelegateCall(@NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor, @NotNull JsExpression thisObject, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(fromDescriptor, "fromDescriptor");
        Intrinsics.checkParameterIsNotNull(toDescriptor, "toDescriptor");
        Intrinsics.checkParameterIsNotNull(thisObject, "thisObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName delegateMemberFunctionName = context.getNameForDescriptor(fromDescriptor);
        JsName overriddenMemberFunctionName = context.getNameForDescriptor(toDescriptor);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args = new SmartList<JsNameRef>();
        JsScope functionScope = context.getScopeForDescriptor(fromDescriptor);
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName extensionFunctionReceiverName = functionScope.declareName(Namer.getReceiverParameterName());
            parameters2.add(new JsParameter(extensionFunctionReceiverName));
            args.add(new JsNameRef(extensionFunctionReceiverName));
        }
        for (ValueParameterDescriptor param : fromDescriptor.getValueParameters()) {
            String paramName = param.getName().asString();
            JsName jsParamName = functionScope.declareName(paramName);
            parameters2.add(new JsParameter(jsParamName));
            args.add(new JsNameRef(jsParamName));
        }
        JsFunction functionObject = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(fromDescriptor), new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<JsExpression>)args));
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters2);
        return new JsPropertyInitializer(delegateMemberFunctionName.makeRef(), functionObject);
    }
}

