/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/StringTemplateExpressionManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", "", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/psi/psiUtil/StringTemplateExpressionManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", "", "kotlin-compiler"})
public final class StringTemplateExpressionManipulator
extends AbstractElementManipulator<KtStringTemplateExpression> {
    @Override
    @Nullable
    public KtStringTemplateExpression handleContentChange(@NotNull KtStringTemplateExpression element, @NotNull TextRange range, @NotNull String newContent) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(range, "range");
        Intrinsics.checkParameterIsNotNull(newContent, "newContent");
        ASTNode node = element.getNode();
        String content = node.getFirstChildNode().getTextLength() == 1 ? StringUtil.escapeStringCharacters(newContent) : newContent;
        String oldText = node.getText();
        String newText = StringsKt.substring(oldText, 0, range.getStartOffset()) + content + StringsKt.substring(oldText, range.getEndOffset());
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "element.project");
        KtExpression expression = new KtPsiFactory(project).createExpression(newText);
        node.replaceAllChildrenToChildrenOf(expression.getNode());
        return node.getPsi(KtStringTemplateExpression.class);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return KtPsiUtilKt.getContentRange(element);
    }
}

