/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ImportResolver;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

public class LazyTopDownAnalyzerForTopLevel {
    @NotNull
    private final KotlinCodeAnalyzer codeAnalyzer;
    @NotNull
    private final LazyTopDownAnalyzer lazyTopDownAnalyzer;

    public LazyTopDownAnalyzerForTopLevel(@NotNull LazyTopDownAnalyzer lazyTopDownAnalyzer, @NotNull KotlinCodeAnalyzer codeAnalyzer) {
        if (lazyTopDownAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyTopDownAnalyzer", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "<init>"));
        }
        if (codeAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeAnalyzer", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "<init>"));
        }
        this.lazyTopDownAnalyzer = lazyTopDownAnalyzer;
        this.codeAnalyzer = codeAnalyzer;
    }

    @NotNull
    public TopDownAnalysisContext analyzeFiles(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<KtFile> files, @NotNull List<? extends PackageFragmentProvider> additionalProviders) {
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        if (additionalProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProviders", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        PackageFragmentProvider provider = additionalProviders.isEmpty() ? this.codeAnalyzer.getPackageFragmentProvider() : new CompositePackageFragmentProvider(CollectionsKt.plus(Arrays.asList(this.codeAnalyzer.getPackageFragmentProvider()), additionalProviders));
        ((ModuleDescriptorImpl)this.codeAnalyzer.getModuleDescriptor()).initialize(provider);
        TopDownAnalysisContext topDownAnalysisContext = this.analyzeDeclarations(topDownAnalysisMode, files);
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeFiles"));
        }
        return topDownAnalysisContext;
    }

    @NotNull
    public TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<? extends PsiElement> elements) {
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeDeclarations"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeDeclarations"));
        }
        TopDownAnalysisContext c = this.lazyTopDownAnalyzer.analyzeDeclarations(topDownAnalysisMode, elements, DataFlowInfo.EMPTY);
        LazyTopDownAnalyzerForTopLevel.resolveImportsInAllFiles(c, this.codeAnalyzer);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "analyzeDeclarations"));
        }
        return topDownAnalysisContext;
    }

    private static void resolveImportsInAllFiles(TopDownAnalysisContext c, KotlinCodeAnalyzer resolveSession) {
        for (KtFile file : c.getFiles()) {
            LazyTopDownAnalyzerForTopLevel.resolveAndCheckImports(file, resolveSession);
        }
        for (KtScript script : c.getScripts().keySet()) {
            LazyTopDownAnalyzerForTopLevel.resolveAndCheckImports(script.getContainingKtFile(), resolveSession);
        }
    }

    private static void resolveAndCheckImports(@NotNull KtFile file, @NotNull KotlinCodeAnalyzer resolveSession) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "resolveAndCheckImports"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/kotlin/resolve/LazyTopDownAnalyzerForTopLevel", "resolveAndCheckImports"));
        }
        ImportResolver importResolver2 = resolveSession.getFileScopeProvider().getImportResolver(file);
        importResolver2.forceResolveAllImports();
    }
}

