/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J*\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002J*\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002J*\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002J0\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0007J*\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0007J&\u0010\u001d\u001a\u00020\t*\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "getSuggestedPath", "path", "processDirectory", "action", "Lkotlin/Function2;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "runIfFileExists", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J*\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002J*\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002J*\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002J0\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0007J*\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0007J&\u0010\u001d\u001a\u00020\t*\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0016H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, strings={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "getSuggestedPath", "path", "processDirectory", "action", "Lkotlin/Function2;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "runIfFileExists", "kotlin-compiler"})
public final class JsLibraryUtils {
    private static final Logger LOG;
    private static final String META_INF_RESOURCES = "META-INF/resources/";
    public static final JsLibraryUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath) {
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String library : libraries) {
            Unit unit;
            File file = new File(library);
            boolean bl = file.exists();
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Library " + library + " not found";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            if (file.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file, outputLibraryJsPath);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file, outputLibraryJsPath);
        }
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function2<? super String, ? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(libs, "libs");
        Intrinsics.checkParameterIsNotNull(action, "action");
        Iterable $receiver$iv = libs;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function2<? super String, ? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(lib, "lib");
        Intrinsics.checkParameterIsNotNull(action, "action");
        if (lib.isDirectory()) {
            INSTANCE.traverseDirectory(lib, action);
        } else if (FileUtil.isJarOrZip(lib)) {
            INSTANCE.traverseArchive(lib, action);
        } else if (StringsKt.endsWith$default(lib.getName(), KotlinJavascriptMetadataUtils.JS_EXT, false, 2, null)) {
            Unit unit;
            File jsFile;
            INSTANCE.runIfFileExists(lib, action);
            File file = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, KotlinJavascriptMetadataUtils.META_JS_SUFFIX, KotlinJavascriptMetadataUtils.JS_EXT);
            if (file != null) {
                INSTANCE.runIfFileExists(file, action);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown library format (directory, zip or js file expected): " + lib);
        }
    }

    private final void runIfFileExists(File $receiver, Function2<? super String, ? super String, Unit> action) {
        if ($receiver.isFile()) {
            String string = FileUtil.loadFile($receiver);
            Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.loadFile(this)");
            action.invoke(string, "");
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath) {
        this.traverseDirectory(dir, (Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                FileUtil.writeToFile(new File(this.$outputLibraryJsPath, relativePath), content);
            }
            {
                this.$outputLibraryJsPath = string;
                super(2);
            }
        });
    }

    private final void processDirectory(File dir, Function2<? super String, ? super String, Unit> action) {
        FileUtil.processFilesRecursively(dir, new Processor<File>(dir, action){
            final /* synthetic */ File $dir;
            final /* synthetic */ Function2 $action;

            public final boolean process(File file) {
                String string = FileUtil.getRelativePath(this.$dir, file);
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + " " + file);
                }
                String relativePath = string;
                if (file.isFile() && StringsKt.endsWith$default(relativePath, KotlinJavascriptMetadataUtils.JS_EXT, false, 2, null)) {
                    String string2 = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "relativePath");
                    String string3 = JsLibraryUtils.access$getSuggestedPath(JsLibraryUtils.INSTANCE, string2);
                    if (string3 == null) {
                        return true;
                    }
                    String suggestedRelativePath = string3;
                    String string4 = FileUtil.loadFile(file);
                    Intrinsics.checkExpressionValueIsNotNull(string4, "FileUtil.loadFile(file)");
                    this.$action.invoke(string4, suggestedRelativePath);
                }
                return true;
            }
            {
                this.$dir = file;
                this.$action = function2;
            }
        });
    }

    private final void traverseDirectory(File dir, Function2<? super String, ? super String, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file, String outputLibraryJsPath) {
        this.traverseArchive(file, (Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(outputLibraryJsPath){
            final /* synthetic */ String $outputLibraryJsPath;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                FileUtil.writeToFile(new File(this.$outputLibraryJsPath, relativePath), content);
            }
            {
                this.$outputLibraryJsPath = string;
                super(2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void traverseArchive(File file, Function2<? super String, ? super String, Unit> action) {
        ZipFile zipFile = new ZipFile(file.getPath());
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String relativePath;
                String content;
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !StringsKt.endsWith$default(entryName, KotlinJavascriptMetadataUtils.JS_EXT, false, 2, null)) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                if (this.getSuggestedPath(string) == null) {
                    continue;
                }
                InputStream stream = zipFile.getInputStream(entry);
                String string2 = content = FileUtil.loadTextAndClose(stream);
                Intrinsics.checkExpressionValueIsNotNull(string2, "content");
                action.invoke(string2, relativePath);
            }
        }
        catch (IOException ex) {
            LOG.error("Could not extract files from archive " + file.getName() + ": " + ex.getMessage());
        }
        finally {
            zipFile.close();
        }
    }

    private final String getSuggestedPath(String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName(path);
        if (StringsKt.startsWith$default(systemIndependentPath, LibraryUtils.INSTANCE.getMETA_INF(), false, 2, null)) {
            if (StringsKt.startsWith$default(systemIndependentPath, META_INF_RESOURCES, false, 2, null)) {
                return StringsKt.substring(path, META_INF_RESOURCES.length());
            }
            return null;
        }
        return path;
    }

    private JsLibraryUtils() {
        INSTANCE = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        META_INF_RESOURCES = LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }

    static {
        new JsLibraryUtils();
    }

    @Nullable
    public static final /* synthetic */ String access$getSuggestedPath(JsLibraryUtils $this, @NotNull String path) {
        return $this.getSuggestedPath(path);
    }
}

