/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.fileUtils;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"descendantRelativeTo", "Ljava/io/File;", "base", "withReplacedExtensionOrNull", "oldExt", "", "newExt", "kotlin-compiler"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, strings={"descendantRelativeTo", "Ljava/io/File;", "base", "withReplacedExtensionOrNull", "oldExt", "", "newExt", "kotlin-compiler"})
public final class FileUtilsKt {
    @Nullable
    public static final File withReplacedExtensionOrNull(File $receiver, @NotNull String oldExt, @NotNull String newExt) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(oldExt, "oldExt");
        Intrinsics.checkParameterIsNotNull(newExt, "newExt");
        if (StringsKt.endsWith$default($receiver.getName(), oldExt, false, 2, null)) {
            String path = $receiver.getPath();
            String pathWithoutExt = StringsKt.substring(path, 0, path.length() - oldExt.length());
            String pathWithNewExt = pathWithoutExt + newExt;
            return new File(pathWithNewExt);
        }
        return null;
    }

    @NotNull
    public static final File descendantRelativeTo(File $receiver, @NotNull File base) {
        File file;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        String prefix = base.getCanonicalPath();
        String answer = $receiver.getCanonicalPath();
        String string = prefix;
        Intrinsics.checkExpressionValueIsNotNull(string, "prefix");
        if (StringsKt.startsWith$default(answer, string, false, 2, null)) {
            int prefixSize = prefix.length();
            file = answer.length() > prefixSize ? new File(StringsKt.substring(answer, prefixSize + 1)) : new File("");
        } else {
            file = $receiver;
        }
        return file;
    }
}

