/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStatisticsCollectorKt;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions(@Nullable DefaultActionGroup toInsert) {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Local Branches");
        ArrayList<GitLocalBranch> localBranches = new ArrayList<GitLocalBranch>(this.myRepository.getBranches().getLocalBranches());
        Collections.sort(localBranches);
        for (GitBranch gitBranch : localBranches) {
            if (gitBranch.equals(this.myRepository.getCurrentBranch())) continue;
            popupGroup.add((AnAction)new LocalBranchActions(this.myProject, repositoryList, gitBranch.getName(), this.myRepository));
        }
        popupGroup.addSeparator("Remote Branches");
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(this.myRepository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        for (GitBranch gitBranch : remoteBranches) {
            popupGroup.add((AnAction)new RemoteBranchActions(this.myProject, repositoryList, gitBranch.getName(), this.myRepository));
        }
        return popupGroup;
    }

    private static class CheckoutWithRebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        public CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseAction", "<init>"));
            }
            super("Checkout with Rebase", "Checkout the given branch, and rebase it on current branch in one step, just like `git rebase " + branchName + " HEAD would do.", null);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
            GitStatisticsCollectorKt.reportUsage("git.branch.checkout.with.rebase");
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        public RebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$RebaseAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$RebaseAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$RebaseAction", "<init>"));
            }
            super("Rebase onto");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            brancher.rebase(this.myRepositories, this.myBranchName);
            GitStatisticsCollectorKt.reportUsage("git.branch.rebase");
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        public MergeAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$MergeAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$MergeAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$MergeAction", "<init>"));
            }
            super("Merge");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
            GitStatisticsCollectorKt.reportUsage("git.branch.merge");
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final GitRepository mySelectedRepository;

        public CompareAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$CompareAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$CompareAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$CompareAction", "<init>"));
            }
            if (selectedRepository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRepository", "git4idea/ui/branch/GitBranchPopupActions$CompareAction", "<init>"));
            }
            super("Compare");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            brancher.compare(this.myBranchName, this.myRepositories, this.mySelectedRepository);
            GitStatisticsCollectorKt.reportUsage("git.branch.compare");
        }
    }

    static class RemoteBranchActions
    extends ActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;

        RemoteBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions", "<init>"));
            }
            if (selectedRepository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRepository", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions", "<init>"));
            }
            super("", true);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.getTemplatePresentation().setText(this.myBranchName, false);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions", "getChildren"));
            }
            return anActionArray;
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction", "<init>"));
                }
                if (branchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction", "<init>"));
                }
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
                GitStatisticsCollectorKt.reportUsage("git.branch.delete.remote");
            }
        }

        static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myRemoteBranchName;

            public CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String remoteBranchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction", "<init>"));
                }
                if (remoteBranchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranchName", "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction", "<init>"));
                }
                super("Checkout as new local branch");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"Enter name of new branch", (String)"Checkout Remote Branch", (Icon)Messages.getQuestionIcon(), (String)this.guessBranchName(), (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                    brancher.checkoutNewBranchStartingFrom(name, this.myRemoteBranchName, this.myRepositories, null);
                    GitStatisticsCollectorKt.reportUsage("git.branch.checkout.remote");
                }
            }

            private String guessBranchName() {
                int slashPosition = this.myRemoteBranchName.indexOf("/");
                return this.myRemoteBranchName.substring(slashPosition + 1);
            }
        }
    }

    static class LocalBranchActions
    extends ActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;

        LocalBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "<init>"));
            }
            if (selectedRepository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRepository", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "<init>"));
            }
            super("", true);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.getTemplatePresentation().setText(this.calcBranchText(), false);
        }

        @NotNull
        private String calcBranchText() {
            String trackedBranch = new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
            if (trackedBranch != null) {
                String string = this.myBranchName + " -> " + trackedBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "calcBranchText"));
                }
                return string;
            }
            String string = this.myBranchName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "calcBranchText"));
            }
            return string;
        }

        @NotNull
        List<GitRepository> getRepositories() {
            List<GitRepository> list = this.myRepositories;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "getRepositories"));
            }
            return list;
        }

        @NotNull
        public String getBranchName() {
            String string = this.myBranchName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "getBranchName"));
            }
            return string;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions", "getChildren"));
            }
            return anActionArray;
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.deleteBranch(this.myBranchName, this.myRepositories);
                GitStatisticsCollectorKt.reportUsage("git.branch.delete.local");
            }
        }

        private static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            public RenameBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String currentBranchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction", "<init>"));
                }
                if (currentBranchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranchName", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction", "<init>"));
                }
                super("Rename");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction", "actionPerformed"));
                }
                String newName = Messages.showInputDialog((Project)this.myProject, (String)("Enter new name for the branch " + this.myCurrentBranchName), (String)("Rename Branch " + this.myCurrentBranchName), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (newName != null) {
                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                    brancher.renameBranch(this.myCurrentBranchName, newName, this.myRepositories);
                    GitStatisticsCollectorKt.reportUsage("git.branch.rename");
                }
            }
        }

        private static class CheckoutAsNewBranch
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAsNewBranch(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAsNewBranch", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAsNewBranch", "<init>"));
                }
                if (branchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAsNewBranch", "<init>"));
                }
                super("Checkout as new branch");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"Enter name of new branch", (String)("Checkout New Branch From " + this.myBranchName), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                    brancher.checkoutNewBranchStartingFrom(name, this.myBranchName, this.myRepositories, null);
                }
                GitStatisticsCollectorKt.reportUsage("git.checkout.as.new.branch");
            }
        }

        static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAction", "<init>"));
                }
                if (repositories == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAction", "<init>"));
                }
                if (branchName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAction", "<init>"));
                }
                super("Checkout");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.checkout(this.myBranchName, false, this.myRepositories, null);
                GitStatisticsCollectorKt.reportUsage("git.branch.checkout.local");
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super("Checkout Tag or Revision...");
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(AnActionEvent e) {
            String reference = Messages.showInputDialog((Project)this.myProject, (String)"Enter reference (branch, tag) name or commit hash", (String)"Checkout", (Icon)Messages.getQuestionIcon());
            if (reference != null) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.checkout(reference, true, this.myRepositories, null);
                GitStatisticsCollectorKt.reportUsage("git.branch.checkout.revision");
            }
        }

        public void update(AnActionEvent e) {
            boolean isFresh = ContainerUtil.and(this.myRepositories, (Condition)new Condition<GitRepository>(){

                public boolean value(GitRepository repository) {
                    return repository.isFresh();
                }
            });
            if (isFresh) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Checkout is not possible before the first commit");
            }
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopupActions$GitNewBranchAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitBranchPopupActions$GitNewBranchAction", "<init>"));
            }
            super(project, repositories);
        }

        public void actionPerformed(AnActionEvent e) {
            String name = GitBranchUtil.getNewBranchNameFromUser(this.myProject, this.myRepositories, "Create New Branch");
            if (name != null) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.checkoutNewBranch(name, this.myRepositories);
                GitStatisticsCollectorKt.reportUsage("git.branch.create.new");
            }
        }
    }
}

