/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/java/decompiler/ShowDecompiledClassAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOriginalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "update", "java-decompiler-plugin"})
@KotlinClass(version={1, 1, 0}, data={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, strings={"Lorg/jetbrains/java/decompiler/ShowDecompiledClassAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOriginalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "update", "java-decompiler-plugin"})
public final class ShowDecompiledClassAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiElement psiElement2 = psiElement = this.getPsiElement(e);
        boolean visible = (psiElement2 != null ? psiElement2.getContainingFile() : null) instanceof PsiClassOwner;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && this.getOriginalFile(psiElement) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null && (file = this.getOriginalFile(this.getPsiElement(e))) != null) {
            new OpenFileDescriptor(project, file, -1).navigate(true);
        }
    }

    private final PsiElement getPsiElement(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        }
        Editor editor2 = editor;
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project2);
        return psiFile != null ? psiFile.findElementAt(editor2.getCaretModel().getOffset()) : null;
    }

    private final VirtualFile getOriginalFile(PsiElement psiElement) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        PsiClass psiClass2 = psiClass;
        VirtualFile file = psiClass2 != null && (psiClass2 = psiClass2.getOriginalElement()) != null && (psiClass2 = psiClass2.getContainingFile()) != null ? psiClass2.getVirtualFile() : null;
        return file != null && Intrinsics.areEqual((Object)file.getFileType(), (Object)JavaClassFileType.INSTANCE) ? file : (VirtualFile)null;
    }

    public ShowDecompiledClassAction() {
        super(IdeaDecompilerBundle.message("action.show.decompiled.name", new Object[0]));
    }
}

