/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.util.Processor;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashSet;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchScope {
    private ScopeType myScopeType;
    private String myModuleName;
    private String myPath;
    private boolean myRecursive;
    private String myScopeName;
    private com.intellij.psi.search.SearchScope myCustomScope;

    public SearchScope() {
        this.myScopeType = ScopeType.PROJECT;
        this.myRecursive = true;
    }

    public SearchScope(SearchScope scope) {
        this.myScopeType = scope.getScopeType();
        this.myModuleName = scope.getModuleName();
        this.myPath = scope.getPath();
        this.myRecursive = scope.isRecursive();
        this.myScopeName = scope.getScopeName();
    }

    public SearchScope(ScopeType scopeType, String directoryName, boolean recursive, String moduleName, String scopeName) {
        this.myScopeType = scopeType;
        this.myPath = directoryName;
        this.myRecursive = recursive;
        this.myModuleName = moduleName;
        this.myScopeName = scopeName;
    }

    public void setCustomScope(com.intellij.psi.search.SearchScope customScope) {
        this.myCustomScope = customScope;
    }

    @NotNull
    public String getName() {
        switch (this.getScopeType()) {
            case PROJECT: {
                if ("Project" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/SearchScope", "getName"));
                }
                return "Project";
            }
            case MODULE: {
                String string = "Module '" + this.getModuleName() + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/SearchScope", "getName"));
                }
                return string;
            }
            case DIRECTORY: {
                String string = "Directory '" + this.getPath() + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/SearchScope", "getName"));
                }
                return string;
            }
            case CUSTOM: {
                String string = this.getScopeName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/SearchScope", "getName"));
                }
                return string;
            }
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/SearchScope", "getName"));
        }
        return null;
    }

    @Attribute(value="type")
    @NotNull
    public ScopeType getScopeType() {
        ScopeType scopeType = this.myScopeType;
        if (scopeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/SearchScope", "getScopeType"));
        }
        return scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.myScopeType = scopeType;
    }

    @Tag
    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    @Attribute(value="scope-name")
    @Nullable
    public String getScopeName() {
        return this.myScopeName;
    }

    public void setScopeName(String scopeName) {
        this.myScopeName = scopeName;
    }

    @Tag
    @Nullable
    public String getPath() {
        return this.myPath;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    @Attribute
    public boolean isRecursive() {
        return this.myRecursive;
    }

    public void setRecursive(boolean recursive) {
        this.myRecursive = recursive;
    }

    public boolean isValid() {
        String dirName = this.getPath();
        String moduleName = this.getModuleName();
        switch (this.getScopeType()) {
            case MODULE: {
                return moduleName != null && moduleName.length() > 0;
            }
            case DIRECTORY: {
                return dirName != null && dirName.length() > 0 && SearchScope.findFile(dirName) != null;
            }
            case CUSTOM: {
                return this.myCustomScope != null;
            }
            case PROJECT: {
                return true;
            }
        }
        return false;
    }

    public void iterateContent(@NotNull Project project, Processor<VirtualFile> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xpathView/search/SearchScope", "iterateContent"));
        }
        switch (this.getScopeType()) {
            case PROJECT: {
                ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent((ContentIterator)new MyFileIterator(processor, (Condition<VirtualFile>)Conditions.alwaysTrue()));
                break;
            }
            case MODULE: {
                Module module = ModuleManager.getInstance((Project)project).findModuleByName(this.getModuleName());
                assert (module != null);
                ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContent((ContentIterator)new MyFileIterator(processor, (Condition<VirtualFile>)Conditions.alwaysTrue()));
                break;
            }
            case DIRECTORY: {
                String dirName = this.getPath();
                assert (dirName != null);
                VirtualFile virtualFile = SearchScope.findFile(dirName);
                if (virtualFile == null) break;
                SearchScope.iterateRecursively(virtualFile, processor, this.isRecursive());
                break;
            }
            case CUSTOM: {
                MyFileIterator iterator;
                assert (this.myCustomScope != null);
                if (this.myCustomScope instanceof GlobalSearchScope) {
                    final GlobalSearchScope searchScope = (GlobalSearchScope)this.myCustomScope;
                    iterator = new MyFileIterator(processor, new Condition<VirtualFile>(){

                        public boolean value(VirtualFile virtualFile) {
                            return searchScope.contains(virtualFile);
                        }
                    });
                    if (searchScope.isSearchInLibraries()) {
                        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Project)project).withoutModuleSourceEntries().withoutDepModules();
                        THashSet libraryFiles = new THashSet();
                        Collections.addAll(libraryFiles, enumerator.getClassesRoots());
                        Collections.addAll(libraryFiles, enumerator.getSourceRoots());
                        Processor<VirtualFile> adapter = new Processor<VirtualFile>(){

                            public boolean process(VirtualFile virtualFile) {
                                return iterator.processFile(virtualFile);
                            }
                        };
                        for (VirtualFile file : libraryFiles) {
                            SearchScope.iterateRecursively(file, adapter, true);
                        }
                    }
                } else {
                    final PsiManager manager = PsiManager.getInstance((Project)project);
                    iterator = new MyFileIterator(processor, new Condition<VirtualFile>(){

                        public boolean value(VirtualFile virtualFile) {
                            PsiFile element = manager.findFile(virtualFile);
                            return element != null && PsiSearchScopeUtil.isInScope((com.intellij.psi.search.SearchScope)SearchScope.this.myCustomScope, (PsiElement)element);
                        }
                    });
                }
                ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent((ContentIterator)iterator);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchScope scope = (SearchScope)o;
        return this.myRecursive == scope.myRecursive && Comparing.equal((Object)this.myCustomScope, (Object)scope.myCustomScope) && Comparing.equal((String)this.myModuleName, (String)scope.myModuleName) && Comparing.equal((String)this.myPath, (String)scope.myPath) && Comparing.equal((String)this.myScopeName, (String)scope.myScopeName) && this.myScopeType == scope.myScopeType;
    }

    public int hashCode() {
        int result = this.myScopeType != null ? this.myScopeType.hashCode() : 0;
        result = 31 * result + (this.myModuleName != null ? this.myModuleName.hashCode() : 0);
        result = 31 * result + (this.myPath != null ? this.myPath.hashCode() : 0);
        result = 31 * result + (this.myRecursive ? 1 : 0);
        result = 31 * result + (this.myScopeName != null ? this.myScopeName.hashCode() : 0);
        result = 31 * result + (this.myCustomScope != null ? this.myCustomScope.hashCode() : 0);
        return result;
    }

    @Nullable
    private static VirtualFile findFile(String dirName) {
        return LocalFileSystem.getInstance().findFileByPath(dirName.replace('\\', '/'));
    }

    private static void iterateRecursively(VirtualFile virtualFile, final Processor<VirtualFile> processor, boolean recursive) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{recursive ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/xpathView/search/SearchScope$4", "visitFile"));
                }
                if (!file.isDirectory()) {
                    processor.process((Object)file);
                }
                return true;
            }
        });
    }

    private static class MyFileIterator
    implements ContentIterator {
        private final Processor<VirtualFile> myProcessor;
        private final Condition<VirtualFile> myCondition;

        public MyFileIterator(Processor<VirtualFile> processor, Condition<VirtualFile> condition) {
            this.myCondition = condition;
            this.myProcessor = processor;
        }

        public boolean processFile(VirtualFile fileOrDir) {
            if (!fileOrDir.isDirectory() && this.myCondition.value((Object)fileOrDir)) {
                this.myProcessor.process((Object)fileOrDir);
            }
            return true;
        }
    }

    public static enum ScopeType {
        PROJECT,
        MODULE,
        DIRECTORY,
        CUSTOM;

    }
}

