/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.ComparisonsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001JB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J:\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u0010J<\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u00102\b\b\u0002\u00100\u001a\u00020\u0010J\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u000102Jk\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u00109\u001a\u00020:2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010;J!\u0010<\u001a\u00020=2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020=2\u0006\u0010%\u001a\u00020&J\u0016\u0010?\u001a\u00020=2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020,J(\u0010@\u001a\u00020=2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002JH\u0010A\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020*0B2\u0006\u0010C\u001a\u00020(2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020=0EH\u0002J&\u0010D\u001a\u00020=*\u00020.2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020\u00042\b\b\u0002\u0010I\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectToCompileService", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "Ljava/io/File;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "checkId", "detectCompilerClasspath", "", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "main", "", "([Ljava/lang/String;)V", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "category", "message", "source", "ClientOptions", "daemon-client"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001JB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J:\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u0010J<\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u00102\b\b\u0002\u00100\u001a\u00020\u0010J\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u000102Jk\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u00109\u001a\u00020:2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010;J!\u0010<\u001a\u00020=2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020=2\u0006\u0010%\u001a\u00020&J\u0016\u0010?\u001a\u00020=2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020,J(\u0010@\u001a\u00020=2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002JH\u0010A\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020*0B2\u0006\u0010C\u001a\u00020(2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020=0EH\u0002J&\u0010D\u001a\u00020=*\u00020.2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020\u00042\b\b\u0002\u0010I\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006K"}, strings={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectToCompileService", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "Ljava/io/File;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "checkId", "detectCompilerClasspath", "", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "main", "", "([Ljava/lang/String;)V", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "category", "message", "source", "ClientOptions", "daemon-client"})
public final class KotlinCompilerClient {
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    private static final boolean verboseReporting;
    @NotNull
    private static final String COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = "kotlin.daemon.client.options";
    public static final KotlinCompilerClient INSTANCE;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Object object;
        block3: {
            connectToCompileService.1 newFlagFile$;
            block2: {
                Object $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
                Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
                Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
                Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
                newFlagFile$ = connectToCompileService.1.INSTANCE;
                object = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY());
                if (object == null) break block2;
                String string = object;
                String it = (String)$receiver$iv;
                object = DaemonParamsKt.trimQuotes(it);
                if (object == null || (object = (String)AddToStdlibKt.check(object, connectToCompileService.flagFile.2.INSTANCE)) == null) break block2;
                $receiver$iv = object;
                it = (String)$receiver$iv;
                object = AddToStdlibKt.check(new File(it), connectToCompileService.flagFile.4.INSTANCE);
                if (object != null) break block3;
            }
            object = newFlagFile$.invoke();
        }
        Object flagFile2 = object;
        return this.connectToCompileService(compilerId, (File)flagFile2, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n) {
        return KotlinCompilerClient.connectToCompileService$default(kotlinCompilerClient, compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, n, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        int attempts = 0;
        try {
            while (attempts++ < DAEMON_CONNECT_CYCLE_ATTEMPTS) {
                void newJVMOptions;
                void service;
                Pair<CompileService, DaemonJVMOptions> pair = this.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(reportingTargets){
                    final /* synthetic */ DaemonReportingTargets $reportingTargets;

                    public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)cat), (String)"cat");
                        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                        KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.$reportingTargets, cat, msg, null, 4, null);
                    }
                    {
                        this.$reportingTargets = daemonReportingTargets;
                        super(2);
                    }
                }));
                CompileService compileService = (CompileService)pair.component1();
                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)pair.component2();
                pair = null;
                if (service != null) {
                    service.registerClient(clientAliveFlagFile.getAbsolutePath());
                    KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
                    return service;
                }
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "no suitable daemon found", null, 4, null);
                if (!autostart) continue;
                this.startDaemon(compilerId, (DaemonJVMOptions)newJVMOptions, daemonOptions, reportingTargets);
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
            }
        }
        catch (Exception e) {
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4, null);
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n) {
        return KotlinCompilerClient.connectToCompileService$default(kotlinCompilerClient, compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, n, null);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, 2, null), false, false);
        CompileService.CallResult callResult = compileService != null ? compileService.shutdown() : null;
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(null, null, port, 3, null), outStrm, CompileService.OutputFormat.PLAIN, outStrm, operationsTracer).get()).intValue();
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3) {
        return KotlinCompilerClient.compile$default(kotlinCompilerClient, compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer, n3, null);
    }

    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure(this, (Function0)new Function0<Integer>(compileService, sessionId, targetPlatform, args, callbackServices, port, compilerOut, daemonOut, operationsTracer){
            final /* synthetic */ CompileService $compileService;
            final /* synthetic */ int $sessionId;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilationServices $callbackServices;
            final /* synthetic */ int $port;
            final /* synthetic */ OutputStream $compilerOut;
            final /* synthetic */ OutputStream $daemonOut;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;

            public final int invoke() {
                return ((Number)this.$compileService.remoteIncrementalCompile(this.$sessionId, this.$targetPlatform, this.$args, new CompilerCallbackServicesFacadeServer(this.$callbackServices.getIncrementalCompilationComponents(), this.$callbackServices.getCompilationCanceledStatus(), this.$port), new RemoteOutputStreamServer(this.$compilerOut, this.$port), CompileService.OutputFormat.XML, new RemoteOutputStreamServer(this.$daemonOut, this.$port), this.$operationsTracer).get()).intValue();
            }
            {
                this.$compileService = compileService;
                this.$sessionId = n;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$callbackServices = compilationServices;
                this.$port = n2;
                this.$compilerOut = outputStream;
                this.$daemonOut = outputStream2;
                this.$operationsTracer = remoteOperationsTracer;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x100) != 0) {
            profiler = new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    public static /* bridge */ /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3) {
        return KotlinCompilerClient.incrementalCompile$default(kotlinCompilerClient, compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer, n3, null);
    }

    @NotNull
    public final String getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY() {
        return COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        Unit unit;
        String string = System.getProperty(COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY);
        if (string != null) {
            String $receiver$iv = string;
            String it = $receiver$iv;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + DaemonParamsKt.getCOMPILE_DAEMON_OPTIONS_PROPERTY() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl2, bl);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions};
        String string = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, string);
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                Unit unit;
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    List<String> it = list2;
                    compilerId.setCompilerClasspath(it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            CharSequence charSequence = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
            ConsoleKt.println((Object)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62, null)).toString());
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, 2, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            ConsoleKt.println((Object)"Shutdown the daemon");
            compileService.shutdown();
            ConsoleKt.println((Object)"Daemon shut down successfully");
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            ConsoleKt.println((Object)("Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId)));
            return;
        }
        ConsoleKt.println((Object)("Executing daemon compilation with args: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        OutputStream outputStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"System.out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(outputStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, 0, 7, null);
        try {
            void $receiver$iv;
            long memBefore = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Collection collection = CollectionsKt.toArrayList(filteredArgs);
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            int n = CompileService.Companion.getNO_SESSION();
            CompileService compileService2 = compileService;
            void v6 = $receiver$iv;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v6;
            String[] stringArray2 = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stringArray2;
            CompileService.CallResult<Integer> res = compileService2.remoteCompile(n, targetPlatform, (String[])objectArray, servicesFacade, outStrm, CompileService.OutputFormat.PLAIN, outStrm, null);
            long endTime = System.nanoTime();
            ConsoleKt.println((Object)("Compilation result code: " + res));
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            ConsoleKt.println((Object)("Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms"));
            ConsoleKt.println((Object)("Used memory " + memAfter + " (" + StringsKt.format((String)"%+d", (Object[])new Object[]{memAfter - memBefore}) + " kb)"));
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(outStrm, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        void $receiver$iv$iv$iv;
        Iterable $receiver$iv$iv;
        String string = System.getProperty("java.class.path");
        Object object = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object;
        String[] stringArray = new String[1];
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object = list;
        if (list == null) return null;
        Object $receiver$iv = (Iterable)object;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file = new File((String)it).getParentFile();
            collection.add(file);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        object = list2;
        if (list2 == null) return null;
        $receiver$iv = (Iterable)object;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable iterable2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Boolean bl;
            File file;
            Object element$iv$iv = element$iv$iv$iv;
            File it = (File)element$iv$iv;
            File file2 = it;
            if (file2 != null && (file2 = FilesKt.walk$default((File)file2, null, (int)1, null)) != null) {
                Object v8;
                block6: {
                    void $receiver$iv2;
                    Sequence $i$f$map = (Sequence)file2;
                    for (Object element$iv : $receiver$iv2) {
                        File it2 = (File)element$iv;
                        if (!StringsKt.equals((String)it2.getName(), (String)DaemonParamsKt.getCOMPILER_JAR_NAME(), (boolean)true)) continue;
                        v8 = element$iv;
                        break block6;
                    }
                    v8 = null;
                }
                file = v8;
            } else {
                file = null;
            }
            if (file != null) {
                void $receiver$iv$iv$iv2;
                File file3 = file;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        File file = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        object = file;
        if (file == null) return null;
        $receiver$iv = object;
        File it = (File)$receiver$iv;
        List list3 = CollectionsKt.listOf((Object)it.getAbsolutePath());
        return list3;
    }

    private final void report(DaemonReportingTargets $receiver, DaemonReportCategory category, String message, String source) {
        Unit unit;
        if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)DaemonReportCategory.DEBUG)) && !verboseReporting) {
            return;
        }
        PrintStream printStream = $receiver.getOut();
        if (printStream != null) {
            printStream.println("[" + source + "] " + category.name() + ": " + message);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Collection<DaemonReportMessage> collection = $receiver.getMessages();
        Boolean bl = collection != null ? Boolean.valueOf(collection.add(new DaemonReportMessage(category, "[" + source + "] " + message))) : null;
    }

    static /* bridge */ /* synthetic */ void report$default(KotlinCompilerClient kotlinCompilerClient, DaemonReportingTargets daemonReportingTargets, DaemonReportCategory daemonReportCategory, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "daemon client";
        }
        kotlinCompilerClient.report(daemonReportingTargets, daemonReportCategory, string, string2);
    }

    static /* bridge */ /* synthetic */ void report$default(KotlinCompilerClient kotlinCompilerClient, DaemonReportingTargets daemonReportingTargets, DaemonReportCategory daemonReportCategory, String string, String string2, int n) {
        KotlinCompilerClient.report$default(kotlinCompilerClient, daemonReportingTargets, daemonReportCategory, string, string2, n, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report) {
        Sequence sequence;
        void comparator$iv;
        Comparator comparator = ComparisonsKt.reversed((Comparator)new DaemonJVMOptionsMemoryComparator());
        Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ClientUtilsKt.walkDaemons$default(registryDir, compilerId, null, report, 4, null), (Function1)tryFindSuitableDaemonOrNewOpts.aliveWithOpts.1.INSTANCE), (Function1)tryFindSuitableDaemonOrNewOpts.aliveWithOpts.2.INSTANCE);
        Comparator comparator2 = new Comparator<Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>>>((Comparator)comparator$iv){
            final /* synthetic */ Comparator $comparator;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                Pair it;
                Comparator comparator$iv = this.$comparator;
                Pair pair = (Pair)a;
                Comparator comparator = comparator$iv;
                DaemonJVMOptions daemonJVMOptions = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                it = (Pair)b;
                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
            }
            {
                this.$comparator = comparator;
            }
        };
        Sequence aliveWithOpts2 = SequencesKt.sortedWith((Sequence)sequence2, (Comparator)comparator2);
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, 15, null);
        Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)aliveWithOpts2);
        if (pair != null && (pair = AddToStdlibKt.check(pair, (Function1)new Function1<Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>>, Boolean>(daemonJVMOptions){
            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;

            public final boolean invoke(@NotNull Pair<? extends CompileService, ? extends CompileService.CallResult<DaemonJVMOptions>> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return DaemonParamsKt.memorywiseFitsInto(this.$daemonJVMOptions, (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get());
            }
            {
                this.$daemonJVMOptions = daemonJVMOptions;
                super(1);
            }
        })) != null) {
            void $receiver$iv;
            Pair $i$f$compareBy = pair;
            Pair it = (Pair)$receiver$iv;
            sequence = new Pair(it.getFirst(), (Object)DaemonParamsKt.updateMemoryUpperBounds(optsCopy, (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get()));
        } else {
            Pair pair2;
            Sequence $receiver$iv = aliveWithOpts2;
            Object var17_13 = null;
            comparator2 = pair2;
            sequence2 = pair2;
            DaemonJVMOptions accumulator$iv = optsCopy;
            for (Object element$iv : $receiver$iv) {
                void d;
                Pair pair3 = (Pair)element$iv;
                DaemonJVMOptions opts = accumulator$iv;
                accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, (DaemonJVMOptions)((CompileService.CallResult)d.getSecond()).get());
            }
            DaemonJVMOptions daemonJVMOptions2 = accumulator$iv;
            sequence = sequence2;
            comparator2(var17_13, daemonJVMOptions2);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(System.getProperty("java.home"), "bin"), "java");
        platformSpecificOptions = CollectionsKt.listOf((Object)"-Djava.awt.headless=true");
        v0 = new String[3];
        v0[0] = javaExecutable.getAbsolutePath();
        v0[1] = "-cp";
        v1 = compilerId.getCompilerClasspath();
        v2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"File.pathSeparator");
        v0[2] = CollectionsKt.joinToString$default((Iterable)v1, (CharSequence)v2, null, null, (int)0, null, null, (int)62, null);
        var8_7 = daemonJVMOptions.getMappers();
        var21_8 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v0), (Iterable)platformSpecificOptions);
        var9_9 = $receiver$iv;
        var10_10 = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var22_18 = (List)destination$iv$iv;
        $receiver$iv = daemonOptions.getMappers();
        var21_8 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18), (Object)DaemonParamsKt.getCOMPILER_DAEMON_CLASS_FQN());
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var22_18 = (List)destination$iv$iv;
        $receiver$iv = compilerId.getMappers();
        var21_8 = CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var22_18 = (List)destination$iv$iv;
        args = CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18);
        KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        daemonLauncher = Native.get(ProcessLauncher.class);
        daemon = daemonLauncher.start(processBuilder);
        var11_11 = new Ref.ObjectRef();
        var11_11.element = new Semaphore(1);
        ((Semaphore)isEchoRead.element).acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, daemonOptions, (Ref.ObjectRef)isEchoRead, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ Ref.ObjectRef $isEchoRead;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    TextStreamsKt.forEachLine((Reader)ByteStreamsKt.reader$default((InputStream)this.$daemon.getInputStream(), null, (int)1, null), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (StringsKt.isNotEmpty((CharSequence)this.this$0.$daemonOptions.getRunFilesPath()) && StringsKt.contains$default((CharSequence)it, (CharSequence)this.this$0.$daemonOptions.getRunFilesPath(), (boolean)false, (int)2, null)) {
                                ((Semaphore)this.this$0.$isEchoRead.element).release();
                                return;
                            }
                            KotlinCompilerClient.access$report(KotlinCompilerClient.INSTANCE, this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, it, "daemon");
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                }
            }
            {
                this.$daemon = process;
                this.$daemonOptions = daemonOptions;
                this.$isEchoRead = objectRef;
                this.$reportingTargets = daemonReportingTargets;
                super(0);
            }
        }), (int)31, null);
        try {
            v3 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY());
            if (v3 == null) ** GOTO lbl-1000
            list$iv$iv = v3;
            it = (String)$receiver$iv;
            try {
                var17_21 = StringsKt.toLong((String)it);
            }
            catch (Exception e) {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY() + " property ('" + it + "'); using default timeout " + KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS + " ms", null, 4, null);
                var17_21 = null;
            }
            if ((v3 = var17_21) != null) {
                v4 = ((Number)v3).longValue();
            } else lbl-1000:
            // 2 sources

            {
                v4 = daemonStartupTimeout = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            if (StringsKt.isNotEmpty((CharSequence)daemonOptions.getRunFilesPath())) {
                succeeded = ((Semaphore)isEchoRead.element).tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                v5 = daemon;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"daemon");
                if (!KotlinCompilerClientKt.isProcessAlive(v5)) {
                    throw (Throwable)new Exception("Daemon terminated unexpectedly");
                }
                if (!succeeded) {
                    throw (Throwable)new Exception("Unable to get response from daemon in " + daemonStartupTimeout + " ms");
                }
            } else {
                Thread.sleep(daemonStartupTimeout);
            }
        }
        finally {
            if (stdoutThread.isAlive()) {
                stdoutThread.stop();
            }
        }
        isEchoRead = null;
    }

    private KotlinCompilerClient() {
        INSTANCE = this;
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_VERBOSE_REPORT_PROPERTY()) != null;
        COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    static {
        new KotlinCompilerClient();
    }

    public static final /* synthetic */ void access$report(KotlinCompilerClient $this, DaemonReportingTargets $receiver, @NotNull DaemonReportCategory category, @NotNull String message, @NotNull String source) {
        $this.report($receiver, category, message, source);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "daemon-client"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        public static /* bridge */ /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n) {
            return ClientOptions.copy$default(clientOptions, bl, n, null);
        }

        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (!(this.stop == clientOptions.stop)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

