/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"SOCKET_ANY_FREE_PORT", "", "getSOCKET_ANY_FREE_PORT", "()I", "portSelectionRng", "Ljava/util/Random;", "findPortAndCreateRegistry", "Lkotlin/Pair;", "Ljava/rmi/registry/Registry;", "attempts", "portRangeStart", "portRangeEnd", "daemon-common"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, strings={"SOCKET_ANY_FREE_PORT", "", "getSOCKET_ANY_FREE_PORT", "()I", "portSelectionRng", "Ljava/util/Random;", "findPortAndCreateRegistry", "Lkotlin/Pair;", "Ljava/rmi/registry/Registry;", "attempts", "portRangeStart", "portRangeEnd", "daemon-common"})
public final class NetworkUtilsKt {
    private static final int SOCKET_ANY_FREE_PORT = 0;
    private static final Random portSelectionRng = new Random();

    public static final int getSOCKET_ANY_FREE_PORT() {
        return SOCKET_ANY_FREE_PORT;
    }

    @NotNull
    public static final Pair<Registry, Integer> findPortAndCreateRegistry(int attempts, int portRangeStart, int portRangeEnd) {
        int i = 0;
        RemoteException lastException = null;
        while (i++ < attempts) {
            int port = portSelectionRng.nextInt(portRangeEnd - portRangeStart) + portRangeStart;
            try {
                return new Pair((Object)LocateRegistry.createRegistry(port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory()), (Object)port);
            }
            catch (RemoteException e) {
                lastException = e;
            }
        }
        throw (Throwable)new IllegalStateException("Cannot find free port in " + attempts + " attempts", lastException);
    }
}

