/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.ConstantsMapExternalizer$WhenMappings;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "Kind", "build"})
@KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "Kind", "build"})
public final class ConstantsMapExternalizer
implements DataExternalizer<Map<String, ? extends Object>> {
    public static final ConstantsMapExternalizer INSTANCE;

    public void save(@NotNull DataOutput output, @Nullable Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Map<String, ? extends Object> map2 = map;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        output.writeInt(map2.size());
        for (String name : CollectionsKt.sorted((Iterable)map.keySet())) {
            Object value;
            Object object;
            IOUtil.writeString((String)name, (DataOutput)output);
            if (map.get(name) == null) {
                Intrinsics.throwNpe();
            }
            if ((object = value) instanceof Integer) {
                output.writeByte(Kind.INT.ordinal());
                output.writeInt(((Number)value).intValue());
                continue;
            }
            if (object instanceof Float) {
                output.writeByte(Kind.FLOAT.ordinal());
                output.writeFloat(((Number)value).floatValue());
                continue;
            }
            if (object instanceof Long) {
                output.writeByte(Kind.LONG.ordinal());
                output.writeLong(((Number)value).longValue());
                continue;
            }
            if (object instanceof Double) {
                output.writeByte(Kind.DOUBLE.ordinal());
                output.writeDouble(((Number)value).doubleValue());
                continue;
            }
            if (object instanceof String) {
                output.writeByte(Kind.STRING.ordinal());
                IOUtil.writeString((String)((String)value), (DataOutput)output);
                continue;
            }
            throw (Throwable)new IllegalStateException("Unexpected constant class: " + value.getClass());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Map<String, Object> read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        int size = input.readInt();
        HashMap map = new HashMap(size);
        int n = 0;
        int n2 = size - 1;
        if (n <= n2) {
            void index$iv;
            do {
                String name;
                Object object;
                void it = ++index$iv;
                if (IOUtil.readString((DataInput)input) == null) {
                    Intrinsics.throwNpe();
                }
                Kind kind = Kind.values()[input.readByte()];
                switch (ConstantsMapExternalizer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                    case 1: {
                        object = input.readInt();
                        break;
                    }
                    case 2: {
                        object = Float.valueOf(input.readFloat());
                        break;
                    }
                    case 3: {
                        object = input.readLong();
                        break;
                    }
                    case 4: {
                        object = input.readDouble();
                        break;
                    }
                    case 5: {
                        object = IOUtil.readString((DataInput)input);
                        if (object != null) break;
                        Intrinsics.throwNpe();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Object value = object;
                MapsKt.set((Map)map, (Object)name, (Object)value);
            } while (index$iv != n2);
        }
        return map;
    }

    private ConstantsMapExternalizer() {
        INSTANCE = this;
    }

    static {
        new ConstantsMapExternalizer();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING", "build"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, strings={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING", "build"})
    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INT;
        public static final /* enum */ Kind FLOAT;
        public static final /* enum */ Kind LONG;
        public static final /* enum */ Kind DOUBLE;
        public static final /* enum */ Kind STRING;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[5];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = INT = new Kind();
            kindArray[1] = FLOAT = new Kind();
            kindArray[2] = LONG = new Kind();
            kindArray[3] = DOUBLE = new Kind();
            kindArray[4] = STRING = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }
}

