/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;

public class KotlinBuilderModuleScriptGenerator {
    @Nullable
    public static File generateModuleDescription(CompileContext context, ModuleChunk chunk, MultiMap<ModuleBuildTarget, File> sourceFiles, boolean hasRemovedFiles) throws IOException, ProjectBuildException {
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        boolean noSources = true;
        HashSet<File> outputDirs = new HashSet<File>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            outputDirs.add(KotlinBuilderModuleScriptGenerator.getOutputDirSafe(target));
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            ArrayList<File> moduleSources;
            File outputDir2 = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(target);
            ArrayList<File> friendDirs = new ArrayList<File>();
            File friendDir = KotlinBuilderModuleScriptGenerator.getFriendDirSafe(target);
            if (friendDir != null) {
                friendDirs.add(friendDir);
            }
            if ((moduleSources = new ArrayList<File>(IncrementalCompilation.isEnabled() ? sourceFiles.get((Object)target) : KotlinSourceFileCollector.getAllKotlinSourceFiles(target))).size() > 0 || hasRemovedFiles) {
                noSources = false;
                if (logger.isEnabled()) {
                    logger.logCompiledFiles(moduleSources, "Kotlin Builder", "Compiling files:");
                }
            }
            BuildTargetType targetType = target.getTargetType();
            assert (targetType instanceof JavaModuleBuildTargetType);
            builder.addModule(target.getId(), outputDir2.getAbsolutePath(), moduleSources, KotlinBuilderModuleScriptGenerator.findSourceRoots(context, target), KotlinBuilderModuleScriptGenerator.findClassPathRoots(target), ((JavaModuleBuildTargetType)targetType).getTypeId(), ((JavaModuleBuildTargetType)targetType).isTests(), outputDirs, friendDirs);
        }
        if (noSources) {
            return null;
        }
        File scriptFile = File.createTempFile("kjps", StringUtil.sanitizeJavaIdentifier((String)chunk.getName()) + ".script.xml");
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        return scriptFile;
    }

    @NotNull
    public static File getOutputDirSafe(@NotNull ModuleBuildTarget target) throws ProjectBuildException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getOutputDirSafe"));
        }
        File outputDir2 = target.getOutputDir();
        if (outputDir2 == null) {
            throw new ProjectBuildException("No output directory found for " + target);
        }
        File file = outputDir2;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getOutputDirSafe"));
        }
        return file;
    }

    @Nullable
    private static File getFriendDirSafe(@NotNull ModuleBuildTarget target) throws ProjectBuildException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getFriendDirSafe"));
        }
        if (!target.isTests()) {
            return null;
        }
        File outputDirForProduction = JpsJavaExtensionService.getInstance().getOutputDirectory(target.getModule(), false);
        if (outputDirForProduction == null) {
            return null;
        }
        return outputDirForProduction;
    }

    @NotNull
    private static Collection<File> findClassPathRoots(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findClassPathRoots"));
        }
        List list = ContainerUtil.filter((Collection)JpsUtils.getAllDependencies(target).classes().getRoots(), (Condition)new Condition<File>(){

            public boolean value(File file) {
                String extension;
                return file.exists() || (extension = FilesKt.getExtension((File)file)).equals("class") || extension.equals("jar");
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findClassPathRoots"));
        }
        return list;
    }

    @NotNull
    private static List<JvmSourceRoot> findSourceRoots(@NotNull CompileContext context, @NotNull ModuleBuildTarget target) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findSourceRoots"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findSourceRoots"));
        }
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        ArrayList result = ContainerUtil.newArrayList();
        for (JavaSourceRootDescriptor root : roots) {
            File file = root.getRootFile();
            String prefix = root.getPackagePrefix();
            if (!file.exists()) continue;
            result.add(new JvmSourceRoot(file, prefix.isEmpty() ? null : prefix));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findSourceRoots"));
        }
        return arrayList;
    }

    private KotlinBuilderModuleScriptGenerator() {
    }
}

