/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvcCommand {
    public static final Collection<String> ourEnvironments = Arrays.asList("prod", "test", "dev");
    private final Map<String, String> myEnvVariables = ContainerUtil.newHashMap();
    private boolean myPassParentEnvs;
    @Nullable
    private String myEnv;
    @Nullable
    private String myCommand;
    @Nullable
    private String myVmOptions;
    private final ArrayList<String> myArgs = new ArrayList();
    private final ArrayList<String> myProperties = new ArrayList();

    public MvcCommand() {
    }

    public MvcCommand(@Nullable String command, String ... args) {
        this.myCommand = command;
        Collections.addAll(this.myArgs, args);
    }

    @Nullable
    public String getEnv() {
        return this.myEnv;
    }

    @Nullable
    public String getCommand() {
        return this.myCommand;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public MvcCommand setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
        return this;
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        Map<String, String> map = this.myEnvVariables;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "getEnvVariables"));
        }
        return map;
    }

    public MvcCommand setEnvVariables(@NotNull Map<String, String> envVariables) {
        if (envVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVariables", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "setEnvVariables"));
        }
        if (this.myEnvVariables != envVariables) {
            this.myEnvVariables.clear();
            this.myEnvVariables.putAll(envVariables);
        }
        return this;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public MvcCommand setPassParentEnvs(boolean passParentEnv) {
        this.myPassParentEnvs = passParentEnv;
        return this;
    }

    public ArrayList<String> getArgs() {
        return this.myArgs;
    }

    public void setArgs(@NotNull List<String> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "setArgs"));
        }
        if (args == this.myArgs) {
            return;
        }
        this.myArgs.clear();
        this.myArgs.addAll(args);
    }

    public ArrayList<String> getProperties() {
        return this.myProperties;
    }

    public void setProperties(@NotNull List<String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "setProperties"));
        }
        if (this.myProperties == properties) {
            return;
        }
        this.myProperties.clear();
        this.myProperties.addAll(properties);
    }

    public void addToParametersList(@NotNull ParametersList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "addToParametersList"));
        }
        if (this.myEnv != null) {
            list.add(this.myEnv);
        }
        list.addAll(this.myProperties);
        if (this.myCommand != null) {
            list.add(this.myCommand);
        }
        list.addAll(this.myArgs);
    }

    @NotNull
    public static MvcCommand parse(@NotNull String cmd) {
        int i;
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "parse"));
        }
        String[] args = ParametersList.parse((String)cmd);
        MvcCommand res = new MvcCommand();
        for (i = 0; res.myCommand == null && i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("-D")) {
                res.myProperties.add(s);
                continue;
            }
            if (res.myEnv == null && ourEnvironments.contains(s)) {
                res.myEnv = s;
                continue;
            }
            res.myCommand = s;
        }
        res.myArgs.addAll(Arrays.asList(args).subList(i, args.length));
        MvcCommand mvcCommand = res;
        if (mvcCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcCommand", "parse"));
        }
        return mvcCommand;
    }
}

