/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.HashSet;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeDelegation;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.NullAwareness;
import kotlin.reflect.jvm.internal.impl.types.SubtypingRepresentatives;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingFlexibleType
extends DelegatingType
implements NullAwareness,
Flexibility,
FlexibleTypeDelegation {
    private boolean assertionsDone;
    @NotNull
    private final KotlinType lowerBound;
    @NotNull
    private final KotlinType upperBound;
    @NotNull
    private final FlexibleTypeCapabilities extraCapabilities;
    @NotNull
    private static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
    public static final Companion Companion;

    private final void runAssertions() {
        Unit unit;
        Unit unit2;
        Unit unit3;
        Unit unit4;
        if (this.assertionsDone || !PreconditionsKt.getASSERTIONS_ENABLED()) {
            return;
        }
        this.assertionsDone = true;
        boolean value$iv = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit4 = Unit.INSTANCE;
        } else {
            unit4 = Unit.INSTANCE;
        }
        value$iv = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = Unit.INSTANCE;
        }
        value$iv = Intrinsics.areEqual(this.getLowerBound(), this.getUpperBound()) ^ true;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        value$iv = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        T extra = this.getExtraCapabilities().getCapability(capabilityClass, this, this);
        if (extra != null) {
            return extra;
        }
        if (Companion.getCapabilityClasses$kotlin_core().contains(capabilityClass)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)delegatingFlexibleType;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public KotlinType makeNullableAsSpecified(boolean nullable2) {
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        KotlinType kotlinType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return Companion.create(kotlinType, kotlinType2, this.getExtraCapabilities());
    }

    @Override
    public boolean computeIsNullable() {
        return this.getDelegateType().isMarkedNullable();
    }

    @Override
    public boolean isMarkedNullable() {
        NullAwareness nullAwareness = this.getCapability(NullAwareness.class);
        if (nullAwareness == null) {
            Intrinsics.throwNpe();
        }
        return nullAwareness.computeIsNullable();
    }

    @Override
    @NotNull
    public KotlinType getDelegateType() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    @NotNull
    protected KotlinType getDelegate() {
        FlexibleTypeDelegation flexibleTypeDelegation = this.getCapability(FlexibleTypeDelegation.class);
        if (flexibleTypeDelegation == null) {
            Intrinsics.throwNpe();
        }
        return flexibleTypeDelegation.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public KotlinType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public KotlinType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeCapabilities getExtraCapabilities() {
        return this.extraCapabilities;
    }

    protected DelegatingFlexibleType(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.extraCapabilities = extraCapabilities;
    }

    static {
        Companion = new Companion(null);
        capabilityClasses = SetsKt.hashSetOf(NullAwareness.class, Flexibility.class, SubtypingRepresentatives.class, FlexibleTypeDelegation.class);
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        return Flexibility.DefaultImpls.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        return Flexibility.DefaultImpls.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return Flexibility.DefaultImpls.sameTypeConstructor(this, type2);
    }

    @JvmStatic
    @NotNull
    public static final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        return Companion.create(lowerBound, upperBound, extraCapabilities);
    }

    public static final class Companion {
        @NotNull
        public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses$kotlin_core() {
            return capabilityClasses;
        }

        @JvmStatic
        @NotNull
        public final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
            Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
            Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
            Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
            if (Intrinsics.areEqual(lowerBound, upperBound)) {
                return lowerBound;
            }
            return new DelegatingFlexibleType(lowerBound, upperBound, extraCapabilities);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

