/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.IndexedValue;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> keysToMap(Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        void destination$iv$iv$iv;
        void $receiver$iv$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Iterable<? extends K> $receiver$iv = $receiver;
        Iterable<? extends K> $receiver$iv$iv = $receiver$iv;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)((float)kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv$iv, 10) / 0.75f + 1.0f), 16);
        Iterable<? extends K> iterable = $receiver$iv$iv;
        Map map2 = new LinkedHashMap(capacity$iv$iv);
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv$iv;
            Object t = element$iv$iv$iv = iterator2.next();
            void var10_10 = destination$iv$iv$iv;
            void var11_11 = it;
            var10_10.put(var11_11, value.invoke(element$iv$iv$iv));
        }
        return destination$iv$iv$iv;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value, "value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            V v = value.invoke(k);
            if (v == null) continue;
            MapsKt.set(map2, k, v);
        }
        return map2;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        LinkedHashMap map2 = new LinkedHashMap();
        for (IndexedValue<K> indexedValue : kotlin.collections.CollectionsKt.withIndex($receiver)) {
            int index = indexedValue.component1();
            K k = indexedValue.component2();
            MapsKt.set(map2, k, index);
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    public static final <K, V> V getOrPutNullable(Map<K, V> $receiver, K key, @NotNull Function0<? extends V> defaultValue) {
        V v;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(defaultValue, "defaultValue");
        if (!$receiver.containsKey(key)) {
            void var3_3;
            V answer = defaultValue.invoke();
            $receiver.put(key, answer);
            v = var3_3;
        } else {
            v = $receiver.get(key);
        }
        return v;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(C $receiver, @NotNull Function0<? extends C> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(body, "body");
        return (C)($receiver.isEmpty() ? (Collection)body.invoke() : $receiver);
    }

    @NotNull
    public static final <T> T[] ifEmpty(T[] $receiver, @NotNull Function0<? extends T[]> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(body, "body");
        return ArraysKt.isEmpty($receiver) ? body.invoke() : $receiver;
    }

    @NotNull
    public static final <T> List<T> emptyOrSingletonList(@Nullable T item) {
        return kotlin.collections.CollectionsKt.listOfNotNull(item);
    }

    public static final <T> void addIfNotNull(Collection<T> $receiver, @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <T> List<T> toReadOnlyList(Collection<? extends T> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch ($receiver.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf(kotlin.collections.CollectionsKt.first((Iterable)$receiver));
                break;
            }
            default: {
                list = new ArrayList<T>($receiver);
            }
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(T $receiver) {
        return $receiver != null ? kotlin.collections.CollectionsKt.listOf($receiver) : kotlin.collections.CollectionsKt.emptyList();
    }
}

