/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MetaTarget
implements AntBuildTargetBase {
    private final AntBuildFileBase myBuildFile;
    private final String[] myTargets;
    private final String myName;
    private final String myDescription;

    public MetaTarget(AntBuildFileBase buildFile, String displayName, String[] targets) {
        this.myBuildFile = buildFile;
        this.myTargets = targets;
        this.myName = displayName;
        this.myDescription = AntBundle.message("meta.target.build.sequence.name.display.name", displayName);
    }

    @Override
    public Project getProject() {
        return this.myBuildFile.getProject();
    }

    public AntBuildFile getBuildFile() {
        return this.myBuildFile;
    }

    public String[] getTargetNames() {
        return this.myTargets;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getNotEmptyDescription() {
        return this.myDescription;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getActionId() {
        String modelName = this.myBuildFile.getModel().getName();
        if (modelName == null || modelName.length() == 0) {
            return null;
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(AntConfiguration.getActionIdPrefix(this.myBuildFile.getProject()));
            builder.append("_");
            builder.append(modelName);
            builder.append('_');
            builder.append(this.getName());
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public AntBuildModelBase getModel() {
        return this.myBuildFile.getModel();
    }

    @Override
    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        return null;
    }

    @Override
    @Nullable
    public BuildTask findTask(String taskName) {
        return null;
    }

    @Override
    public void run(DataContext dataContext, List<BuildFileProperty> additionalProperties, AntBuildListener buildListener) {
        ExecutionHandler.runBuild(this.myBuildFile, this.myTargets, null, dataContext, additionalProperties, buildListener);
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myBuildFile.getVirtualFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaTarget that = (MetaTarget)o;
        if (!this.myBuildFile.equals(that.myBuildFile)) {
            return false;
        }
        return Arrays.equals(this.myTargets, that.myTargets);
    }

    public int hashCode() {
        int code = this.myBuildFile.hashCode();
        for (String name : this.myTargets) {
            code += name.hashCode();
        }
        return code;
    }
}

