/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgAnnotateCommand;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.provider.annotate.HgAnnotation;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationLine;
import org.zmlx.hg4idea.util.HgUtil;

public class HgAnnotationProvider
implements AnnotationProvider {
    @NotNull
    private final Project myProject;

    public HgAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "<init>"));
        }
        this.myProject = project;
    }

    public FileAnnotation annotate(VirtualFile file) throws VcsException {
        return this.annotate(file, null);
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision revision) throws VcsException {
        List<HgFileRevision> logResult;
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)file.getPath()));
        if (vcsRoot == null) {
            throw new VcsException("vcs root is null for " + file);
        }
        HgFile hgFile = new HgFile(vcsRoot, VfsUtilCore.virtualToIoFile((VirtualFile)file));
        HgFile fileToAnnotate = revision instanceof HgFileRevision ? HgUtil.getFileNameInTargetRevision(this.myProject, ((HgFileRevision)revision).getRevisionNumber(), hgFile) : new HgFile(vcsRoot, HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)this.myProject)));
        List<HgAnnotationLine> annotationResult = new HgAnnotateCommand(this.myProject).execute(fileToAnnotate, revision);
        try {
            HgLogCommand logCommand = new HgLogCommand(this.myProject);
            logCommand.setFollowCopies(true);
            ArrayList<String> args = new ArrayList<String>();
            if (revision == null) {
                args.add("--rev");
                args.add("0::.");
            }
            logResult = logCommand.execute(fileToAnnotate, -1, false, args);
        }
        catch (HgCommandException e) {
            throw new VcsException("Can not annotate, " + HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), (Throwable)e);
        }
        VcsRevisionNumber revisionNumber = revision == null ? new HgWorkingCopyRevisionsCommand(this.myProject).tip(vcsRoot) : revision.getRevisionNumber();
        return new HgAnnotation(this.myProject, hgFile, annotationResult, logResult, revisionNumber);
    }

    public boolean isAnnotationValid(VcsFileRevision rev) {
        return true;
    }
}

