/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.html.entities.EntityConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u001f\u0010\b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/parser/LinkMap;", "", "map", "", "", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "(Ljava/util/Map;)V", "component1", "copy", "getLinkInfo", "label", "Builder", "LinkInfo"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u001f\u0010\b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, strings={"Lorg/intellij/markdown/parser/LinkMap;", "", "map", "", "", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "(Ljava/util/Map;)V", "component1", "copy", "getLinkInfo", "label", "Builder", "LinkInfo"})
public final class LinkMap {
    private final Map<CharSequence, LinkInfo> map;
    @NotNull
    private static final Regex SPACES_REGEX;
    public static final Builder Builder;

    @Nullable
    public final LinkInfo getLinkInfo(@NotNull CharSequence label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        return this.map.get(LinkMap.Builder.normalizeLabel(label));
    }

    private LinkMap(Map<CharSequence, LinkInfo> map) {
        this.map = map;
    }

    static {
        Builder = new Builder(null);
        SPACES_REGEX = new Regex("\\s+");
    }

    public /* synthetic */ LinkMap(@NotNull Map map, DefaultConstructorMarker $constructor_marker) {
        this(map);
    }

    private final Map<CharSequence, LinkInfo> component1() {
        return this.map;
    }

    @NotNull
    public final LinkMap copy(@NotNull Map<CharSequence, LinkInfo> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        return new LinkMap(map);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LinkMap copy$default(LinkMap linkMap, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = linkMap.map;
        }
        return linkMap.copy(map);
    }

    public static /* bridge */ /* synthetic */ LinkMap copy$default(LinkMap linkMap, Map map, int n) {
        return LinkMap.copy$default(linkMap, map, n, null);
    }

    public String toString() {
        return "LinkMap(map=" + this.map + ")";
    }

    public int hashCode() {
        Map<CharSequence, LinkInfo> map = this.map;
        return map != null ? ((Object)map).hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LinkMap)) break block3;
                LinkMap linkMap = (LinkMap)object;
                if (!Intrinsics.areEqual(this.map, linkMap.map)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "Companion"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t"}, strings={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "Companion"})
    public static final class LinkInfo {
        @NotNull
        private final ASTNode node;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        private LinkInfo(ASTNode node, CharSequence destination, CharSequence title) {
            this.node = node;
            this.destination = destination;
            this.title = title;
        }

        public /* synthetic */ LinkInfo(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title, DefaultConstructorMarker $constructor_marker) {
            this(node, destination, title);
        }

        @NotNull
        public final ASTNode component1() {
            return this.node;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final LinkInfo copy(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            return new LinkInfo(node, destination, title);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n, Object object) {
            if ((n & 1) != 0) {
                aSTNode = linkInfo.node;
            }
            if ((n & 2) != 0) {
                charSequence = linkInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = linkInfo.title;
            }
            return linkInfo.copy(aSTNode, charSequence, charSequence2);
        }

        public static /* bridge */ /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n) {
            return LinkInfo.copy$default(linkInfo, aSTNode, charSequence, charSequence2, n, null);
        }

        public String toString() {
            return "LinkInfo(node=" + this.node + ", destination=" + this.destination + ", title=" + this.title + ")";
        }

        public int hashCode() {
            ASTNode aSTNode = this.node;
            CharSequence charSequence = this.destination;
            CharSequence charSequence2 = this.title;
            return ((aSTNode != null ? aSTNode.hashCode() : 0) * 31 + (charSequence != null ? charSequence.hashCode() : 0)) * 31 + (charSequence2 != null ? charSequence2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LinkInfo)) break block3;
                    LinkInfo linkInfo = (LinkInfo)object;
                    if (!Intrinsics.areEqual((Object)this.node, (Object)linkInfo.node) || !Intrinsics.areEqual((Object)this.destination, (Object)linkInfo.destination) || !Intrinsics.areEqual((Object)this.title, (Object)linkInfo.title)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo$Companion;", "", "()V", "create", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "", "create$main"})
        @KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t"}, strings={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo$Companion;", "", "()V", "create", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "", "create$main"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LinkInfo create$main(@NotNull ASTNode node, @NotNull CharSequence fileText) {
                CharSequence charSequence;
                Object object;
                Object v0;
                Object $receiver$iv;
                CharSequence destination;
                block5: {
                    Object element$iv2;
                    Builder builder;
                    block4: {
                        void $receiver$iv2;
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        Intrinsics.checkParameterIsNotNull((Object)fileText, (String)"fileText");
                        Iterable iterable = node.getChildren();
                        builder = Builder;
                        for (Object element$iv2 : $receiver$iv2) {
                            ASTNode it = (ASTNode)element$iv2;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getLINK_DESTINATION())) continue;
                            break block4;
                        }
                        throw (Throwable)new NoSuchElementException("No element matching predicate was found.");
                    }
                    Object t = element$iv2;
                    destination = builder.normalizeDestination(ASTUtilKt.getTextInNode((ASTNode)t, fileText));
                    Iterable iterable = node.getChildren();
                    element$iv2 = $receiver$iv.iterator();
                    while (element$iv2.hasNext()) {
                        Object element$iv3 = element$iv2.next();
                        ASTNode it = (ASTNode)element$iv3;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getLINK_TITLE())) continue;
                        v0 = element$iv3;
                        break block5;
                    }
                    v0 = null;
                }
                if ((object = (ASTNode)v0) != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, fileText)) != null) {
                    $receiver$iv = object;
                    CharSequence it = (CharSequence)$receiver$iv;
                    charSequence = Builder.normalizeTitle(it);
                } else {
                    charSequence = null;
                }
                CharSequence title = charSequence;
                return new LinkInfo(node, destination, title, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ)\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/intellij/markdown/parser/LinkMap$Builder;", "", "()V", "SPACES_REGEX", "Lkotlin/text/Regex;", "getSPACES_REGEX", "()Lkotlin/text/Regex;", "buildLinkMap", "Lorg/intellij/markdown/parser/LinkMap;", "root", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "clearBounding", "s", "boundQuotes", "", "", "(Ljava/lang/CharSequence;[Ljava/lang/String;)Ljava/lang/CharSequence;", "normalizeDestination", "normalizeLabel", "label", "normalizeTitle"})
    @KotlinClass(version={1, 1, 0}, data={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ)\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006"}, strings={"Lorg/intellij/markdown/parser/LinkMap$Builder;", "", "()V", "SPACES_REGEX", "Lkotlin/text/Regex;", "getSPACES_REGEX", "()Lkotlin/text/Regex;", "buildLinkMap", "Lorg/intellij/markdown/parser/LinkMap;", "root", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "clearBounding", "s", "boundQuotes", "", "", "(Ljava/lang/CharSequence;[Ljava/lang/String;)Ljava/lang/CharSequence;", "normalizeDestination", "normalizeLabel", "label", "normalizeTitle"})
    public static final class Builder {
        @NotNull
        public final LinkMap buildLinkMap(@NotNull ASTNode root, @NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            HashMap map = new HashMap();
            ASTNodeKt.accept(root, new RecursiveVisitor(text, map){
                final /* synthetic */ CharSequence $text;
                final /* synthetic */ HashMap $map;

                /*
                 * WARNING - void declaration
                 */
                public void visitNode(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.Companion.getLINK_DEFINITION())) {
                        T element$iv2;
                        Builder builder;
                        block4: {
                            void $receiver$iv;
                            Iterable iterable = node.getChildren();
                            builder = LinkMap.Builder;
                            for (T element$iv2 : $receiver$iv) {
                                ASTNode it = (ASTNode)element$iv2;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getLINK_LABEL())) continue;
                                break block4;
                            }
                            throw (Throwable)new NoSuchElementException("No element matching predicate was found.");
                        }
                        T t = element$iv2;
                        CharSequence linkLabel = org.intellij.markdown.parser.LinkMap$Builder.access$normalizeLabel(builder, ASTUtilKt.getTextInNode((ASTNode)t, this.$text));
                        if (!this.$map.containsKey(linkLabel)) {
                            this.$map.put(linkLabel, LinkInfo.Companion.create$main(node, this.$text));
                        }
                    } else {
                        super.visitNode(node);
                    }
                }
                {
                    this.$text = $captured_local_variable$0;
                    this.$map = $captured_local_variable$1;
                }
            });
            return new LinkMap(map, null);
        }

        private final CharSequence normalizeLabel(CharSequence label) {
            String string = this.getSPACES_REGEX().replace(label, " ");
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            return StringsKt.toLowerCase((String)string, (Locale)locale);
        }

        @NotNull
        public final CharSequence normalizeDestination(@NotNull CharSequence s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            String dest = EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, "<>"), true, true);
            StringBuilder sb = new StringBuilder();
            CharIterator charIterator = StringsKt.iterator((CharSequence)dest);
            while (charIterator.hasNext()) {
                char c = charIterator.nextChar();
                char code = c;
                if (code == ' ') {
                    sb.append("%20");
                    continue;
                }
                if (code < ' ' || code >= '\u0080' || StringsKt.contains$default((CharSequence)"\".<>\\^_`{|}~", (char)c, (boolean)false, (int)2, null)) {
                    sb.append(URLEncoder.encode(String.valueOf(c), "UTF-8"));
                    continue;
                }
                sb.append(c);
            }
            CharSequence charSequence = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"sb.toString()");
            return charSequence;
        }

        @NotNull
        public final CharSequence normalizeTitle(@NotNull CharSequence s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            return EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, "\"\"", "''", "()"), true, true);
        }

        private final CharSequence clearBounding(CharSequence s, String ... boundQuotes) {
            if (s.length() == 0) {
                return s;
            }
            for (int i = 0; i < boundQuotes.length; ++i) {
                String quotePair = boundQuotes[i];
                if (s.charAt(0) != quotePair.charAt(0) || s.charAt(s.length() - 1) != quotePair.charAt(1)) continue;
                return s.subSequence(1, s.length() - 1);
            }
            return s;
        }

        @NotNull
        public final Regex getSPACES_REGEX() {
            return SPACES_REGEX;
        }

        private Builder() {
        }

        public /* synthetic */ Builder(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

