/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u001c\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u00060\rR\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/BacktickParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "findOfSize", "", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "indices", "", "from", "length", "getLength", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "canEscape", "", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;"})
@KotlinClass(version={1, 1, 0}, data={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u001c\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u00060\rR\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/BacktickParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "findOfSize", "", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "indices", "", "from", "length", "getLength", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "canEscape", "", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;"})
public final class BacktickParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResult result = new SequentialParser.ParsingResult();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < indices.size()) {
            int j;
            TokensCache.ListIterator iterator = tokens.new TokensCache.ListIterator(indices, i);
            if ((Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) && (j = this.findOfSize(tokens, indices, i + 1, this.getLength(iterator, true))) != -1) {
                result.withNode(new SequentialParser.Node(new IntRange(((Number)indices.get(i)).intValue(), ((Number)indices.get(j)).intValue() + 1), MarkdownElementTypes.Companion.getCODE_SPAN()));
                i = j + 1;
                continue;
            }
            delegateIndices.add(indices.get(i));
            ++i;
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<Integer>)delegateIndices));
    }

    /*
     * WARNING - void declaration
     */
    private final int findOfSize(TokensCache tokens, List<Integer> indices, int from, int length) {
        int n = from;
        int n2 = indices.size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                TokensCache.ListIterator iterator;
                if (!(Intrinsics.areEqual((Object)(iterator = tokens.new TokensCache.ListIterator(indices, (int)i)).getType(), (Object)MarkdownTokenTypes.BACKTICK) ^ true && Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS) ^ true || this.getLength(iterator, false) != length)) {
                    return (int)i;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return -1;
    }

    private final int getLength(TokensCache.Iterator info, boolean canEscape) {
        String tokenText = info.getText();
        int toSubtract = 0;
        if (Intrinsics.areEqual((Object)info.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) {
            toSubtract = canEscape ? 2 : 1;
        }
        return tokenText.length() - toSubtract;
    }
}

