/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil;", "", "()V", "Companion"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil;", "", "()V", "Companion"})
public final class LinkParserUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u00060\u0004R\u00020\u0005J4\u0010\n\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\t\u001a\u00060\u0004R\u00020\u0005J4\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\t\u001a\u00060\u0004R\u00020\u0005J&\u0010\u000f\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u00060\u0004R\u00020\u0005"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil$Companion;", "", "()V", "parseLinkDestination", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "iterator", "parseLinkLabel", "delegateIndices", "", "", "parseLinkText", "parseLinkTitle"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u00060\u0004R\u00020\u0005J4\u0010\n\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\t\u001a\u00060\u0004R\u00020\u0005J4\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\t\u001a\u00060\u0004R\u00020\u0005J&\u0010\u000f\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u00060\u0004R\u00020\u0005"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil$Companion;", "", "()V", "parseLinkDestination", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "iterator", "parseLinkLabel", "delegateIndices", "", "", "parseLinkText", "parseLinkTitle"})
    public static final class Companion {
        @Nullable
        public final TokensCache.Iterator parseLinkDestination(@NotNull Collection<SequentialParser.Node> result, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RPAREN)) {
                return null;
            }
            int startIndex = it.getIndex();
            boolean withBraces = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LT);
            if (withBraces) {
                it = it.advance();
            }
            boolean hasOpenedParentheses = false;
            while (!(it.getType() == null || withBraces && Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.GT))) {
                if (!withBraces) {
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LPAREN)) {
                        if (hasOpenedParentheses) break;
                        hasOpenedParentheses = true;
                    }
                    IElementType next = it.rawLookup(1);
                    if (SequentialParserUtil.Companion.isWhitespace(it, 1) || next == null) break;
                    if (Intrinsics.areEqual((Object)next, (Object)MarkdownTokenTypes.RPAREN)) {
                        if (!hasOpenedParentheses) break;
                        hasOpenedParentheses = false;
                    }
                }
                it = it.advance();
            }
            if (it.getType() != null && !hasOpenedParentheses) {
                result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getLINK_DESTINATION()));
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkLabel(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) ^ true) {
                return null;
            }
            int startIndex = it.getIndex();
            ArrayList<Integer> indicesToDelegate = new ArrayList<Integer>();
            it = it.advance();
            while (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) ^ true && it.getType() != null) {
                indicesToDelegate.add(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) break;
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) {
                int endIndex = it.getIndex();
                if (endIndex == startIndex + 1) {
                    return null;
                }
                result.add(new SequentialParser.Node(new IntRange(startIndex, endIndex + 1), MarkdownElementTypes.Companion.getLINK_LABEL()));
                delegateIndices.addAll((Collection<Integer>)indicesToDelegate);
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkText(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) ^ true) {
                return null;
            }
            int startIndex = it.getIndex();
            ArrayList<Integer> indicesToDelegate = new ArrayList<Integer>();
            int bracketDepth = 1;
            it = it.advance();
            while (!(it.getType() == null || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) && --bracketDepth == 0)) {
                indicesToDelegate.add(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
                    ++bracketDepth;
                }
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) {
                result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getLINK_TEXT()));
                delegateIndices.addAll((Collection<Integer>)indicesToDelegate);
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkTitle(@NotNull Collection<SequentialParser.Node> result, @NotNull TokensCache.Iterator iterator) {
            IElementType closingType;
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) {
                return null;
            }
            int startIndex = it.getIndex();
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.DOUBLE_QUOTE)) {
                closingType = it.getType();
            } else if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LPAREN)) {
                closingType = MarkdownTokenTypes.RPAREN;
            } else {
                return null;
            }
            it = it.advance();
            while (it.getType() != null && Intrinsics.areEqual((Object)it.getType(), (Object)closingType) ^ true) {
                it = it.advance();
            }
            if (it.getType() != null) {
                result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getLINK_TITLE()));
                return it;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

