/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final Logger LOG = Logger.getInstance(GradleOrderEnumeratorHandler.class);
    private static final GradleOrderEnumeratorHandler INSTANCE = new GradleOrderEnumeratorHandler();

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return true;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return false;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return false;
    }

    public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler", "addCustomModuleRoots"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler", "addCustomModuleRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler", "addCustomModuleRoots"));
        }
        if (!type.equals((Object)OrderRootType.CLASSES)) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)rootModel.getModule())) {
            return false;
        }
        String gradleProjectPath = rootModel.getModule().getOptionValue("external.root.project.path");
        if (gradleProjectPath == null) {
            LOG.error("Root project path of the Gradle project not found for " + rootModel.getModule());
            return false;
        }
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance(rootModel.getModule().getProject());
        assert (externalProjectDataCache != null);
        ExternalProject externalRootProject = externalProjectDataCache.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
        if (externalRootProject == null) {
            LOG.debug("Root external project was not yep imported for the project path: " + gradleProjectPath);
            return false;
        }
        Map<String, ExternalSourceSet> externalSourceSets = externalProjectDataCache.findExternalProject(externalRootProject, rootModel.getModule());
        if (externalSourceSets.isEmpty()) {
            return false;
        }
        for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
            if (includeTests) {
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), result);
            }
            if (!includeProduction) continue;
            GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), result);
        }
        return true;
    }

    private static void addOutputModuleRoots(@Nullable ExternalSourceDirectorySet directorySet, @NotNull Collection<String> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler", "addOutputModuleRoots"));
        }
        if (directorySet == null) {
            return;
        }
        if (directorySet.isCompilerOutputPathInherited()) {
            return;
        }
        String path = directorySet.getOutputDir().getAbsolutePath();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(path);
        if (virtualFile == null) {
            ApplicationEx app;
            if (!directorySet.getOutputDir().exists()) {
                FileUtil.createDirectory((File)directorySet.getOutputDir());
            }
            if ((app = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread() || !app.holdsReadLock()) {
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directorySet.getOutputDir());
            }
        }
        result.add(VfsUtilCore.pathToUrl((String)path));
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler$FactoryImpl", "isApplicable"));
            }
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension != null && compilerModuleExtension.isCompilerOutputPathInherited()) {
                return false;
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }

        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler$FactoryImpl", "createHandler"));
            }
            return INSTANCE;
        }
    }
}

