/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<ExternalSystemSourceType, String> myCompileOutputPaths;
    @NotNull
    private final String myId;
    @NotNull
    private final String myModuleTypeId;
    @NotNull
    private final String myExternalConfigPath;
    @NotNull
    private String myModuleFileDirectoryPath;
    @Nullable
    private String myGroup;
    @Nullable
    private String myVersion;
    @Nullable
    private String myDescription;
    @NotNull
    private List<File> myArtifacts;
    @Nullable
    private String[] myIdeModuleGroup;
    @Nullable
    private String mySourceCompatibility;
    @Nullable
    private String myTargetCompatibility;
    @Nullable
    private String myProductionModuleId;
    private boolean myInheritProjectCompileOutputPath;

    public ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String name, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (moduleFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFileDirectoryPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (externalConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalConfigPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        super(owner, name, name.replaceAll("(/|\\\\)", "_"));
        this.myCompileOutputPaths = ContainerUtil.newHashMap();
        this.myInheritProjectCompileOutputPath = true;
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.myModuleFileDirectoryPath = moduleFileDirectoryPath;
    }

    protected ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String externalName, @NotNull String internalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (moduleFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFileDirectoryPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (externalConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalConfigPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        super(owner, externalName, FileUtil.sanitizeFileName((String)internalName));
        this.myCompileOutputPaths = ContainerUtil.newHashMap();
        this.myInheritProjectCompileOutputPath = true;
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.myModuleFileDirectoryPath = moduleFileDirectoryPath;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getId"));
        }
        return string;
    }

    @NotNull
    public String getModuleTypeId() {
        String string = this.myModuleTypeId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getModuleTypeId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myExternalConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    @NotNull
    public String getModuleFilePath() {
        String string = ExternalSystemApiUtil.toCanonicalPath(this.myModuleFileDirectoryPath + "/" + this.getInternalName() + ".iml");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getModuleFilePath"));
        }
        return string;
    }

    @NotNull
    public String getModuleFileDirectoryPath() {
        String string = this.myModuleFileDirectoryPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getModuleFileDirectoryPath"));
        }
        return string;
    }

    public void setModuleFileDirectoryPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/model/project/ModuleData", "setModuleFileDirectoryPath"));
        }
        this.myModuleFileDirectoryPath = path2;
    }

    @Nullable
    public String getProductionModuleId() {
        return this.myProductionModuleId;
    }

    public void setProductionModuleId(@Nullable String productionModuleId) {
        this.myProductionModuleId = productionModuleId;
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.myInheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.myInheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    @Nullable
    public String getCompileOutputPath(@NotNull ExternalSystemSourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getCompileOutputPath"));
        }
        return this.myCompileOutputPaths.get(type);
    }

    public void setCompileOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/model/project/ModuleData", "setCompileOutputPath"));
        }
        if (path2 == null) {
            this.myCompileOutputPaths.remove(type);
            return;
        }
        this.myCompileOutputPaths.put(type, ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(@Nullable String group) {
        this.myGroup = group;
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@Nullable String version) {
        this.myVersion = version;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @NotNull
    public List<File> getArtifacts() {
        List<File> list = this.myArtifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getArtifacts"));
        }
        return list;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/openapi/externalSystem/model/project/ModuleData", "setArtifacts"));
        }
        this.myArtifacts = artifacts;
    }

    @Nullable
    public String[] getIdeModuleGroup() {
        return this.myIdeModuleGroup;
    }

    public void setIdeModuleGroup(@Nullable String[] ideModuleGroup) {
        this.myIdeModuleGroup = ideModuleGroup;
    }

    @Nullable
    public String getSourceCompatibility() {
        return this.mySourceCompatibility;
    }

    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.mySourceCompatibility = sourceCompatibility;
    }

    @Nullable
    public String getTargetCompatibility() {
        return this.myTargetCompatibility;
    }

    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.myTargetCompatibility = targetCompatibility;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (this.myGroup != null ? !this.myGroup.equals(that.myGroup) : that.myGroup != null) {
            return false;
        }
        if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        return !(this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myModuleTypeId.hashCode();
        result = 31 * result + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("module '%s:%s:%s'", this.myGroup == null ? "" : this.myGroup, this.getExternalName(), this.myVersion == null ? "" : this.myVersion);
    }
}

