/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

abstract class AbstractScrollBarUI
extends ScrollBarUI {
    static final Key<RegionPainter<Object>> LEADING_AREA = Key.create((String)"PLAIN_SCROLL_BAR_UI_LEADING_AREA");
    private static final JBColor TRACK_BACKGROUND = new JBColor(0xF5F5F5, 3948353);
    private static final JBColor TRACK_FOREGROUND = new JBColor(0xE6E6E6, 3948353);
    private final Listener myListener = new Listener();
    private final Timer myScrollTimer = UIUtil.createNamedTimer((String)"ScrollBarThumbScrollTimer", (int)60, (ActionListener)this.myListener);
    private final Rectangle myThumbBounds = new Rectangle();
    private final Rectangle myTrackBounds = new Rectangle();
    private final Rectangle myLeadingBounds = new Rectangle();
    private JScrollBar myScrollBar;
    private boolean isTrackVisible;
    private boolean isValueCached;
    private int myCachedValue;

    AbstractScrollBarUI() {
    }

    abstract int getThickness();

    abstract int getMinimalThickness();

    abstract void onTrackHover(boolean var1);

    abstract void onThumbHover(boolean var1);

    abstract void paintTrack(Graphics2D var1, int var2, int var3, int var4, int var5, JComponent var6);

    abstract void paintThumb(Graphics2D var1, int var2, int var3, int var4, int var5, JComponent var6);

    void setTrackVisible(boolean trackVisible) {
        if (this.isTrackVisible != trackVisible) {
            this.isTrackVisible = trackVisible;
            this.repaint();
        }
    }

    void repaint() {
        if (this.myScrollBar != null) {
            this.myScrollBar.repaint();
        }
    }

    void repaint(int x, int y, int width, int height) {
        if (this.myScrollBar != null) {
            this.myScrollBar.repaint(x, y, width, height);
        }
    }

    boolean isOpaque() {
        return this.myScrollBar != null && this.myScrollBar.isOpaque();
    }

    int scale(int value) {
        value = JBUI.scale((int)value);
        switch (UIUtil.getComponentStyle((Component)this.myScrollBar)) {
            case LARGE: {
                return (int)((double)value * 1.15);
            }
            case SMALL: {
                return (int)((double)value * 0.857);
            }
            case MINI: {
                return (int)((double)value * 0.714);
            }
        }
        return value;
    }

    @Override
    public void installUI(JComponent c) {
        this.myScrollBar = (JScrollBar)c;
        this.myScrollBar.setBackground((Color)TRACK_BACKGROUND);
        this.myScrollBar.setForeground((Color)TRACK_FOREGROUND);
        this.myScrollBar.setFocusable(false);
        this.myScrollBar.addMouseListener(this.myListener);
        this.myScrollBar.addMouseMotionListener(this.myListener);
        this.myScrollBar.getModel().addChangeListener(this.myListener);
        this.myScrollBar.addPropertyChangeListener(this.myListener);
        this.myScrollBar.addFocusListener(this.myListener);
        this.myScrollTimer.setInitialDelay(300);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.myScrollTimer.stop();
        this.myScrollBar.removeFocusListener(this.myListener);
        this.myScrollBar.removePropertyChangeListener(this.myListener);
        this.myScrollBar.getModel().removeChangeListener(this.myListener);
        this.myScrollBar.removeMouseMotionListener(this.myListener);
        this.myScrollBar.removeMouseListener(this.myListener);
        this.myScrollBar = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int thickness = this.getThickness();
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        return alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        if (alignment != null && g instanceof Graphics2D) {
            int size;
            Rectangle bounds = new Rectangle(c.getSize());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)c.getInsets());
            if (c.isOpaque() && c.getParent() instanceof JScrollPane) {
                g.setColor(c.getForeground());
                switch (alignment) {
                    case TOP: {
                        --bounds.height;
                        g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
                        break;
                    }
                    case LEFT: {
                        --bounds.width;
                        g.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
                        break;
                    }
                    case RIGHT: {
                        g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
                        --bounds.width;
                        ++bounds.x;
                        break;
                    }
                    case BOTTOM: {
                        g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
                        --bounds.height;
                        ++bounds.y;
                    }
                }
            } else if (this.isTrackVisible) {
                this.paintTrack((Graphics2D)g, bounds.x, bounds.y, bounds.width, bounds.height, c);
            }
            RegionPainter leading = (RegionPainter)UIUtil.getClientProperty((JComponent)c, LEADING_AREA);
            if (leading == null) {
                this.myLeadingBounds.setSize(0, 0);
            } else if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                size = bounds.width;
                this.myLeadingBounds.setBounds(bounds.x, bounds.y, size, size);
                leading.paint((Graphics2D)g, bounds.x, bounds.y, size, size, null);
                bounds.height -= size;
                bounds.y += size;
            } else {
                size = bounds.height;
                this.myLeadingBounds.setBounds(bounds.x, bounds.y, size, size);
                leading.paint((Graphics2D)g, bounds.x, bounds.y, size, size, null);
                bounds.width -= size;
                bounds.x += size;
            }
            this.myTrackBounds.setBounds(bounds);
            RegionPainter track = (RegionPainter)UIUtil.getClientProperty((JComponent)c, JBScrollBar.TRACK);
            if (track != null && this.myTrackBounds.width > 0 && this.myTrackBounds.height > 0) {
                track.paint((Graphics2D)g, this.myTrackBounds.x, this.myTrackBounds.y, this.myTrackBounds.width, this.myTrackBounds.height, null);
            }
            this.updateThumbBounds();
            if (this.myThumbBounds.width > 0 && this.myThumbBounds.height > 0) {
                this.paintThumb((Graphics2D)g, this.myThumbBounds.x, this.myThumbBounds.y, this.myThumbBounds.width, this.myThumbBounds.height, c);
            }
        }
    }

    private void updateThumbBounds() {
        int min = this.myScrollBar.getMinimum();
        int max = this.myScrollBar.getMaximum();
        int range = max - min;
        if (range <= 0) {
            this.myThumbBounds.setBounds(0, 0, 0, 0);
        } else if (1 == this.myScrollBar.getOrientation()) {
            int extent = this.myScrollBar.getVisibleAmount();
            int height = Math.max(this.myTrackBounds.height * extent / range, 2 * this.getThickness());
            if (this.myTrackBounds.height <= height) {
                this.myThumbBounds.setBounds(0, 0, 0, 0);
            } else {
                int value = this.getValue();
                int maxY = this.myTrackBounds.y + this.myTrackBounds.height - height;
                int y = value < max - extent ? (this.myTrackBounds.height - height) * (value - min) / (range - extent) : maxY;
                this.myThumbBounds.setBounds(this.myTrackBounds.x, AbstractScrollBarUI.adjust(y, this.myTrackBounds.y, maxY), this.myTrackBounds.width, height);
            }
        } else {
            int extent = this.myScrollBar.getVisibleAmount();
            int width = Math.max(this.myTrackBounds.width * extent / range, 2 * this.getThickness());
            if (this.myTrackBounds.width <= width) {
                this.myThumbBounds.setBounds(0, 0, 0, 0);
            } else {
                int x;
                int value = this.getValue();
                int maxX = this.myTrackBounds.x + this.myTrackBounds.width - width;
                int n = x = value < max - extent ? (this.myTrackBounds.width - width) * (value - min) / (range - extent) : maxX;
                if (!this.myScrollBar.getComponentOrientation().isLeftToRight()) {
                    x = this.myTrackBounds.x - x + maxX;
                }
                this.myThumbBounds.setBounds(AbstractScrollBarUI.adjust(x, this.myTrackBounds.x, maxX), this.myTrackBounds.y, width, this.myTrackBounds.height);
            }
        }
    }

    private int getValue() {
        return this.isValueCached ? this.myCachedValue : this.myScrollBar.getValue();
    }

    private static int adjust(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private final class Listener
    extends MouseAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener,
    PropertyChangeListener {
        private int myOffset;
        private int myMouseX;
        private int myMouseY;
        private boolean isReversed;
        private boolean isDragging;
        private boolean isOverTrack;
        private boolean isOverThumb;

        private Listener() {
        }

        private void updateMouse(int x, int y) {
            if (AbstractScrollBarUI.this.myTrackBounds.contains(x, y)) {
                boolean hover;
                if (!this.isOverTrack) {
                    this.isOverTrack = true;
                    AbstractScrollBarUI.this.onTrackHover(true);
                }
                if (this.isOverThumb != (hover = AbstractScrollBarUI.this.myThumbBounds.contains(x, y))) {
                    this.isOverThumb = hover;
                    AbstractScrollBarUI.this.onThumbHover(this.isOverThumb);
                }
            } else {
                this.updateMouseExit();
            }
        }

        private void updateMouseExit() {
            if (this.isOverThumb) {
                this.isOverThumb = false;
                AbstractScrollBarUI.this.onThumbHover(false);
            }
            if (this.isOverTrack) {
                this.isOverTrack = false;
                AbstractScrollBarUI.this.onTrackHover(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean vertical;
            if (AbstractScrollBarUI.this.myScrollBar == null || !AbstractScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            AbstractScrollBarUI.this.isValueCached = true;
            AbstractScrollBarUI.this.myCachedValue = AbstractScrollBarUI.this.myScrollBar.getValue();
            AbstractScrollBarUI.this.myScrollBar.setValueIsAdjusting(true);
            this.myMouseX = event.getX();
            this.myMouseY = event.getY();
            boolean bl = vertical = 1 == AbstractScrollBarUI.this.myScrollBar.getOrientation();
            if (AbstractScrollBarUI.this.myThumbBounds.contains(this.myMouseX, this.myMouseY)) {
                this.myOffset = vertical ? this.myMouseY - ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y : this.myMouseX - ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x;
                this.isDragging = true;
            } else if (AbstractScrollBarUI.this.isTrackVisible && AbstractScrollBarUI.this.myTrackBounds.contains(this.myMouseX, this.myMouseY)) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    this.myOffset = (vertical ? ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.height : ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.width) / 2;
                    this.isDragging = true;
                    this.setValueFrom(event);
                } else {
                    AbstractScrollBarUI.this.myScrollTimer.stop();
                    this.isDragging = false;
                    if (1 == AbstractScrollBarUI.this.myScrollBar.getOrientation()) {
                        int y = AbstractScrollBarUI.this.myThumbBounds.isEmpty() ? AbstractScrollBarUI.this.myScrollBar.getHeight() / 2 : ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y;
                        this.isReversed = this.myMouseY < y;
                    } else {
                        int x = AbstractScrollBarUI.this.myThumbBounds.isEmpty() ? AbstractScrollBarUI.this.myScrollBar.getWidth() / 2 : ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x;
                        boolean bl2 = this.isReversed = this.myMouseX < x;
                        if (!AbstractScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight()) {
                            this.isReversed = !this.isReversed;
                        }
                    }
                    this.scroll(this.isReversed);
                    this.startScrollTimerIfNecessary();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
            if (AbstractScrollBarUI.this.myScrollBar == null || !AbstractScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.isDragging = false;
            this.myOffset = 0;
            AbstractScrollBarUI.this.myScrollTimer.stop();
            AbstractScrollBarUI.this.isValueCached = true;
            AbstractScrollBarUI.this.myCachedValue = AbstractScrollBarUI.this.myScrollBar.getValue();
            AbstractScrollBarUI.this.myScrollBar.setValueIsAdjusting(false);
            AbstractScrollBarUI.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (AbstractScrollBarUI.this.myScrollBar == null || !AbstractScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (AbstractScrollBarUI.this.myThumbBounds.isEmpty() || SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (this.isDragging) {
                this.setValueFrom(event);
            } else {
                this.myMouseX = event.getX();
                this.myMouseY = event.getY();
                this.updateMouse(this.myMouseX, this.myMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (AbstractScrollBarUI.this.myScrollBar == null || !AbstractScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (AbstractScrollBarUI.this.myScrollBar == null || !AbstractScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouseExit();
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (AbstractScrollBarUI.this.myScrollBar == null) {
                AbstractScrollBarUI.this.myScrollTimer.stop();
            } else {
                this.scroll(this.isReversed);
                if (!AbstractScrollBarUI.this.myThumbBounds.isEmpty() && (this.isReversed ? !this.isMouseBeforeThumb() : !this.isMouseAfterThumb())) {
                    AbstractScrollBarUI.this.myScrollTimer.stop();
                }
                int value = AbstractScrollBarUI.this.myScrollBar.getValue();
                if (this.isReversed ? value <= AbstractScrollBarUI.this.myScrollBar.getMinimum() : value >= AbstractScrollBarUI.this.myScrollBar.getMaximum() - AbstractScrollBarUI.this.myScrollBar.getVisibleAmount()) {
                    AbstractScrollBarUI.this.myScrollTimer.stop();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            AbstractScrollBarUI.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            AbstractScrollBarUI.this.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            AbstractScrollBarUI.this.updateThumbBounds();
            AbstractScrollBarUI.this.isValueCached = false;
            AbstractScrollBarUI.this.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if ("model" == name) {
                BoundedRangeModel oldModel = (BoundedRangeModel)event.getOldValue();
                BoundedRangeModel newModel = (BoundedRangeModel)event.getNewValue();
                oldModel.removeChangeListener(this);
                newModel.addChangeListener(this);
            }
            if ("model" == name || "orientation" == name || "componentOrientation" == name) {
                AbstractScrollBarUI.this.repaint();
            }
        }

        private void setValueFrom(MouseEvent event) {
            boolean isDefaultOrientation;
            int thumbPos;
            int thumbMin;
            int thumbMax;
            int x = event.getX();
            int y = event.getY();
            if (1 == AbstractScrollBarUI.this.myScrollBar.getOrientation()) {
                thumbMax = ((AbstractScrollBarUI)AbstractScrollBarUI.this).myTrackBounds.y + ((AbstractScrollBarUI)AbstractScrollBarUI.this).myTrackBounds.height - ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.height;
                thumbMin = ((AbstractScrollBarUI)AbstractScrollBarUI.this).myTrackBounds.y;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, y - this.myOffset));
                if (((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y != thumbPos) {
                    int minY = Math.min(((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y, thumbPos);
                    int maxY = Math.max(((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y, thumbPos) + ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.height;
                    ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y = thumbPos;
                    AbstractScrollBarUI.this.repaint(((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x, minY, ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.width, maxY - minY);
                }
            } else {
                thumbMax = ((AbstractScrollBarUI)AbstractScrollBarUI.this).myTrackBounds.x + ((AbstractScrollBarUI)AbstractScrollBarUI.this).myTrackBounds.width - ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.width;
                thumbMin = ((AbstractScrollBarUI)AbstractScrollBarUI.this).myTrackBounds.x;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, x - this.myOffset));
                if (((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x != thumbPos) {
                    int minX = Math.min(((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x, thumbPos);
                    int maxX = Math.max(((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x, thumbPos) + ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.width;
                    ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x = thumbPos;
                    AbstractScrollBarUI.this.repaint(minX, ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y, maxX - minX, ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.height);
                }
            }
            int valueMin = AbstractScrollBarUI.this.myScrollBar.getMinimum();
            int valueMax = AbstractScrollBarUI.this.myScrollBar.getMaximum() - AbstractScrollBarUI.this.myScrollBar.getVisibleAmount();
            boolean bl = isDefaultOrientation = 1 == AbstractScrollBarUI.this.myScrollBar.getOrientation() || AbstractScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight();
            if (thumbPos == thumbMax) {
                AbstractScrollBarUI.this.myScrollBar.setValue(isDefaultOrientation ? valueMax : valueMin);
            } else {
                int valueRange = valueMax - valueMin;
                int thumbRange = thumbMax - thumbMin;
                int thumbValue = isDefaultOrientation ? thumbPos - thumbMin : thumbMax - thumbPos;
                AbstractScrollBarUI.this.isValueCached = true;
                AbstractScrollBarUI.this.myCachedValue = valueMin + valueRange * thumbValue / thumbRange;
                AbstractScrollBarUI.this.myScrollBar.setValue(AbstractScrollBarUI.this.myCachedValue);
            }
            if (!this.isDragging) {
                this.updateMouse(x, y);
            }
        }

        private void startScrollTimerIfNecessary() {
            if (!AbstractScrollBarUI.this.myScrollTimer.isRunning() && (this.isReversed ? this.isMouseBeforeThumb() : this.isMouseAfterThumb())) {
                AbstractScrollBarUI.this.myScrollTimer.start();
            }
        }

        private boolean isMouseBeforeThumb() {
            return 1 == AbstractScrollBarUI.this.myScrollBar.getOrientation() ? this.isMouseOnTop() : (AbstractScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnLeft() : this.isMouseOnRight());
        }

        private boolean isMouseAfterThumb() {
            return 1 == AbstractScrollBarUI.this.myScrollBar.getOrientation() ? this.isMouseOnBottom() : (AbstractScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnRight() : this.isMouseOnLeft());
        }

        private boolean isMouseOnTop() {
            return this.myMouseY < ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y;
        }

        private boolean isMouseOnLeft() {
            return this.myMouseX < ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x;
        }

        private boolean isMouseOnRight() {
            return this.myMouseX > ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.x + ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.width;
        }

        private boolean isMouseOnBottom() {
            return this.myMouseY > ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.y + ((AbstractScrollBarUI)AbstractScrollBarUI.this).myThumbBounds.height;
        }

        private void scroll(boolean reversed) {
            int delta = AbstractScrollBarUI.this.myScrollBar.getBlockIncrement(reversed ? -1 : 1);
            if (reversed) {
                delta = -delta;
            }
            int oldValue = AbstractScrollBarUI.this.myScrollBar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = AbstractScrollBarUI.this.myScrollBar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = AbstractScrollBarUI.this.myScrollBar.getMinimum();
            }
            if (oldValue != newValue) {
                AbstractScrollBarUI.this.myScrollBar.setValue(newValue);
            }
        }
    }
}

