/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NSScrollerHelper;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jetbrains.annotations.NotNull;

public class ButtonlessScrollBarUI
extends BasicScrollBarUI {
    public static final Key<RegionPainter<Integer>> MAXI_THUMB = Key.create((String)"BUTTONLESS_SCROLL_BAR_UI_MAXI_THUMB");
    private static final Logger LOG = Logger.getInstance((String)("#" + ButtonlessScrollBarUI.class.getName()));
    private final AdjustmentListener myAdjustmentListener = new AdjustmentListener(){
        Point oldViewportPosition = null;
        Dimension oldViewportDimension = null;

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            JViewport viewport;
            JScrollPane scrollpane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, ButtonlessScrollBarUI.this.scrollbar);
            JViewport jViewport = viewport = scrollpane == null ? null : scrollpane.getViewport();
            if (viewport == null) {
                this.oldViewportPosition = null;
                return;
            }
            boolean vertical = ButtonlessScrollBarUI.this.isVertical();
            Point position = viewport.getViewPosition();
            Dimension dimension = scrollpane.getSize();
            boolean scrolled = false;
            if (this.oldViewportPosition != null) {
                int scrollH = position.x - this.oldViewportPosition.x;
                int scrollV = position.y - this.oldViewportPosition.y;
                scrolled = vertical && scrollH == 0 && scrollV != 0 || !vertical && scrollV == 0 && scrollH != 0;
            }
            this.oldViewportPosition = position;
            boolean resized = false;
            if (this.oldViewportDimension != null) {
                int resizedH = dimension.width - this.oldViewportDimension.width;
                int resizedV = dimension.height - this.oldViewportDimension.height;
                resized = vertical && resizedV != 0 || !vertical && resizedH != 0;
            }
            this.oldViewportDimension = dimension;
            if (scrolled) {
                ScrollBarUI otherUI;
                JScrollBar other = vertical ? scrollpane.getHorizontalScrollBar() : scrollpane.getVerticalScrollBar();
                ScrollBarUI scrollBarUI = otherUI = other == null ? null : other.getUI();
                if (otherUI instanceof ButtonlessScrollBarUI) {
                    ((ButtonlessScrollBarUI)otherUI).startMacScrollbarFadeout(true);
                }
                ButtonlessScrollBarUI.this.restart();
            } else if (resized) {
                ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
            }
        }
    };
    private final MouseMotionAdapter myMouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean inside = ButtonlessScrollBarUI.this.isOverThumb(e.getPoint());
            if (inside != ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                ButtonlessScrollBarUI.this.myMouseIsOverThumb = inside;
                ButtonlessScrollBarUI.this.startRegularThumbAnimator();
            }
        }
    };
    private final MouseAdapter myMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            if (ButtonlessScrollBarUI.this.myMacScrollbarFadeLevel == 0.0) {
                ButtonlessScrollBarUI.this.myMouseOverScrollbar = true;
                ButtonlessScrollBarUI.this.startMacScrollbarExpandAnimator();
                ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                ButtonlessScrollBarUI.this.myMouseIsOverThumb = false;
                ButtonlessScrollBarUI.this.startRegularThumbAnimator();
            }
            if (ButtonlessScrollBarUI.this.myMouseOverScrollbar) {
                ButtonlessScrollBarUI.this.myMouseOverScrollbar = false;
                ButtonlessScrollBarUI.this.startMacScrollbarExpandAnimator();
                ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
            }
        }
    };
    private final HierarchyListener myHierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChanged() == ButtonlessScrollBarUI.this.scrollbar && (2L & e.getChangeFlags()) != 0L) {
                ButtonlessScrollBarUI.this.updateGlobalListeners(false);
            }
            if (e.getChanged() == ButtonlessScrollBarUI.this.scrollbar.getParent() && (4L & e.getChangeFlags()) != 0L) {
                ButtonlessScrollBarUI.this.restart();
            }
        }
    };
    private final AWTEventListener myAWTMouseListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            Container scrollpane;
            if (event.getID() == 503 && (scrollpane = SwingUtilities.getAncestorOfClass(JScrollPane.class, ButtonlessScrollBarUI.this.scrollbar)) != null) {
                Point loc = ((MouseEvent)event).getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(loc, scrollpane);
                if (scrollpane.contains(loc) && !ButtonlessScrollBarUI.this.myMacScrollbarHidden && ButtonlessScrollBarUI.this.myMacScrollbarFadeLevel == 0.0) {
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }
        }
    };
    private final NSScrollerHelper.ScrollbarStyleListener myNSScrollerListener = new NSScrollerHelper.ScrollbarStyleListener(){

        @Override
        public void styleChanged() {
            ButtonlessScrollBarUI.this.updateMacScrollbarStyle();
        }
    };
    private boolean myGlobalListenersAdded;
    public static final int DELAY_FRAMES = 4;
    public static final int FRAMES_COUNT = 14;
    private Animator myThumbFadeAnimator;
    private int myThumbFadeColorShift = 0;
    private boolean myMouseIsOverThumb = false;
    private boolean myMouseOverScrollbar;
    private double myMouseOverScrollbarExpandLevel = 0.0;
    private NSScrollerHelper.Style myMacScrollerStyle;
    private Animator myMouseOverScrollbarExpandAnimator;
    private Alarm myMacScrollbarFadeTimer;
    private Animator myMacScrollbarFadeAnimator;
    private double myMacScrollbarFadeLevel = 0.0;
    private boolean myMacScrollbarHidden;
    private ScrollbarRepaintCallback myRepaintCallback;
    private static final Method setValueFrom = ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.TrackListener.class, (String)"setValueFrom", (Class[])new Class[]{MouseEvent.class});

    protected JBColor getGradientLightColor() {
        return this.jbColor((Color)Gray._251, (Color)Gray._95);
    }

    protected JBColor getGradientDarkColor() {
        return this.jbColor((Color)Gray._215, (Color)Gray._80);
    }

    public static JBColor getTrackBackgroundDefault() {
        return new JBColor(LightColors.SLIGHTLY_GRAY, UIUtil.getListBackground());
    }

    public static JBColor getTrackBorderColorDefault() {
        return new JBColor((Color)Gray._230, UIUtil.getListBackground());
    }

    private JBColor getTrackBackground() {
        return this.jbColor(LightColors.SLIGHTLY_GRAY, UIUtil.getListBackground());
    }

    private JBColor getTrackBorderColor() {
        return this.jbColor((Color)Gray._230, UIUtil.getListBackground());
    }

    private JBColor jbColor(final Color regular, final Color dark) {
        return new JBColor((NotNullProducer)new NotNullProducer<Color>(){

            @NotNull
            public Color produce() {
                Color color = ButtonlessScrollBarUI.this.isDark() ? dark : regular;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ButtonlessScrollBarUI$1", "produce"));
                }
                return color;
            }
        });
    }

    private int getAnimationColorShift() {
        return this.isDark() ? 20 : 40;
    }

    protected ButtonlessScrollBarUI() {
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new BasicScrollBarUI.ArrowButtonListener(){

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }
        };
    }

    protected boolean isMacOverlayScrollbar() {
        return this.myMacScrollerStyle == NSScrollerHelper.Style.Overlay && ButtonlessScrollBarUI.isMacOverlayScrollbarSupported();
    }

    public static boolean isMacOverlayScrollbarSupported() {
        return SystemInfo.isMac && !Registry.is((String)"ide.mac.disableMacScrollbars");
    }

    private void updateMacScrollbarStyle() {
        NSScrollerHelper.Style style = NSScrollerHelper.getScrollerStyle();
        if (style != this.myMacScrollerStyle && this.scrollbar != null) {
            this.myMacScrollerStyle = style;
            this.updateStyleDefaults();
            this.restart();
            JScrollPane pane = JBScrollPane.findScrollPane(this.scrollbar);
            if (pane != null) {
                pane.revalidate();
            }
        }
    }

    public boolean alwaysShowTrack() {
        return !this.isMacOverlayScrollbar();
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        int h;
        int w;
        if (width > 0 && height > 0 && UIManager.getBoolean("ScrollBar.alwaysShowThumb") && !this.alwaysShowTrack() && ((w = this.trackRect.width) > (h = this.trackRect.height) && w == width || w < h && h == height)) {
            height = 0;
            width = 0;
            y = 0;
            x = 0;
        }
        if (this.myRepaintCallback != null) {
            this.scrollbar.repaint(this.trackRect);
        }
        super.setThumbBounds(x, y, width, height);
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    public int getDecrementButtonHeight() {
        return Math.max(0, this.decrButton.getHeight());
    }

    public int getIncrementButtonHeight() {
        return Math.max(0, this.incrButton.getHeight());
    }

    private void startRegularThumbAnimator() {
        if (this.isMacOverlayScrollbar()) {
            return;
        }
        this.myThumbFadeAnimator.reset();
        if (this.scrollbar != null && this.scrollbar.getValueIsAdjusting() || this.myMouseIsOverThumb || Registry.is((String)"ui.no.bangs.and.whistles")) {
            this.myThumbFadeAnimator.suspend();
            this.myThumbFadeColorShift = this.getAnimationColorShift();
        } else {
            this.myThumbFadeAnimator.resume();
        }
    }

    private void startMacScrollbarExpandAnimator() {
        if (!this.isMacOverlayScrollbar()) {
            return;
        }
        if (this.myMouseOverScrollbarExpandLevel == 0.0) {
            this.myMouseOverScrollbarExpandAnimator.reset();
            this.myMouseOverScrollbarExpandAnimator.suspend();
            if (this.myMouseOverScrollbar) {
                this.myMouseOverScrollbarExpandAnimator.resume();
            }
        }
    }

    private void startMacScrollbarFadeout() {
        this.startMacScrollbarFadeout(false);
    }

    private void startMacScrollbarFadeout(boolean now) {
        if (!this.isMacOverlayScrollbar()) {
            return;
        }
        this.myMacScrollbarFadeTimer.cancelAllRequests();
        if (now) {
            if (!this.myMacScrollbarHidden && !this.myMacScrollbarFadeAnimator.isRunning()) {
                this.myMacScrollbarFadeAnimator.resume();
            }
            return;
        }
        this.myMacScrollbarFadeAnimator.suspend();
        this.myMacScrollbarFadeAnimator.reset();
        this.myMacScrollbarHidden = false;
        this.myMacScrollbarFadeLevel = 0.0;
        JScrollBar sb = this.scrollbar;
        if (sb != null) {
            sb.repaint();
            Application application = ApplicationManager.getApplication();
            if (!(this.myMouseOverScrollbar || sb.getValueIsAdjusting() || application != null && application.isUnitTestMode())) {
                this.myMacScrollbarFadeTimer.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        ButtonlessScrollBarUI.this.myMacScrollbarFadeAnimator.resume();
                    }
                }, 700, (ModalityState)null);
            }
        }
    }

    public static BasicScrollBarUI createNormal() {
        return new ButtonlessScrollBarUI();
    }

    public static BasicScrollBarUI createTransparent() {
        return new Transparent();
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
        this.myMacScrollerStyle = NSScrollerHelper.getScrollerStyle();
        this.scrollbar.setFocusable(false);
        this.updateStyleDefaults();
    }

    private void updateStyleDefaults() {
        this.scrollbar.setOpaque(this.alwaysShowTrack());
    }

    @Override
    protected void installListeners() {
        this.initRegularThumbAnimator();
        this.initMacScrollbarAnimators();
        super.installListeners();
        this.scrollbar.addAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.addMouseListener(this.myMouseListener);
        this.scrollbar.addMouseMotionListener(this.myMouseMotionListener);
        this.scrollbar.addHierarchyListener(this.myHierarchyListener);
        this.updateGlobalListeners(false);
        this.restart();
    }

    private void restart() {
        this.startRegularThumbAnimator();
        this.startMacScrollbarFadeout();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new BasicScrollBarUI.TrackListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ButtonlessScrollBarUI.this.scrollbar.isEnabled() && SwingUtilities.isLeftMouseButton(e) && !ButtonlessScrollBarUI.this.getThumbBounds().contains(e.getPoint()) && NSScrollerHelper.getClickBehavior() == NSScrollerHelper.ClickBehavior.JumpToSpot && setValueFrom != null) {
                    switch (ButtonlessScrollBarUI.this.scrollbar.getOrientation()) {
                        case 1: {
                            this.offset = ButtonlessScrollBarUI.this.getThumbBounds().height / 2;
                            break;
                        }
                        case 0: {
                            this.offset = ButtonlessScrollBarUI.this.getThumbBounds().width / 2;
                        }
                    }
                    ButtonlessScrollBarUI.this.isDragging = true;
                    try {
                        setValueFrom.invoke((Object)this, e);
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                    return;
                }
                super.mousePressed(e);
            }
        };
    }

    private void updateGlobalListeners(boolean forceRemove) {
        boolean shouldAdd = this.scrollbar.isDisplayable();
        if (this.myGlobalListenersAdded && (!shouldAdd || forceRemove)) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAWTMouseListener);
            NSScrollerHelper.removeScrollbarStyleListener(this.myNSScrollerListener);
            this.myGlobalListenersAdded = false;
        }
        if (!this.myGlobalListenersAdded && shouldAdd && !forceRemove) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myAWTMouseListener, 32L);
            NSScrollerHelper.addScrollbarStyleListener(this.myNSScrollerListener);
            this.myGlobalListenersAdded = true;
        }
    }

    private void initRegularThumbAnimator() {
        this.myThumbFadeAnimator = new Animator("Regular scrollbar thumb animator", 14, 700, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                ButtonlessScrollBarUI.this.myThumbFadeColorShift = ButtonlessScrollBarUI.this.getAnimationColorShift();
                if (frame > 4) {
                    ButtonlessScrollBarUI.this.myThumbFadeColorShift = (int)((double)ButtonlessScrollBarUI.this.myThumbFadeColorShift * (1.0 - (double)(frame - 4) / (double)(totalFrames - 4)));
                }
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint(((ButtonlessScrollBarUI)ButtonlessScrollBarUI.this.scrollbar.getUI()).getThumbBounds());
                }
            }
        };
    }

    private void initMacScrollbarAnimators() {
        this.myMouseOverScrollbarExpandAnimator = new Animator("Mac scrollbar mouse over animator", 10, 200, false){

            @Override
            protected void paintCycleEnd() {
                ButtonlessScrollBarUI.this.myMouseOverScrollbarExpandLevel = 1.0;
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint();
                }
            }

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                int delay = totalFrames / 2;
                int frameAfterDelay = frame - delay;
                if (frameAfterDelay > 0) {
                    ButtonlessScrollBarUI.this.myMouseOverScrollbarExpandLevel = (float)frameAfterDelay / (float)(totalFrames - delay);
                    if (ButtonlessScrollBarUI.this.scrollbar != null) {
                        ButtonlessScrollBarUI.this.scrollbar.repaint();
                    }
                }
            }
        };
        this.myMacScrollbarFadeTimer = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myMacScrollbarFadeAnimator = new Animator("Mac scrollbar fade animator", 30, 300, false){

            @Override
            protected void paintCycleEnd() {
                ButtonlessScrollBarUI.this.myMacScrollbarHidden = true;
                ButtonlessScrollBarUI.this.myMouseOverScrollbar = false;
                ButtonlessScrollBarUI.this.myMouseOverScrollbarExpandLevel = 0.0;
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint();
                }
            }

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                ButtonlessScrollBarUI.this.myMacScrollbarFadeLevel = (float)frame / (float)totalFrames;
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint();
                }
            }
        };
    }

    private boolean isOverThumb(Point p) {
        Rectangle bounds = this.getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.removeMouseListener(this.myMouseListener);
        this.scrollbar.removeMouseMotionListener(this.myMouseMotionListener);
        this.scrollbar.removeHierarchyListener(this.myHierarchyListener);
        this.updateGlobalListeners(true);
        Disposer.dispose((Disposable)this.myThumbFadeAnimator);
        Disposer.dispose((Disposable)this.myMouseOverScrollbarExpandAnimator);
        Disposer.dispose((Disposable)this.myMacScrollbarFadeTimer);
        Disposer.dispose((Disposable)this.myMacScrollbarFadeAnimator);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int thickness = this.getThickness();
        return this.isVertical() ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    protected int getThickness() {
        return this.isMacOverlayScrollbar() ? JBUI.scale((int)15) : JBUI.scale((int)13);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int thickness = this.getThickness();
        return new Dimension(thickness, thickness);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.isMacOverlayScrollbar() && !this.alwaysShowTrack() && !this.alwaysPaintThumb() && this.myMacScrollbarHidden) {
            return false;
        }
        return super.contains(c, x, y);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        RegionPainter painter;
        if (this.alwaysShowTrack() || this.myMouseOverScrollbarExpandLevel > 0.0) {
            this.doPaintTrack(g, c, trackBounds);
        }
        if ((painter = (RegionPainter)UIUtil.getClientProperty((JComponent)c, JBScrollBar.TRACK)) != null) {
            painter.paint((Graphics2D)g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null);
        }
    }

    protected void doPaintTrack(Graphics g, JComponent c, Rectangle bounds) {
        if (this.isMacOverlayScrollbar() && !this.alwaysShowTrack()) {
            bounds = this.getMacScrollBarBounds(bounds, false);
            boolean vertical = this.isVertical();
            Color start = this.adjustColor(UIUtil.getSlightlyDarkerColor((Color)this.getTrackBackground()));
            Color end = this.adjustColor(this.getTrackBackground().brighter());
            Paint paint = vertical ? UIUtil.getGradientPaint((float)(bounds.x + 1), (float)bounds.y, (Color)start, (float)(bounds.width + 1), (float)bounds.y, (Color)end) : UIUtil.getGradientPaint((float)bounds.x, (float)(bounds.y + 1), (Color)start, (float)bounds.x, (float)(bounds.height + 1), (Color)end);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(paint);
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(this.adjustColor(start.darker()));
        } else {
            g.setColor((Color)this.getTrackBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor((Color)this.getTrackBorderColor());
        }
        if (this.isVertical()) {
            int x = this.scrollbar.getComponentOrientation().isLeftToRight() ? bounds.x : bounds.x + bounds.width - 1;
            g.drawLine(x, bounds.y, x, bounds.y + bounds.height);
        } else {
            g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
        }
        if (this.myRepaintCallback != null) {
            this.myRepaintCallback.call(g);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        this.doPaintThumb(g, thumbBounds);
    }

    private void doPaintThumb(Graphics g, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (this.isMacOverlayScrollbar()) {
            this.paintMacThumb(g, thumbBounds);
        } else {
            RegionPainter painter = (RegionPainter)UIUtil.getClientProperty((JComponent)this.scrollbar, MAXI_THUMB);
            if (painter != null) {
                painter.paint((Graphics2D)g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, this.myThumbFadeColorShift);
            } else {
                g.translate(thumbBounds.x, thumbBounds.y);
                this.paintMaxiThumb((Graphics2D)g, thumbBounds);
                g.translate(-thumbBounds.x, -thumbBounds.y);
            }
        }
    }

    private void paintMacThumb(Graphics g, Rectangle thumbBounds) {
        if (this.isMacScrollbarHiddenAndXcodeLikeScrollbar()) {
            return;
        }
        thumbBounds = this.getMacScrollBarBounds(thumbBounds, true);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints oldHints = g2d.getRenderingHints();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JBColor baseColor = new JBColor((NotNullProducer)new NotNullProducer<Color>(){

            @NotNull
            public Color produce() {
                Gray gray = !ButtonlessScrollBarUI.this.isDark() ? Gray._0 : Gray._128;
                if (gray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ButtonlessScrollBarUI$15", "produce"));
                }
                return gray;
            }
        });
        int arc = Math.min(thumbBounds.width, thumbBounds.height);
        if (this.alwaysPaintThumb()) {
            g2d.setColor(new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), this.isDark() ? 100 : 40));
            g2d.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
        }
        if (!this.myMacScrollbarHidden) {
            g2d.setColor(this.adjustColor((Color)baseColor));
            g2d.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
        }
        g2d.setRenderingHints(oldHints);
    }

    protected boolean isDark() {
        return UIUtil.isUnderDarcula();
    }

    protected boolean alwaysPaintThumb() {
        return this.alwaysShowTrack();
    }

    protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
        int height;
        int width;
        boolean vertical = this.isVertical();
        int borderSize = 2;
        int baseSize = vertical ? baseBounds.width : baseBounds.height;
        int maxSize = baseSize - (thumb ? borderSize * 2 : 0);
        int minSize = Math.min(baseSize / 2, 7) + (thumb ? 0 : borderSize * 2);
        int currentSize = minSize + (int)(this.myMouseOverScrollbarExpandLevel * (double)(maxSize - minSize));
        int currentBolderSize = thumb ? borderSize : 0;
        int x = baseBounds.x;
        int y = baseBounds.y;
        if (vertical) {
            x += baseBounds.width - currentSize - currentBolderSize;
            y += currentBolderSize;
            width = currentSize;
            height = baseBounds.height - currentBolderSize * 2;
        } else {
            x += currentBolderSize;
            y += baseBounds.height - currentSize - currentBolderSize;
            width = baseBounds.width - currentBolderSize * 2;
            height = currentSize;
        }
        width = Math.max(width, currentSize);
        height = Math.max(height, currentSize);
        return new Rectangle(x, y, width, height);
    }

    protected void paintMaxiThumb(Graphics2D g, Rectangle thumbBounds) {
        ThumbPainter.DEFAULT.setScrollBar(this.scrollbar);
        ThumbPainter.DEFAULT.paint(g, 0, 0, thumbBounds.width, thumbBounds.height, this.myThumbFadeColorShift);
        ThumbPainter.DEFAULT.setScrollBar(null);
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected Color adjustColor(Color c) {
        if (this.isMacOverlayScrollbar()) {
            int alpha = (int)((120.0 + this.myMouseOverScrollbarExpandLevel * 20.0) * (1.0 - this.myMacScrollbarFadeLevel));
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        if (this.myThumbFadeColorShift == 0) {
            return c;
        }
        int sign = this.isDark() ? -1 : 1;
        return Gray.get((int)Math.max(0, Math.min(255, c.getRed() - sign * this.myThumbFadeColorShift)));
    }

    protected boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    protected boolean isMacScrollbarHiddenAndXcodeLikeScrollbar() {
        return this.myMacScrollbarHidden && ButtonlessScrollBarUI.isMacOverlayScrollbarSupported() && ButtonlessScrollBarUI.xcodeLikeScrollbar();
    }

    protected static boolean xcodeLikeScrollbar() {
        return Registry.is((String)"editor.xcode.like.scrollbar");
    }

    public void registerRepaintCallback(ScrollbarRepaintCallback callback) {
        this.myRepaintCallback = callback;
    }

    static {
        LOG.assertTrue(setValueFrom != null, (Object)"Cannot get TrackListener.setValueFrom method");
    }

    public static class Transparent
    extends ButtonlessScrollBarUI {
        @Override
        public boolean alwaysShowTrack() {
            return false;
        }

        @Override
        protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            if (!this.isMacOverlayScrollbar()) {
                int half = this.getThickness() / 2;
                int shiftX = this.isVertical() ? half - 1 : 0;
                int shiftY = this.isVertical() ? 0 : half - 1;
                g.translate(shiftX, shiftY);
                super.paintThumb(g, c, thumbBounds);
                g.translate(-shiftX, -shiftY);
            } else {
                super.paintThumb(g, c, thumbBounds);
            }
        }

        @Override
        protected void paintMaxiThumb(Graphics2D g, Rectangle thumbBounds) {
            int arc = JBUI.scale((int)3);
            g.setColor(this.adjustColor((Color)this.getGradientDarkColor()));
            int gap = JBUI.scale((int)2);
            if (this.isVertical()) {
                g.fillRoundRect(0, gap, thumbBounds.width, thumbBounds.height - 2 * gap, arc, arc);
            } else {
                g.fillRoundRect(gap, 0, thumbBounds.width - 2 * gap, thumbBounds.height, arc, arc);
            }
        }
    }

    public static class ThumbPainter
    implements RegionPainter<Integer> {
        private static final ThumbPainter DEFAULT = new ThumbPainter(null);
        private static final BasicStroke BASIC_STROKE = new BasicStroke();
        private JScrollBar myScrollBar;

        void setScrollBar(JScrollBar bar) {
            this.myScrollBar = bar;
        }

        public ThumbPainter(JScrollBar bar) {
            this.setScrollBar(bar);
        }

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Integer value) {
            float alpha = this.getAlpha();
            if (alpha > 0.0f) {
                int gap = this.getBorderOffset();
                if (this.isVertical()) {
                    x += this.isLeftToRight() ? gap : 0;
                    width -= gap;
                } else {
                    y += gap;
                    height -= gap;
                }
                if (width > 1 && height > 1) {
                    g = (Graphics2D)g.create(x, y, width, height);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    g.setStroke(BASIC_STROKE);
                    if (alpha < 1.0f) {
                        g.setComposite(AlphaComposite.getInstance(3, alpha));
                    }
                    this.paint(g, width, height, value);
                    g.dispose();
                }
            }
        }

        protected void paint(Graphics2D g, int width, int height, Integer value) {
            int x = 1;
            int y = 1;
            width -= x + x;
            height -= y + y;
            int arc = JBUI.scale((int)4);
            Color border = this.getBorderColor();
            Color start = this.getGradientStart(value);
            Color stop = this.getGradientStop(value);
            if (start != null || stop != null) {
                if (start == null) {
                    g.setColor(stop);
                } else if (stop == null) {
                    g.setColor(start);
                } else if (this.isVertical()) {
                    g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)start, (float)(x + width), (float)y, (Color)stop));
                } else {
                    g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)start, (float)x, (float)(y + height), (Color)stop));
                }
                g.fillRoundRect(x, y, width, height, arc, arc);
            }
            if (border != null) {
                g.setColor(border);
                g.setStroke(BASIC_STROKE);
                g.drawRoundRect(x, y, width - 1, height - 1, arc, arc);
            }
        }

        protected boolean isVertical() {
            return this.myScrollBar == null || 1 == this.myScrollBar.getOrientation();
        }

        protected boolean isLeftToRight() {
            return this.myScrollBar == null || this.myScrollBar.getComponentOrientation().isLeftToRight();
        }

        protected float getAlpha() {
            return 1.0f;
        }

        protected int getColorOffset(Integer value) {
            return value == null ? 0 : value;
        }

        protected Color getGradientStart(Integer value) {
            int offset = this.getColorOffset(value);
            return ThumbPainter.getColor(UIUtil.isUnderDarcula() ? 95 + offset : 251 - offset);
        }

        protected Color getGradientStop(Integer value) {
            int offset = this.getColorOffset(value);
            return ThumbPainter.getColor(UIUtil.isUnderDarcula() ? 80 + offset : 215 - offset);
        }

        protected Color getBorderColor() {
            int offset = this.getColorOffset(null);
            return ThumbPainter.getColor(UIUtil.isUnderDarcula() ? 85 + offset : 201 - offset);
        }

        protected int getBorderOffset() {
            return 1;
        }

        private static Color getColor(int gray) {
            return Gray.get((int)(gray < 0 ? 0 : (gray > 255 ? 255 : gray)));
        }
    }

    public static interface ScrollbarRepaintCallback {
        public void call(Graphics var1);
    }

    private static class EmptyButton
    extends JButton {
        private EmptyButton() {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Dimension getMaximumSize() {
            return JBUI.emptySize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }
}

