/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect

import kotlin.reflect.jvm.internal.impl.load.java.structure.*
import kotlin.reflect.jvm.internal.impl.name.FqName
import java.lang.reflect.ParameterizedType
import java.lang.reflect.Type
import java.lang.reflect.TypeVariable

class ReflectJavaClassifierType(public override val type: Type) : ReflectJavaType(), JavaClassifierType {
    private val classifier: JavaClassifier = run {
        val type = type
        val classifier: JavaClassifier = when (type) {
            is Class<*> -> ReflectJavaClass(type)
            is TypeVariable<*> -> ReflectJavaTypeParameter(type)
            is ParameterizedType -> ReflectJavaClass(type.rawType as Class<*>)
            else -> throw IllegalStateException("Not a classifier type (${type.javaClass}): $type")
        }
        classifier
    }

    override fun getClassifier(): JavaClassifier = classifier

    override fun getSubstitutor(): JavaTypeSubstitutor = throw UnsupportedOperationException()

    override fun getSupertypes(): Collection<JavaClassifierType> = throw UnsupportedOperationException()

    override fun getPresentableText(): String = type.toString()

    override fun isRaw(): Boolean = with(type) { this is Class<*> && getTypeParameters().isNotEmpty() }

    override fun getTypeArguments(): List<JavaType> {
        return sequence({type as? ParameterizedType}, { it.ownerType as? ParameterizedType }).flatMap {
            it.actualTypeArguments.asSequence().map { ReflectJavaType.create(it) }
        }.toList()
    }

    override fun getAnnotations(): Collection<JavaAnnotation> {
        return emptyList() // TODO
    }

    override fun findAnnotation(fqName: FqName): JavaAnnotation? {
        return null // TODO
    }

    override fun isDeprecatedInJavaDoc() = false
}
