/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0016\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0007J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010$\u001a\u00020\u00142\b\b\u0002\u0010%\u001a\u00020!H\u0002J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0003*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "(Ljava/io/File;)V", "countersFile", "deletedCount", "", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "size", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "add", "", "lookupSymbol", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "containingPaths", "", "addFileIfNeeded", "file", "clean", "dump", "lookupSymbols", "", "flush", "memoryCachesOnly", "", "forceGC", "get", "removeGarbageIfNeeded", "force", "removeLookupsFrom", "Companion", "kotlin-build"})
@KotlinClass(version={1, 1, 0}, data={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0016\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0007J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010$\u001a\u00020\u00142\b\b\u0002\u0010%\u001a\u00020!H\u0002J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0003*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, strings={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "(Ljava/io/File;)V", "countersFile", "deletedCount", "", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "size", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "add", "", "lookupSymbol", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "containingPaths", "", "addFileIfNeeded", "file", "clean", "dump", "lookupSymbols", "", "flush", "memoryCachesOnly", "", "forceGC", "get", "removeGarbageIfNeeded", "force", "removeLookupsFrom", "Companion", "kotlin-build"})
public class LookupStorage
extends BasicMapsOwner {
    private final File countersFile;
    private final IdToFileMap idToFile;
    private final FileToIdMap fileToId;
    private final LookupMap lookupMap;
    private int size;
    private int deletedCount;
    private final File targetDataDir;
    private static final double DELETED_TO_SIZE_TRESHOLD = 0.5;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    public static final Companion Companion = new Companion(null);

    private final File getStorageFile(String $receiver) {
        return new File(this.targetDataDir, $receiver + "." + BasicMapsOwner.Companion.getCACHE_EXTENSION());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Collection<Integer> collection = this.lookupMap.get(key);
        if (collection == null) {
            return SetsKt.emptySet();
        }
        Collection<Integer> fileIds = collection;
        Iterable iterable = fileIds;
        void var5_5 = $receiver$iv;
        Collection collection2 = new ArrayList();
        void var7_7 = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Boolean bl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            int it = ((Number)element$iv$iv).intValue();
            File file = this.idToFile.get(it);
            if ((file != null ? file.getPath() : null) != null) {
                void $receiver$iv$iv$iv2;
                String string;
                string = string;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull LookupSymbol lookupSymbol, @NotNull Collection<String> containingPaths) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)lookupSymbol, (String)"lookupSymbol");
        Intrinsics.checkParameterIsNotNull(containingPaths, (String)"containingPaths");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Iterable iterable = containingPaths;
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var14_10 = destination$iv$iv;
            Integer n = this.addFileIfNeeded(new File((String)it));
            var14_10.add(n);
        }
        HashSet fileIds = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Collection collection2 = this.lookupMap.get(key);
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        fileIds.addAll(collection2);
        this.lookupMap.set(key, fileIds);
    }

    public final void removeLookupsFrom(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Integer n = this.fileToId.get(file);
        if (n == null) {
            return;
        }
        int id = ((Number)n).intValue();
        this.idToFile.remove(id);
        this.fileToId.remove(file);
        int n2 = this.deletedCount++;
    }

    @Override
    public void clean() {
        if (this.countersFile.exists()) {
            this.countersFile.delete();
        }
        this.size = 0;
        this.deletedCount = 0;
        super.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean memoryCachesOnly) {
        try {
            LookupStorage.removeGarbageIfNeeded$default(this, false, 1, null);
            if (this.size > 0) {
                if (!this.countersFile.exists()) {
                    this.countersFile.getParentFile().mkdirs();
                    this.countersFile.createNewFile();
                }
                FilesKt.writeText$default((File)this.countersFile, (String)(this.size + "\n" + this.deletedCount), null, (int)2, null);
            }
        }
        finally {
            super.flush(memoryCachesOnly);
        }
    }

    private final int addFileIfNeeded(File file) {
        Integer existing = this.fileToId.get(file);
        if (existing != null) {
            return ((Number)existing).intValue();
        }
        int id = this.size++;
        this.fileToId.set(file, id);
        this.idToFile.set(id, file);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGarbageIfNeeded(boolean force) {
        Iterator<Object> iterator;
        Map.Entry<File, Integer> $receiver$iv;
        if (!force && this.size <= LookupStorage.Companion.getMINIMUM_GARBAGE_COLLECTIBLE_SIZE() && (double)this.deletedCount / (double)this.size <= LookupStorage.Companion.getDELETED_TO_SIZE_TRESHOLD()) {
            return;
        }
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(hash);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = collection;
            LookupSymbolKey lookupSymbolKey = hash;
            LookupMap lookupMap = this.lookupMap;
            iterator = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            lookupMap.set(lookupSymbolKey, CollectionsKt.toSet((Iterable)list));
        }
        Map<File, Integer> oldFileToId = this.fileToId.toMap();
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clean();
        this.fileToId.clean();
        this.size = 0;
        this.deletedCount = 0;
        iterator = oldFileToId.entrySet().iterator();
        while (iterator.hasNext()) {
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry<File, Integer> entry = $receiver$iv = iterator.next();
            File file = (File)$receiver$iv3.getKey();
            Map.Entry<File, Integer> $i$f$component1 = $receiver$iv;
            int oldId = ((Number)$receiver$iv2.getValue()).intValue();
            int newId = this.addFileIfNeeded(file);
            MapsKt.set((Map)oldIdToNewId, (Object)oldId, (Object)newId);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv4;
            Collection<Integer> collection = this.lookupMap.get(lookup);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable oldId = collection;
            void newId = $receiver$iv4;
            Collection $i$f$component2 = new ArrayList();
            void $i$a$1 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Boolean bl;
                Object element$iv$iv = element$iv$iv$iv;
                int it = ((Number)element$iv$iv).intValue();
                if ((Integer)oldIdToNewId.get(it) != null) {
                    void $receiver$iv$iv$iv2;
                    void it$iv$iv = $receiver$iv$iv$iv2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            Set fileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    static /* bridge */ /* synthetic */ void removeGarbageIfNeeded$default(LookupStorage lookupStorage, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        lookupStorage.removeGarbageIfNeeded(bl);
    }

    static /* bridge */ /* synthetic */ void removeGarbageIfNeeded$default(LookupStorage lookupStorage, boolean bl, int n) {
        LookupStorage.removeGarbageIfNeeded$default(lookupStorage, bl, n, null);
    }

    public final void forceGC() {
        this.removeGarbageIfNeeded(true);
        this.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols) {
        Object value$iv$iv$iv;
        void destination$iv$iv;
        Iterator key$iv$iv;
        LookupSymbol it;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(lookupSymbols, (String)"lookupSymbols");
        this.flush(false);
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer((Appendable)sb);
        Iterable iterable = lookupSymbols;
        Iterator iterator = $receiver$iv;
        Map map = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            void $receiver$iv$iv$iv;
            it = (LookupSymbol)element$iv$iv;
            key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Iterator iterator2 = destination$iv$iv;
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        void lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup : CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Collection<Integer> fileIds;
            String string;
            Object object;
            void var20_18;
            void destination$iv$iv3;
            Iterable $receiver$iv$iv3;
            if (this.lookupMap.get(lookup) == null) {
                Intrinsics.throwNpe();
            }
            if (MapsKt.contains((Map)lookupsStrings, (Object)lookup)) {
                void $receiver$iv3;
                Object element$iv$iv;
                Object v = lookupsStrings.get(lookup);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                element$iv$iv = (Iterable)v;
                it = $receiver$iv3;
                Collection $i$a$1 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    void it2;
                    value$iv$iv$iv = (LookupSymbol)item$iv$iv;
                    var20_18 = destination$iv$iv3;
                    object = it2.getScope() + "#" + it2.getName();
                    var20_18.add(object);
                }
                string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = lookup.toString();
            }
            String key = string;
            $receiver$iv$iv3 = fileIds;
            destination$iv$iv3 = $receiver$iv2;
            key$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it3;
                int $i$a$1 = ((Number)item$iv$iv).intValue();
                var20_18 = destination$iv$iv2;
                Object object2 = this.idToFile.get((int)it3);
                if (object2 == null || (object2 = ((File)object2).getAbsolutePath()) == null) {
                    object2 = String.valueOf((int)it3);
                }
                object = object2;
                var20_18.add(object);
            }
            String value = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            p.println(new Object[]{key + " -> " + value});
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public LookupStorage(@NotNull File targetDataDir) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataDir, (String)"targetDataDir");
        this.targetDataDir = targetDataDir;
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file")));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id")));
        this.lookupMap = (LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups")));
        if (this.countersFile.exists()) {
            List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
            this.size = StringsKt.toInt((String)((String)lines.get(0)));
            this.deletedCount = StringsKt.toInt((String)((String)lines.get(1)));
        }
    }

    static {
        DELETED_TO_SIZE_TRESHOLD = 0.5;
        MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "getDELETED_TO_SIZE_TRESHOLD", "()D", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "getMINIMUM_GARBAGE_COLLECTIBLE_SIZE", "()I", "kotlin-build"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "getDELETED_TO_SIZE_TRESHOLD", "()D", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "getMINIMUM_GARBAGE_COLLECTIBLE_SIZE", "()I", "kotlin-build"})
    public static final class Companion {
        private final double getDELETED_TO_SIZE_TRESHOLD() {
            return DELETED_TO_SIZE_TRESHOLD;
        }

        private final int getMINIMUM_GARBAGE_COLLECTIBLE_SIZE() {
            return MINIMUM_GARBAGE_COLLECTIBLE_SIZE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

