/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DeleteFile;
import org.jetbrains.jgit.dirCache.DirCacheEditor;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.DirCacheTerminator;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.jgit.dirCache.PathEditBase;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.UtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a&\u0010\u0010\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0012\u001a\u00020\n*\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u001a\u0012\u0010\u0012\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0002\u001a$\u0010\u0015\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"EDIT_CMP", "Ljava/util/Comparator;", "Lorg/jetbrains/jgit/dirCache/PathEdit;", "DeleteFile", "Lorg/jetbrains/jgit/dirCache/DeleteFile;", "path", "", "encodePath", "", "deleteAllFiles", "", "Lorg/eclipse/jgit/lib/Repository;", "deletedSet", "", "fromWorkingTree", "", "deletePath", "isFile", "edit", "edits", "", "writePath", "bytes", "size", "", "settings-repository"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a&\u0010\u0010\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0012\u001a\u00020\n*\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u001a\u0012\u0010\u0012\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0002\u001a$\u0010\u0015\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, strings={"EDIT_CMP", "Ljava/util/Comparator;", "Lorg/jetbrains/jgit/dirCache/PathEdit;", "DeleteFile", "Lorg/jetbrains/jgit/dirCache/DeleteFile;", "path", "", "encodePath", "", "deleteAllFiles", "", "Lorg/eclipse/jgit/lib/Repository;", "deletedSet", "", "fromWorkingTree", "", "deletePath", "isFile", "edit", "edits", "", "writePath", "bytes", "size", "", "settings-repository"})
public final class DirCacheEditorKt {
    private static final Comparator<PathEdit> EDIT_CMP = EDIT_CMP.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    private static final byte[] encodePath(String path) {
        int n;
        int n2;
        ByteBuffer byteBuffer = Constants.CHARSET.encode(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Constants.CHARSET.encode(path)");
        byte[] bytes = UtilKt.byteBufferToBytes(byteBuffer);
        if (SystemInfo.isWindows && (n2 = 0) <= (n = bytes.length - 1)) {
            while (true) {
                void i;
                if ((char)bytes[i] == '\\') {
                    bytes[i] = (byte)47;
                }
                if (i == n) break;
                ++i;
            }
        }
        return bytes;
    }

    @NotNull
    public static final DeleteFile DeleteFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new DeleteFile(DirCacheEditorKt.encodePath(path));
    }

    public static final void edit(Repository $receiver, @NotNull PathEdit edit2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)edit2, (String)"edit");
        DirCacheEditorKt.edit($receiver, CollectionsKt.listOf((Object)edit2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void edit(Repository $receiver, @NotNull List<? extends PathEdit> edits) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(edits, (String)"edits");
        if (edits.isEmpty()) {
            return;
        }
        DirCache dirCache = $receiver.lockDirCache();
        try {
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheEditor(edits, $receiver, dirCache2, dirCache.getEntryCount() + 4).commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteAllFiles(Repository $receiver, @Nullable Set<String> deletedSet, boolean fromWorkingTree) {
        File[] files2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DirCache dirCache = $receiver.lockDirCache();
        try {
            int n;
            int n2;
            if (deletedSet != null && (n2 = 0) <= (n = dirCache.getEntryCount() - 1)) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    if (Intrinsics.areEqual((Object)(entry = dirCache.getEntry((int)i)).getFileMode(), (Object)FileMode.REGULAR_FILE)) {
                        String string = entry.getPathString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.pathString");
                        deletedSet.add(string);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheTerminator(dirCache2).commit();
        }
        finally {
            dirCache.unlock();
        }
        if (fromWorkingTree && (files2 = $receiver.getWorkTree().listFiles(deleteAllFiles.files.1.INSTANCE)) != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                FileUtil.delete((File)file);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void deleteAllFiles$default(Repository repository2, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        DirCacheEditorKt.deleteAllFiles(repository2, set, bl);
    }

    public static /* bridge */ /* synthetic */ void deleteAllFiles$default(Repository repository2, Set set, boolean bl, int n) {
        DirCacheEditorKt.deleteAllFiles$default(repository2, set, bl, n, null);
    }

    public static final void writePath(Repository $receiver, @NotNull String path, @NotNull byte[] bytes, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        DirCacheEditorKt.edit($receiver, new AddLoadedFile(path, bytes, size, 0L, 8, null));
        FileUtil.writeToFile((File)new File($receiver.getWorkTree(), path), (byte[])bytes, (int)0, (int)size);
    }

    public static /* bridge */ /* synthetic */ void writePath$default(Repository repository2, String string, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        DirCacheEditorKt.writePath(repository2, string, byArray, n);
    }

    public static /* bridge */ /* synthetic */ void writePath$default(Repository repository2, String string, byte[] byArray, int n, int n2) {
        DirCacheEditorKt.writePath$default(repository2, string, byArray, n, n2, null);
    }

    public static final void deletePath(Repository $receiver, @NotNull String path, boolean isFile, boolean fromWorkingTree) {
        File workTree;
        File ioFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.edit($receiver, isFile ? (PathEditBase)DirCacheEditorKt.DeleteFile(path) : (PathEditBase)new DeleteDirectory(path));
        if (fromWorkingTree && (ioFile = new File(workTree = $receiver.getWorkTree(), path)).exists()) {
            File file = workTree;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"workTree");
            BaseRepositoryManagerKt.removeWithParentsIfEmpty(ioFile, file, isFile);
        }
    }

    public static /* bridge */ /* synthetic */ void deletePath$default(Repository repository2, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        DirCacheEditorKt.deletePath(repository2, string, bl, bl2);
    }

    public static /* bridge */ /* synthetic */ void deletePath$default(Repository repository2, String string, boolean bl, boolean bl2, int n) {
        DirCacheEditorKt.deletePath$default(repository2, string, bl, bl2, n, null);
    }

    @NotNull
    public static final /* synthetic */ Comparator access$getEDIT_CMP$p() {
        return EDIT_CMP;
    }

    @NotNull
    public static final /* synthetic */ byte[] access$encodePath(@NotNull String path) {
        return DirCacheEditorKt.encodePath(path);
    }
}

