/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a,\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "components", "", "Lcom/intellij/ide/actions/ExportableItem;", "saveDirectory", "parent", "Ljava/nio/file/Path;", "parentFileSpec", "", "roamingType", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "settings-repository"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a,\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0002\u00a8\u0006\u0012"}, strings={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "components", "", "Lcom/intellij/ide/actions/ExportableItem;", "saveDirectory", "parent", "Ljava/nio/file/Path;", "parentFileSpec", "", "roamingType", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "settings-repository"})
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = storageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        Map fileToComponents = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)true, (boolean)false, (StateStorageManager)((StateStorageManager)storageManager), null, (int)8, null);
        for (Path file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath = ProjectStoreImplKt.getSystemIndependentPath((Path)file.toAbsolutePath());
            String fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(absolutePath), (String)SchemeManagerFactoryImplKt.ROOT_CONFIG);
            if (Intrinsics.areEqual((Object)fileSpec, (Object)absolutePath) && Intrinsics.areEqual((Object)(canonicalPath = ProjectStoreImplKt.getSystemIndependentPath((Path)file.toRealPath(new LinkOption[0]))), (Object)absolutePath) ^ true) {
                fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(canonicalPath), (String)SchemeManagerFactoryImplKt.ROOT_CONFIG);
            }
            Object v = fileToComponents.get(file);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType((Collection)v);
            if (ProjectStoreImplKt.isFile((Path)file)) {
                byte[] fileBytes = Files.readAllBytes(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, roamingType, streamProvider2);
        }
    }

    public static /* bridge */ /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n, Object object) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
            if (stateStorageManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    public static /* bridge */ /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n) {
        CopyAppSettingsToRepositoryKt.copyLocalConfig$default(stateStorageManagerImpl, n, null);
    }

    private static final void saveDirectory(Path parent, String parentFileSpec, RoamingType roamingType, IcsManager.IcsStreamProvider streamProvider) {
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            return;
        }
        for (Path file : Files.newDirectoryStream(parent)) {
            String childFileSpec = parentFileSpec + "/" + file.getFileName();
            if (ProjectStoreImplKt.isFile((Path)file)) {
                byte[] fileBytes = Files.readAllBytes(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            Path path = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
            CopyAppSettingsToRepositoryKt.saveDirectory(path, childFileSpec, roamingType, streamProvider);
        }
    }

    private static final RoamingType getRoamingType(Collection<ExportableItem> components) {
        for (ExportableItem component : components) {
            if (!(component instanceof ExportableItem)) continue;
            return component.getRoamingType();
        }
        return RoamingType.DEFAULT;
    }
}

