/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.MyPrettyPrinter;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DEFAULT_COMMIT_DELAY", "", "loadSettings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "Ljava/io/File;", "saveSettings", "", "settings", "settings-repository"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, strings={"DEFAULT_COMMIT_DELAY", "", "loadSettings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "Ljava/io/File;", "saveSettings", "", "settings", "settings-repository"})
public final class IcsSettingsKt {
    private static final int DEFAULT_COMMIT_DELAY = 600000;

    public static final void saveSettings(@NotNull IcsSettings settings, @NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        byte[] serialized = new ObjectMapper().writer((PrettyPrinter)new MyPrettyPrinter()).writeValueAsBytes((Object)settings);
        if (serialized.length <= 2) {
            FileUtil.delete((File)settingsFile);
        } else {
            FileUtil.writeToFile((File)settingsFile, (byte[])serialized);
        }
    }

    @NotNull
    public static final IcsSettings loadSettings(@NotNull File settingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)settingsFile, (String)"settingsFile");
        if (!settingsFile.exists()) {
            return new IcsSettings();
        }
        IcsSettings settings = (IcsSettings)new ObjectMapper().readValue(settingsFile, IcsSettings.class);
        if (settings.getCommitDelay() <= 0) {
            settings.setCommitDelay(DEFAULT_COMMIT_DELAY);
        }
        IcsSettings icsSettings = settings;
        Intrinsics.checkExpressionValueIsNotNull((Object)icsSettings, (String)"settings");
        return icsSettings;
    }

    static {
        DEFAULT_COMMIT_DELAY = 10 * 60000;
    }

    public static final /* synthetic */ int access$getDEFAULT_COMMIT_DELAY$p() {
        return DEFAULT_COMMIT_DELAY;
    }
}

