/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.text.StringsKt;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "url", "", "messageParent", "Ljava/awt/Container;", "checkUrl", "uriString", "isValidRepository", "file", "Ljava/io/File;", "settings-repository"})
@KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, strings={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "url", "", "messageParent", "Ljava/awt/Container;", "checkUrl", "uriString", "isValidRepository", "file", "Ljava/io/File;", "settings-repository"})
public interface RepositoryService {
    public boolean checkUrl(@NotNull String var1, @Nullable Container var2);

    public boolean checkFileRepo(@NotNull String var1, @NotNull Container var2);

    public boolean isValidRepository(@NotNull File var1);

    @KotlinSyntheticClass(version={1, 1, 0})
    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=3)
    public static final class DefaultImpls {
        public static boolean checkUrl(@NotNull RepositoryService $this, @Nullable String uriString, Container messageParent) {
            boolean isFile;
            Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
            URIish uri = new URIish(uriString);
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                isFile = true;
            } else {
                boolean bl = isFile = uri.getScheme() == null && uri.getHost() == null;
            }
            return messageParent == null || !isFile || $this.checkFileRepo(uriString, messageParent);
        }

        public static /* bridge */ /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, Container container, int n, Object object) {
            if ((n & 2) != 0) {
                container = null;
            }
            return repositoryService.checkUrl(string, container);
        }

        public static /* bridge */ /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, Container container, int n) {
            return DefaultImpls.checkUrl$default(repositoryService, string, container, n, null);
        }

        public static boolean checkFileRepo(@NotNull RepositoryService $this, @NotNull String url, Container messageParent) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)messageParent, (String)"messageParent");
            String suffix = "/" + ".git";
            File file = new File(StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2, null) ? StringsKt.substring((String)url, (int)0, (int)(url.length() - suffix.length())) : url);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    Messages.showErrorDialog((Component)messageParent, (String)"Specified path is not a directory", (String)"Specified Path is Invalid");
                    return false;
                }
                if ($this.isValidRepository(file)) {
                    return true;
                }
            } else if (!file.isAbsolute()) {
                Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]), (String)"");
                return false;
            }
            if (Messages.showYesNoDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.dialog.message", new Object[0]), (String)IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                try {
                    GitExKt.createBareRepository(file);
                    return true;
                }
                catch (IOException e) {
                    Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.failed.message", e.getMessage()), (String)IcsBundleKt.icsMessage("init.failed.title", new Object[0]));
                    return false;
                }
            }
            return false;
        }
    }
}

