/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.settingsRepository.IcsManagerKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"canUseGitExe", "", "getCredentialsUsingGit", "Lorg/jetbrains/keychain/Credentials;", "uri", "Lorg/eclipse/jgit/transport/URIish;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "settings-repository"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, strings={"canUseGitExe", "", "getCredentialsUsingGit", "Lorg/jetbrains/keychain/Credentials;", "uri", "Lorg/eclipse/jgit/transport/URIish;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "settings-repository"})
public final class GitCredentialKt {
    private static boolean canUseGitExe = true;

    @Nullable
    public static final Credentials getCredentialsUsingGit(@NotNull URIish uri, @NotNull Repository repository2) {
        Process process;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        if (!canUseGitExe || repository2.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"git", "credential", "fill"});
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"commandLine.createProcess()");
            process = process2;
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStreamWriter writer = ByteStreamsKt.writer$default((OutputStream)process.getOutputStream(), null, (int)1, null);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        BufferedReader reader = TextStreamsKt.buffered$default((Reader)ByteStreamsKt.reader$default((InputStream)process.getInputStream(), null, (int)1, null), (int)0, (int)1, null);
        Object username = null;
        Object password = null;
        while (true) {
            String line;
            String string = reader.readLine();
            String string2 = line = string != null ? StringsKt.trim((String)string) : null;
            if (line == null || StringsKt.isEmpty((CharSequence)line)) break;
            Function0<String> readValue$ = new Function0<String>(line){
                final /* synthetic */ String $line;

                @NotNull
                public final String invoke() {
                    return StringsKt.trim((String)StringsKt.substring((String)this.$line, (int)(StringsKt.indexOf$default((CharSequence)this.$line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1)));
                }
                {
                    this.$line = string;
                    super(0);
                }
            };
            if (StringsKt.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2, null)) {
                username = readValue$.invoke();
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2, null)) continue;
            password = readValue$.invoke();
        }
        reader.close();
        String errorText = TextStreamsKt.readText((Reader)ByteStreamsKt.reader$default((InputStream)process.getErrorStream(), null, (int)1, null));
        if (!StringUtil.isEmpty((String)errorText)) {
            IcsManagerKt.getLOG().warn(errorText);
        }
        return username == null && password == null ? (Credentials)null : new Credentials((String)username, (String)password);
    }
}

