/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.browser.SHAHash;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangeUtils {
    public static final String COMMITTED_CHANGELIST_FORMAT = "%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03";
    private static final Logger LOG = Logger.getInstance(GitChangeUtils.class);

    private GitChangeUtils() {
    }

    public static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, String s, Collection<Change> changes, Set<String> ignoreNames) throws VcsException {
        StringScanner sc = new StringScanner(s);
        GitChangeUtils.parseChanges(project, vcsRoot, thisRevision, parentRevision, sc, changes, ignoreNames);
        if (sc.hasMoreData()) {
            throw new IllegalStateException("Unknown file status: " + sc.line());
        }
    }

    public static Collection<String> parseDiffForPaths(String rootPath, StringScanner s) throws VcsException {
        ArrayList<String> result = new ArrayList<String>();
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMR".indexOf(s.peek()) == -1) break;
            assert ('M' != s.peek()) : "Moves are not yet handled";
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            path = rootPath + File.separator + GitUtil.unescapePath(path);
            path = FileUtil.toSystemDependentName((String)path);
            result.add(path);
        }
        return result;
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, @Nullable GitRevisionNumber parentRevision, StringScanner s, Collection<Change> changes, Set<String> ignoreNames) throws VcsException {
        while (s.hasMoreData()) {
            ContentRevision after;
            ContentRevision before;
            FileStatus status = null;
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMRT".indexOf(s.peek()) == -1) {
                return;
            }
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            switch (tokens[0].charAt(0)) {
                case 'A': 
                case 'C': {
                    before = null;
                    status = FileStatus.ADDED;
                    after = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)thisRevision, project, false, false, true);
                    break;
                }
                case 'U': {
                    status = FileStatus.MERGED_WITH_CONFLICTS;
                }
                case 'M': {
                    if (status == null) {
                        status = FileStatus.MODIFIED;
                    }
                    before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)parentRevision, project, false, true, true);
                    after = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)thisRevision, project, false, false, true);
                    break;
                }
                case 'D': {
                    status = FileStatus.DELETED;
                    before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)parentRevision, project, true, true, true);
                    after = null;
                    break;
                }
                case 'R': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createRevision(vcsRoot, tokens[1], (VcsRevisionNumber)parentRevision, project, true, true, true);
                    after = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)thisRevision, project, false, false, true);
                    break;
                }
                case 'T': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)parentRevision, project, true, true, true);
                    after = GitContentRevision.createRevisionForTypeChange(project, vcsRoot, path, (VcsRevisionNumber)thisRevision, true);
                    break;
                }
                default: {
                    throw new VcsException("Unknown file status: " + Arrays.asList(tokens));
                }
            }
            if (ignoreNames != null && ignoreNames.contains(path)) continue;
            changes.add(new Change(before, after, status));
        }
    }

    @NotNull
    public static GitRevisionNumber resolveReference(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String reference) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "resolveReference"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/changes/GitChangeUtils", "resolveReference"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/changes/GitChangeUtils", "resolveReference"));
        }
        GitSimpleHandler handler = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
        String output = handler.run();
        StringTokenizer stk = new StringTokenizer(output, "\n\r \t", false);
        if (!stk.hasMoreTokens()) {
            try {
                GitSimpleHandler dh = new GitSimpleHandler(project, vcsRoot, GitCommand.LOG);
                dh.addParameters("-1", "HEAD");
                dh.setSilent(true);
                String out = dh.run();
                LOG.info("Diagnostic output from 'git log -1 HEAD': [" + out + "]");
                dh = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
                out = dh.run();
                LOG.info("Diagnostic output from 'git rev-list -1 --timestamp HEAD': [" + out + "]");
            }
            catch (VcsException e) {
                LOG.info("Exception while trying to get some diagnostics info", (Throwable)e);
            }
            throw new VcsException(String.format("The string '%s' does not represent a revision number. Output: [%s]\n Root: %s", reference, output, vcsRoot));
        }
        Date timestamp = GitUtil.parseTimestampWithNFEReport(stk.nextToken(), handler, output);
        GitRevisionNumber gitRevisionNumber = new GitRevisionNumber(stk.nextToken(), timestamp);
        if (gitRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "resolveReference"));
        }
        return gitRevisionNumber;
    }

    @NotNull
    private static GitSimpleHandler createRefResolveHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull String reference) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "createRefResolveHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitChangeUtils", "createRefResolveHandler"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/changes/GitChangeUtils", "createRefResolveHandler"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.REV_LIST);
        handler.addParameters("--timestamp", "--max-count=1", reference);
        handler.endOptions();
        handler.setSilent(true);
        GitSimpleHandler gitSimpleHandler = handler;
        if (gitSimpleHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "createRefResolveHandler"));
        }
        return gitSimpleHandler;
    }

    public static boolean isHeadMissing(VcsException e) {
        String errorText = "fatal: bad revision 'HEAD'\n";
        return e.getMessage().equals("fatal: bad revision 'HEAD'\n");
    }

    public static GitCommittedChangeList getRevisionChanges(Project project, VirtualFile root, String revisionName, boolean skipDiffsForMerge, boolean local, boolean revertable) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters("--name-status", "--first-parent", "--no-abbrev", "-M", "--pretty=format:%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--encoding=UTF-8", revisionName, "--");
        String output = h.run();
        StringScanner s = new StringScanner(output);
        return GitChangeUtils.parseChangeList(project, root, s, skipDiffsForMerge, h, local, revertable);
    }

    @Nullable
    public static SHAHash commitExists(Project project, VirtualFile root, String anyReference, List<VirtualFile> paths, String ... parameters) {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters(parameters);
        h.addParameters("--max-count=1", "--pretty=%H", "--encoding=UTF-8", anyReference, "--");
        if (paths != null && !paths.isEmpty()) {
            h.addRelativeFiles(paths);
        }
        try {
            String output = h.run().trim();
            if (StringUtil.isEmptyOrSpaces((String)output)) {
                return null;
            }
            return new SHAHash(output);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public static GitCommittedChangeList parseChangeList(Project project, VirtualFile root, StringScanner s, boolean skipDiffsForMerge, GitHandler handler, boolean local, boolean revertable) throws VcsException {
        ArrayList<Change> changes = new ArrayList<Change>();
        Date commitDate = GitUtil.parseTimestampWithNFEReport(s.line(), handler, s.getAllText());
        String revisionNumber = s.line();
        String parentsLine = s.line();
        String[] parents = parentsLine.length() == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : parentsLine.split(" ");
        String authorName = s.line();
        String committerName = s.line();
        committerName = GitUtil.adjustAuthorName(authorName, committerName);
        String commentSubject = s.boundedToken('\u0003', true);
        s.nextLine();
        String commentBody = s.boundedToken('\u0003', true);
        String fullComment = commentSubject.length() == 0 ? commentBody : (commentBody.length() == 0 ? commentSubject : commentSubject + "\n" + commentBody);
        GitRevisionNumber thisRevision = new GitRevisionNumber(revisionNumber, commitDate);
        if (skipDiffsForMerge || parents.length <= 1) {
            String[] parentRevision = parents.length > 0 ? GitChangeUtils.resolveReference(project, root, parents[0]) : null;
            GitChangeUtils.parseChanges(project, root, thisRevision, (GitRevisionNumber)(local ? null : parentRevision), s, changes, null);
        } else {
            for (String parent : parents) {
                GitRevisionNumber parentRevision = GitChangeUtils.resolveReference(project, root, parent);
                GitSimpleHandler diffHandler = new GitSimpleHandler(project, root, GitCommand.DIFF);
                diffHandler.setSilent(true);
                diffHandler.addParameters("--name-status", "-M", parentRevision.getRev(), thisRevision.getRev());
                String diff = diffHandler.run();
                GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, diff, changes, null);
                if (changes.size() > 0) break;
            }
        }
        String changeListName = String.format("%s(%s)", commentSubject, revisionNumber);
        return new GitCommittedChangeList(changeListName, fullComment, committerName, thisRevision, commitDate, changes, (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project)))), revertable);
    }

    public static long longForSHAHash(String revisionNumber) {
        return Long.parseLong(revisionNumber.substring(0, 15), 16) << 4 + Integer.parseInt(revisionNumber.substring(15, 16), 16);
    }

    @NotNull
    public static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable String oldRevision, @Nullable String newRevision, @Nullable Collection<FilePath> dirtyPaths) throws VcsException {
        GitRevisionNumber newRev;
        GitRevisionNumber oldRev;
        String range;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "getDiff"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitChangeUtils", "getDiff"));
        }
        LOG.assertTrue(oldRevision != null || newRevision != null, (Object)"Both old and new revisions can't be null");
        if (newRevision == null) {
            range = oldRevision + "..";
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = null;
        } else if (oldRevision == null) {
            range = ".." + newRevision;
            oldRev = null;
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        } else {
            range = oldRevision + ".." + newRevision;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        }
        String output = GitChangeUtils.getDiffOutput(project, root, range, dirtyPaths);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitChangeUtils.parseChanges(project, root, newRev, oldRev, output, changes, Collections.<String>emptySet());
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "getDiff"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull String oldRevision, @Nullable Collection<FilePath> dirtyPaths, boolean reverse) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "getDiffWithWorkingDir"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitChangeUtils", "getDiffWithWorkingDir"));
        }
        if (oldRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRevision", "git4idea/changes/GitChangeUtils", "getDiffWithWorkingDir"));
        }
        String output = GitChangeUtils.getDiffOutput(project, root, oldRevision, dirtyPaths, reverse);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitRevisionNumber revisionNumber = GitChangeUtils.resolveReference(project, root, oldRevision);
        GitChangeUtils.parseChanges(project, root, reverse ? revisionNumber : null, reverse ? null : revisionNumber, output, changes, Collections.<String>emptySet());
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "getDiffWithWorkingDir"));
        }
        return arrayList;
    }

    @NotNull
    private static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<FilePath> dirtyPaths, boolean reverse) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        if (diffRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRange", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        GitSimpleHandler handler = GitChangeUtils.getDiffHandler(project, root, diffRange, dirtyPaths, reverse);
        if (handler.isLargeCommandLine()) {
            handler = GitChangeUtils.getDiffHandler(project, root, diffRange, null, reverse);
        }
        String string = handler.run();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        return string;
    }

    @NotNull
    public static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        if (diffRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRange", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        String string = GitChangeUtils.getDiffOutput(project, root, diffRange, dirtyPaths, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "getDiffOutput"));
        }
        return string;
    }

    @NotNull
    private static GitSimpleHandler getDiffHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<FilePath> dirtyPaths, boolean reverse) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/changes/GitChangeUtils", "getDiffHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/changes/GitChangeUtils", "getDiffHandler"));
        }
        if (diffRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRange", "git4idea/changes/GitChangeUtils", "getDiffHandler"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.DIFF);
        if (reverse) {
            handler.addParameters("-R");
        }
        handler.addParameters("--name-status", "--diff-filter=ADCMRUXT", "-M", diffRange);
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        handler.endOptions();
        if (dirtyPaths != null) {
            handler.addRelativePaths(dirtyPaths);
        }
        GitSimpleHandler gitSimpleHandler = handler;
        if (gitSimpleHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/changes/GitChangeUtils", "getDiffHandler"));
        }
        return gitSimpleHandler;
    }
}

