/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import git4idea.rebase.GitRebaseUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class GitRebaseStatus {
    @NotNull
    private final Type myType;
    @NotNull
    private final Collection<GitRebaseUtils.CommitInfo> mySkippedCommits;

    @NotNull
    static GitRebaseStatus notStarted() {
        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(Type.NOT_STARTED, Collections.<GitRebaseUtils.CommitInfo>emptyList());
        if (gitRebaseStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseStatus", "notStarted"));
        }
        return gitRebaseStatus;
    }

    GitRebaseStatus(@NotNull Type type, @NotNull Collection<GitRebaseUtils.CommitInfo> skippedCommits) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/rebase/GitRebaseStatus", "<init>"));
        }
        if (skippedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitRebaseStatus", "<init>"));
        }
        this.myType = type;
        this.mySkippedCommits = skippedCommits;
    }

    @NotNull
    Collection<GitRebaseUtils.CommitInfo> getSkippedCommits() {
        Collection<GitRebaseUtils.CommitInfo> collection = this.mySkippedCommits;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseStatus", "getSkippedCommits"));
        }
        return collection;
    }

    @NotNull
    Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseStatus", "getType"));
        }
        return type;
    }

    public String toString() {
        return this.myType.toString();
    }

    static enum Type {
        SUCCESS,
        SUSPENDED,
        ERROR,
        NOT_STARTED;

    }
}

