/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryFiles {
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    public static final String CONFIG = "config";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "index";
    public static final String INFO = "info";
    public static final String INFO_EXCLUDE = "info/exclude";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    public static final String MERGE_MSG = "MERGE_MSG";
    public static final String ORIG_HEAD = "ORIG_HEAD";
    public static final String REBASE_APPLY = "rebase-apply";
    public static final String REBASE_MERGE = "rebase-merge";
    public static final String PACKED_REFS = "packed-refs";
    public static final String REFS = "refs";
    public static final String HEADS = "heads";
    public static final String TAGS = "tags";
    public static final String REMOTES = "remotes";
    public static final String SQUASH_MSG = "SQUASH_MSG";
    public static final String GIT_HEAD = ".git" + GitRepositoryFiles.slash("HEAD");
    public static final String GIT_MERGE_HEAD = ".git" + GitRepositoryFiles.slash("MERGE_HEAD");
    public static final String GIT_MERGE_MSG = ".git" + GitRepositoryFiles.slash("MERGE_MSG");
    public static final String GIT_SQUASH_MSG = ".git" + GitRepositoryFiles.slash("SQUASH_MSG");
    private final String myGitDirPath;
    private final String myConfigFilePath;
    private final String myHeadFilePath;
    private final String myIndexFilePath;
    private final String myMergeHeadPath;
    private final String myOrigHeadPath;
    private final String myRebaseApplyPath;
    private final String myRebaseMergePath;
    private final String myPackedRefsPath;
    private final String myRefsHeadsDirPath;
    private final String myRefsRemotesDirPath;
    private final String myRefsTagsPath;
    private final String myCommitMessagePath;
    private final String myInfoDirPath;
    private final String myExcludePath;

    private GitRepositoryFiles(@NotNull VirtualFile gitDir, @NotNull File configFile, @NotNull File headFile, @NotNull File refsDir, @NotNull File packedRefsFile) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        if (headFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headFile", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        if (refsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsDir", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        if (packedRefsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packedRefsFile", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        this.myGitDirPath = GitFileUtils.stripFileProtocolPrefix(gitDir.getPath());
        this.myConfigFilePath = FileUtil.toSystemIndependentName((String)configFile.getPath());
        this.myHeadFilePath = FileUtil.toSystemIndependentName((String)headFile.getPath());
        this.myIndexFilePath = this.myGitDirPath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = this.myGitDirPath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myOrigHeadPath = this.myGitDirPath + GitRepositoryFiles.slash(ORIG_HEAD);
        this.myCommitMessagePath = this.myGitDirPath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myRebaseApplyPath = this.myGitDirPath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = this.myGitDirPath + GitRepositoryFiles.slash(REBASE_MERGE);
        this.myPackedRefsPath = FileUtil.toSystemIndependentName((String)packedRefsFile.getPath());
        String refsPath = FileUtil.toSystemIndependentName((String)refsDir.getPath());
        this.myRefsHeadsDirPath = refsPath + GitRepositoryFiles.slash(HEADS);
        this.myRefsTagsPath = refsPath + GitRepositoryFiles.slash(TAGS);
        this.myRefsRemotesDirPath = refsPath + GitRepositoryFiles.slash(REMOTES);
        this.myInfoDirPath = this.myGitDirPath + GitRepositoryFiles.slash(INFO);
        this.myExcludePath = this.myGitDirPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
    }

    @NotNull
    public static GitRepositoryFiles getInstance(@NotNull VirtualFile gitDir) {
        File configFile;
        File packedRefsFile;
        File refsDir;
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryFiles", "getInstance"));
        }
        VirtualFile gitDirForWorktree = GitRepositoryFiles.getMainGitDirForWorktree(gitDir);
        File headFile = new File(gitDir.getPath(), HEAD);
        if (gitDirForWorktree == null) {
            refsDir = new File(gitDir.getPath(), REFS);
            packedRefsFile = new File(gitDir.getPath(), PACKED_REFS);
            configFile = new File(gitDir.getPath(), CONFIG);
        } else {
            refsDir = new File(gitDirForWorktree.getPath(), REFS);
            packedRefsFile = new File(gitDirForWorktree.getPath(), PACKED_REFS);
            configFile = new File(gitDirForWorktree.getPath(), CONFIG);
        }
        GitRepositoryFiles gitRepositoryFiles = new GitRepositoryFiles(gitDir, configFile, headFile, refsDir, packedRefsFile);
        if (gitRepositoryFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getInstance"));
        }
        return gitRepositoryFiles;
    }

    @Nullable
    private static VirtualFile getMainGitDirForWorktree(@NotNull VirtualFile gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryFiles", "getMainGitDirForWorktree"));
        }
        VirtualFile parent = gitDir.getParent();
        if (parent == null) {
            return null;
        }
        VirtualFile grandParent = parent.getParent();
        if (grandParent == null) {
            return null;
        }
        if (!gitDir.getName().equals(".git") && parent.getName().equals("worktrees") && grandParent.getName().equals(".git")) {
            SyntheticFileSystemItem.LOG.info("git dir " + gitDir.getPath() + " is a worktree");
            return grandParent;
        }
        return null;
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "git4idea/repo/GitRepositoryFiles", "slash"));
        }
        String string = "/" + s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "slash"));
        }
        return string;
    }

    @NotNull
    Collection<String> getDirsToWatch() {
        List<String> list = Arrays.asList(this.myRefsHeadsDirPath, this.myRefsRemotesDirPath, this.myRefsTagsPath, this.myInfoDirPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getDirsToWatch"));
        }
        return list;
    }

    @NotNull
    String getGitDirPath() {
        String string = this.myGitDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getGitDirPath"));
        }
        return string;
    }

    @NotNull
    String getRefsHeadsPath() {
        String string = this.myRefsHeadsDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsHeadsPath"));
        }
        return string;
    }

    @NotNull
    String getRefsRemotesPath() {
        String string = this.myRefsRemotesDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsRemotesPath"));
        }
        return string;
    }

    @NotNull
    String getRefsTagsPath() {
        String string = this.myRefsTagsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsTagsPath"));
        }
        return string;
    }

    @NotNull
    public String getPackedRefsPath() {
        String string = this.myPackedRefsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getPackedRefsPath"));
        }
        return string;
    }

    @NotNull
    public String getHeadPath() {
        String string = this.myHeadFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getHeadPath"));
        }
        return string;
    }

    @NotNull
    public String getConfigPath() {
        String string = this.myConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getConfigPath"));
        }
        return string;
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isOrigHeadFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitRepositoryFiles", "isOrigHeadFile"));
        }
        return file.equals(this.myOrigHeadPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isBranchFile(@NotNull String filePath, @NotNull String fullBranchName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/repo/GitRepositoryFiles", "isBranchFile"));
        }
        if (fullBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullBranchName", "git4idea/repo/GitRepositoryFiles", "isBranchFile"));
        }
        return FileUtil.pathsEqual((String)filePath, (String)(this.myGitDirPath + GitRepositoryFiles.slash(fullBranchName)));
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitRepositoryFiles", "isTagFile"));
        }
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitRepositoryFiles", "isCommitMessageFile"));
        }
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/repo/GitRepositoryFiles", "isExclude"));
        }
        return path.equals(this.myExcludePath);
    }
}

