/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.jetbrains.annotations.NotNull;

class ExpressionReplacementFix
implements IntentionAction {
    private final String myReplacement;
    private final String myDisplay;
    private final XPathExpression myExpr;

    public ExpressionReplacementFix(String replacement, XPathExpression expr) {
        this(replacement, replacement, expr);
    }

    public ExpressionReplacementFix(String replacement, String display, XPathExpression expression) {
        this.myReplacement = replacement;
        this.myDisplay = display;
        this.myExpr = expression;
    }

    @NotNull
    public String getText() {
        String string = "Replace with '" + this.myDisplay + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/ExpressionReplacementFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("XPath2" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/ExpressionReplacementFix", "getFamilyName"));
        }
        return "XPath2";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/validation/ExpressionReplacementFix", "isAvailable"));
        }
        return this.myExpr.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/validation/ExpressionReplacementFix", "invoke"));
        }
        this.myExpr.replace(XPathChangeUtil.createExpression(this.myExpr, this.myReplacement));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

