/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.util.HighlighterUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XPathView.XPathViewPlugin", storages={@Storage(file="xpath.xml"), @Storage(file="other.xml", deprecated=true)})
public class XPathAppComponent
implements ApplicationComponent,
PersistentStateComponent<Config>,
DefaultLiveTemplatesProvider {
    private static final String ACTION_FIND_NEXT = "FindNext";
    private static final String ACTION_FIND_PREVIOUS = "FindPrevious";
    private AnAction nextAction;
    private AnAction prevAction;
    private Config configuration = new Config();

    @NotNull
    public String getComponentName() {
        if ("XPathView.XPathViewPlugin" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/XPathAppComponent", "getComponentName"));
        }
        return "XPathView.XPathViewPlugin";
    }

    public void initComponent() {
        ActionManager actionManager = ActionManager.getInstance();
        this.nextAction = actionManager.getAction(ACTION_FIND_NEXT);
        this.prevAction = actionManager.getAction(ACTION_FIND_PREVIOUS);
        if (this.nextAction != null && this.prevAction != null) {
            actionManager.unregisterAction(ACTION_FIND_NEXT);
            actionManager.unregisterAction(ACTION_FIND_PREVIOUS);
            actionManager.registerAction(ACTION_FIND_NEXT, (AnAction)new MyFindAction(this.nextAction, false));
            actionManager.registerAction(ACTION_FIND_PREVIOUS, (AnAction)new MyFindAction(this.prevAction, true));
        }
    }

    public void disposeComponent() {
    }

    @Nullable
    public Config getState() {
        return this.configuration;
    }

    public void loadState(Config state) {
        this.configuration = state;
    }

    @NotNull
    public Config getConfig() {
        Config config = this.configuration;
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/XPathAppComponent", "getConfig"));
        }
        return config;
    }

    public void setConfig(@NotNull Config configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/intellij/plugins/xpathView/XPathAppComponent", "setConfig"));
        }
        this.configuration = configuration;
    }

    public static XPathAppComponent getInstance() {
        return (XPathAppComponent)ApplicationManager.getApplication().getComponent(XPathAppComponent.class);
    }

    public static void showEditorHint(String info, Editor editor) {
        JLabel label = new JLabel(info);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.WHITE, (Color)Gray._128), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        label.setForeground(JBColor.foreground());
        label.setBackground(HintUtil.INFORMATION_COLOR);
        label.setOpaque(true);
        label.setFont(label.getFont().deriveFont(1));
        LightweightHint h = new LightweightHint((JComponent)label);
        Point point = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        SwingUtilities.convertPointToScreen(point, editor.getContentComponent());
        int flags = 34;
        HintManagerImpl.getInstanceImpl().showEditorHint(h, editor, point, 34, 0, false);
    }

    public static String getShortcutText(AnAction action) {
        Shortcut[] shortcuts;
        ShortcutSet shortcutSet = action.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            String text = KeymapUtil.getShortcutText((Shortcut)shortcut);
            if (text.length() <= 0) continue;
            return text;
        }
        return ActionManager.getInstance().getId(action);
    }

    public String[] getDefaultLiveTemplateFiles() {
        return new String[]{"/liveTemplates/xsl"};
    }

    public String[] getHiddenLiveTemplateFiles() {
        return null;
    }

    class MyFindAction
    extends AnAction
    implements DumbAware {
        private final AnAction origAction;
        private final boolean isPrev;
        private boolean wrapAround;

        public MyFindAction(AnAction origAction, boolean isPrev) {
            this.origAction = origAction;
            this.isPrev = isPrev;
            this.copyFrom(origAction);
            this.setEnabledInModalContext(origAction.isEnabledInModalContext());
        }

        public void actionPerformed(AnActionEvent event) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
            if (editor != null && HighlighterUtil.hasHighlighters(editor)) {
                int startOffset;
                int offset = editor.getCaretModel().getOffset();
                List<RangeHighlighter> hl = HighlighterUtil.getHighlighters(editor);
                int diff = Integer.MAX_VALUE;
                RangeHighlighter next = null;
                for (RangeHighlighter highlighter : hl) {
                    if (this.isPrev) {
                        if (highlighter.getStartOffset() >= offset || offset - highlighter.getStartOffset() >= diff) continue;
                        diff = offset - highlighter.getStartOffset();
                        next = highlighter;
                        continue;
                    }
                    if (highlighter.getStartOffset() <= offset || highlighter.getStartOffset() - offset >= diff) continue;
                    diff = highlighter.getStartOffset() - offset;
                    next = highlighter;
                }
                if (next != null) {
                    startOffset = next.getStartOffset();
                } else if (this.wrapAround) {
                    startOffset = hl.get(this.isPrev ? hl.size() - 1 : 0).getStartOffset();
                } else {
                    String info = (this.isPrev ? "First" : "Last") + " XPath match reached. Press " + (this.isPrev ? XPathAppComponent.getShortcutText(XPathAppComponent.this.prevAction) : XPathAppComponent.getShortcutText(XPathAppComponent.this.nextAction)) + " to search from the " + (this.isPrev ? "bottom" : "top");
                    XPathAppComponent.showEditorHint(info, editor);
                    this.wrapAround = true;
                    return;
                }
                editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
                editor.getCaretModel().moveToOffset(startOffset);
                this.wrapAround = false;
                return;
            }
            this.origAction.actionPerformed(event);
        }

        public void update(AnActionEvent event) {
            super.update(event);
            this.origAction.update(event);
        }

        public boolean displayTextInToolbar() {
            return this.origAction.displayTextInToolbar();
        }

        public void setDefaultIcon(boolean b) {
            this.origAction.setDefaultIcon(b);
        }

        public boolean isDefaultIcon() {
            return this.origAction.isDefaultIcon();
        }
    }
}

