/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public abstract class GrAbstractInplaceIntroducer<Settings extends GrIntroduceSettings>
extends AbstractInplaceIntroducer<GrVariable, PsiElement> {
    private SmartTypePointer myTypePointer;
    private final OccurrencesChooser.ReplaceChoice myReplaceChoice;
    private RangeMarker myVarMarker;
    private final PsiFile myFile;
    private final GrIntroduceContext myContext;

    public GrAbstractInplaceIntroducer(String title, OccurrencesChooser.ReplaceChoice replaceChoice, GrIntroduceContext context) {
        super(context.getProject(), context.getEditor(), (PsiElement)context.getExpression(), (PsiNameIdentifierOwner)context.getVar(), context.getOccurrences(), title, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        this.myReplaceChoice = replaceChoice;
        this.myContext = context;
        this.myFile = context.getPlace().getContainingFile();
    }

    public GrIntroduceContext getContext() {
        return this.myContext;
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
        throw new IncorrectOperationException("don't invoke this method");
    }

    public GrExpression restoreExpression(PsiFile containingFile, GrVariable variable, RangeMarker marker, String exprText) {
        GrExpression expression;
        PsiElement refVariableElementParent;
        if (exprText == null) {
            return null;
        }
        if (variable == null || !variable.isValid()) {
            return null;
        }
        PsiElement refVariableElement = containingFile.findElementAt(marker.getStartOffset());
        PsiElement psiElement = refVariableElementParent = refVariableElement != null ? refVariableElement.getParent() : null;
        GrExpression grExpression = refVariableElementParent instanceof GrNewExpression && refVariableElement.getNode().getElementType() == GroovyTokenTypes.kNEW ? (GrNewExpression)refVariableElementParent : (expression = refVariableElementParent instanceof GrParenthesizedExpression ? ((GrParenthesizedExpression)refVariableElementParent).getOperand() : (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, GrReferenceExpression.class));
        if (expression instanceof GrReferenceExpression && !(expression.getParent() instanceof GrMethodCall)) {
            String referenceName = ((GrReferenceExpression)expression).getReferenceName();
            if (((GrReferenceExpression)expression).resolve() == variable || Comparing.strEqual((String)variable.getName(), (String)referenceName) || Comparing.strEqual((String)exprText, (String)referenceName)) {
                return (GrExpression)expression.replace(GroovyPsiElementFactory.getInstance(this.myProject).createExpressionFromText(exprText, variable));
            }
        }
        if (expression == null) {
            expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, GrExpression.class);
        }
        while (expression instanceof GrReferenceExpression || expression instanceof GrCall) {
            PsiElement parent = expression.getParent();
            if (parent instanceof GrMethodCallExpression && parent.getText().equals(exprText)) {
                return (GrExpression)parent;
            }
            if (parent instanceof GrExpression) {
                expression = (GrExpression)parent;
                if (!expression.getText().equals(exprText)) continue;
                return expression;
            }
            if (!(expression instanceof GrReferenceExpression)) break;
            return null;
        }
        if (expression != null && expression.isValid() && expression.getText().equals(exprText)) {
            return expression;
        }
        if (refVariableElementParent instanceof GrExpression && refVariableElementParent.getText().equals(exprText)) {
            return (GrExpression)refVariableElementParent;
        }
        return null;
    }

    protected void updateTitle(@Nullable GrVariable variable, String value) {
        if (variable == null) {
            super.updateTitle((PsiNameIdentifierOwner)variable, value);
        } else {
            String variableText = variable.getParent().getText();
            PsiElement identifier = variable.getNameIdentifierGroovy();
            int startOffsetInParent = identifier.getStartOffsetInParent() + variable.getStartOffsetInParent();
            this.setPreviewText(variableText.substring(0, startOffsetInParent) + value + variableText.substring(startOffsetInParent + identifier.getTextLength()));
            this.revalidate();
        }
    }

    protected void updateTitle(@Nullable GrVariable variable) {
        if (variable == null) {
            return;
        }
        this.setPreviewText(variable.getParent().getText());
        this.revalidate();
    }

    @Nullable
    protected PsiElement getNameIdentifier() {
        return ((GrVariable)this.myElementToRename).getNameIdentifierGroovy();
    }

    protected GrVariable getVariable() {
        if (this.myVarMarker == null) {
            return null;
        }
        int offset = this.myVarMarker.getStartOffset();
        PsiElement at = this.myFile.findElementAt(offset);
        GrVariable var = (GrVariable)PsiTreeUtil.getParentOfType((PsiElement)at, GrVariable.class);
        return var;
    }

    protected void moveOffsetAfter(boolean success) {
        super.moveOffsetAfter(success);
    }

    protected void performIntroduce() {
        this.runRefactoring(new IntroduceContextAdapter(), this.getSettings(), true);
    }

    @NotNull
    protected PsiElement[] restoreOccurrences() {
        List result = ContainerUtil.map((Collection)this.getOccurrenceMarkers(), (Function)new Function<RangeMarker, PsiElement>(){

            public PsiElement fun(RangeMarker marker) {
                return PsiImplUtil.findElementInRange(GrAbstractInplaceIntroducer.this.myFile, marker.getStartOffset(), marker.getEndOffset(), GrExpression.class);
            }
        });
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrAbstractInplaceIntroducer", "restoreOccurrences"));
        }
        return psiElementArray;
    }

    @Nullable
    protected GrVariable createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        final Settings settings = this.getInitialSettingsForInplace(this.myContext, this.myReplaceChoice, names);
        if (settings == null) {
            return null;
        }
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<SmartPsiElementPointer<GrVariable>>(){

            public SmartPsiElementPointer<GrVariable> compute() {
                GrVariable var = GrAbstractInplaceIntroducer.this.runRefactoring(GrAbstractInplaceIntroducer.this.myContext, settings, false);
                return var != null ? SmartPointerManager.getInstance((Project)GrAbstractInplaceIntroducer.this.myProject).createSmartPsiElementPointer((PsiElement)var) : null;
            }
        });
        if (pointer != null) {
            GrVariable var = (GrVariable)pointer.getElement();
            if (var != null) {
                this.myVarMarker = this.myContext.getEditor().getDocument().createRangeMarker(var.getTextRange());
            }
            return var;
        }
        return null;
    }

    protected abstract GrVariable runRefactoring(GrIntroduceContext var1, Settings var2, boolean var3);

    @Nullable
    protected abstract Settings getInitialSettingsForInplace(@NotNull GrIntroduceContext var1, @NotNull OccurrencesChooser.ReplaceChoice var2, String[] var3);

    public boolean isReplaceAllOccurrences() {
        return this.myReplaceChoice != OccurrencesChooser.ReplaceChoice.NO;
    }

    protected abstract Settings getSettings();

    protected void restoreState(@NotNull GrVariable psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "org/jetbrains/plugins/groovy/refactoring/introduce/GrAbstractInplaceIntroducer", "restoreState"));
        }
        PsiType declaredType = psiField.getDeclaredType();
        this.myTypePointer = declaredType != null ? SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(declaredType) : null;
        super.restoreState((PsiNameIdentifierOwner)psiField);
    }

    @Nullable
    protected PsiType getSelectedType() {
        return this.myTypePointer != null ? this.myTypePointer.getType() : null;
    }

    private class IntroduceContextAdapter
    implements GrIntroduceContext {
        private IntroduceContextAdapter() {
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = GrAbstractInplaceIntroducer.this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrAbstractInplaceIntroducer$IntroduceContextAdapter", "getProject"));
            }
            return project;
        }

        @Override
        public Editor getEditor() {
            return GrAbstractInplaceIntroducer.this.myEditor;
        }

        @Override
        @Nullable
        public GrExpression getExpression() {
            return (GrExpression)GrAbstractInplaceIntroducer.this.getExpr();
        }

        @Override
        @Nullable
        public GrVariable getVar() {
            return (GrVariable)GrAbstractInplaceIntroducer.this.getLocalVariable();
        }

        @Override
        @Nullable
        public StringPartInfo getStringPart() {
            return null;
        }

        @Override
        @NotNull
        public PsiElement[] getOccurrences() {
            PsiElement[] psiElementArray = GrAbstractInplaceIntroducer.this.restoreOccurrences();
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrAbstractInplaceIntroducer$IntroduceContextAdapter", "getOccurrences"));
            }
            return psiElementArray;
        }

        @Override
        public PsiElement getScope() {
            return GrAbstractInplaceIntroducer.this.myScope;
        }

        @Override
        @NotNull
        public PsiElement getPlace() {
            GrExpression expression = this.getExpression();
            GrExpression grExpression = expression != null ? expression : GrAbstractInplaceIntroducer.this.getLocalVariable();
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/GrAbstractInplaceIntroducer$IntroduceContextAdapter", "getPlace"));
            }
            return grExpression;
        }
    }
}

