/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.CacheVersion;
import org.jetbrains.kotlin.incremental.CacheVersionKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u001a\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\u001a\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\u001a\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DATA_CONTAINER_VERSION", "", "DATA_CONTAINER_VERSION_FILE_NAME", "", "EXPERIMENTAL_VERSION", "EXPERIMENTAL_VERSION_FILE_NAME", "NORMAL_VERSION", "NORMAL_VERSION_FILE_NAME", "allCachesVersions", "", "Lorg/jetbrains/kotlin/incremental/CacheVersion;", "containerDataRoot", "Ljava/io/File;", "dataRoots", "dataContainerCacheVersion", "dataRoot", "experimentalCacheVersion", "normalCacheVersion", "build"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u001a\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\u001a\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\u001a\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, strings={"DATA_CONTAINER_VERSION", "", "DATA_CONTAINER_VERSION_FILE_NAME", "", "EXPERIMENTAL_VERSION", "EXPERIMENTAL_VERSION_FILE_NAME", "NORMAL_VERSION", "NORMAL_VERSION_FILE_NAME", "allCachesVersions", "", "Lorg/jetbrains/kotlin/incremental/CacheVersion;", "containerDataRoot", "Ljava/io/File;", "dataRoots", "dataContainerCacheVersion", "dataRoot", "experimentalCacheVersion", "normalCacheVersion", "build"})
public final class CacheVersionKt {
    private static final int NORMAL_VERSION = 8;
    private static final int EXPERIMENTAL_VERSION = 2;
    private static final int DATA_CONTAINER_VERSION = 1;
    private static final String NORMAL_VERSION_FILE_NAME = "format-version.txt";
    private static final String EXPERIMENTAL_VERSION_FILE_NAME = "experimental-format-version.txt";
    private static final String DATA_CONTAINER_VERSION_FILE_NAME = "data-container-format-version.txt";

    @NotNull
    public static final CacheVersion normalCacheVersion(@NotNull File dataRoot) {
        Intrinsics.checkParameterIsNotNull((Object)dataRoot, (String)"dataRoot");
        return new CacheVersion(NORMAL_VERSION, new File(dataRoot, NORMAL_VERSION_FILE_NAME), CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.CLEAN_NORMAL_CACHES, (Function0<Boolean>)((Function0)normalCacheVersion.1.INSTANCE));
    }

    @NotNull
    public static final CacheVersion experimentalCacheVersion(@NotNull File dataRoot) {
        Intrinsics.checkParameterIsNotNull((Object)dataRoot, (String)"dataRoot");
        return new CacheVersion(EXPERIMENTAL_VERSION, new File(dataRoot, EXPERIMENTAL_VERSION_FILE_NAME), CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.CLEAN_EXPERIMENTAL_CACHES, (Function0<Boolean>)((Function0)experimentalCacheVersion.1.INSTANCE));
    }

    @NotNull
    public static final CacheVersion dataContainerCacheVersion(@NotNull File dataRoot) {
        Intrinsics.checkParameterIsNotNull((Object)dataRoot, (String)"dataRoot");
        return new CacheVersion(DATA_CONTAINER_VERSION, new File(dataRoot, DATA_CONTAINER_VERSION_FILE_NAME), CacheVersion.Action.REBUILD_ALL_KOTLIN, CacheVersion.Action.REBUILD_ALL_KOTLIN, CacheVersion.Action.CLEAN_DATA_CONTAINER, (Function0<Boolean>)((Function0)dataContainerCacheVersion.1.INSTANCE));
    }

    @NotNull
    public static final Iterable<CacheVersion> allCachesVersions(@NotNull File containerDataRoot, @NotNull Iterable<? extends File> dataRoots) {
        Intrinsics.checkParameterIsNotNull((Object)containerDataRoot, (String)"containerDataRoot");
        Intrinsics.checkParameterIsNotNull(dataRoots, (String)"dataRoots");
        ArrayList versions = CollectionsKt.arrayListOf((Object[])new CacheVersion[0]);
        versions.add(CacheVersionKt.dataContainerCacheVersion(containerDataRoot));
        for (File file : dataRoots) {
            versions.add(CacheVersionKt.normalCacheVersion(file));
            versions.add(CacheVersionKt.experimentalCacheVersion(file));
        }
        return versions;
    }

    static {
        NORMAL_VERSION = 8;
        EXPERIMENTAL_VERSION = 2;
        DATA_CONTAINER_VERSION = 1;
        NORMAL_VERSION_FILE_NAME = NORMAL_VERSION_FILE_NAME;
        EXPERIMENTAL_VERSION_FILE_NAME = EXPERIMENTAL_VERSION_FILE_NAME;
        DATA_CONTAINER_VERSION_FILE_NAME = DATA_CONTAINER_VERSION_FILE_NAME;
    }
}

