/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.incremental.ChangeInfo;
import org.jetbrains.kotlin.incremental.CompilationResult;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.storages.PathCollectionExternalizer;
import org.jetbrains.kotlin.jps.incremental.storages.PathFunctionPair;
import org.jetbrains.kotlin.jps.incremental.storages.PathFunctionPairKeyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0004$%&'B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cH\u0016R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/jps/incremental/storage/StorageOwner;", "target", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "dirtyInlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$DirtyInlineFunctionsMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsMap;", "inlinedTo", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsFilesMap;", "additionalProcessChangedClass", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "", "additionalProcessRemovedClasses", "", "dirtyClasses", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "cleanDirtyInlineFunctions", "debugLog", "message", "", "getFilesToReinline", "", "Ljava/io/File;", "registerInline", "fromPath", "jvmSignature", "toPath", "Companion", "DirtyInlineFunctionsMap", "InlineFunctionsFilesMap", "InlineFunctionsMap", "jps-plugin"})
@KotlinClass(version={1, 1, 0}, data={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0004$%&'B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cH\u0016R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, strings={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/jps/incremental/storage/StorageOwner;", "target", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "dirtyInlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$DirtyInlineFunctionsMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsMap;", "inlinedTo", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsFilesMap;", "additionalProcessChangedClass", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "", "additionalProcessRemovedClasses", "", "dirtyClasses", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "cleanDirtyInlineFunctions", "debugLog", "message", "", "getFilesToReinline", "", "Ljava/io/File;", "registerInline", "fromPath", "jvmSignature", "toPath", "Companion", "DirtyInlineFunctionsMap", "InlineFunctionsFilesMap", "InlineFunctionsMap", "jps-plugin"})
public final class JpsIncrementalCacheImpl
extends IncrementalCacheImpl<ModuleBuildTarget>
implements StorageOwner {
    private final InlineFunctionsMap inlineFunctionsMap;
    private final DirtyInlineFunctionsMap dirtyInlineFunctionsMap;
    private final InlineFunctionsFilesMap inlinedTo;
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String DIRTY_INLINE_FUNCTIONS = "dirty-inline-functions";
    private static final String INLINED_TO = "inlined-to";
    public static final Companion Companion = new Companion(null);

    @Override
    public void registerInline(@NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        if (!IncrementalCompilation.isExperimental()) {
            this.inlinedTo.add(fromPath, jvmSignature, toPath);
        }
    }

    @Override
    protected void debugLog(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        KotlinBuilder.Companion.getLOG().debug(message);
    }

    @Override
    @NotNull
    protected CompilationResult additionalProcessChangedClass(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
        return this.inlineFunctionsMap.process(kotlinClass, isPackage);
    }

    @Override
    protected void additionalProcessRemovedClasses(@NotNull List<? extends JvmClassName> dirtyClasses) {
        Intrinsics.checkParameterIsNotNull(dirtyClasses, (String)"dirtyClasses");
        Iterable $receiver$iv = dirtyClasses;
        for (Object element$iv : $receiver$iv) {
            JvmClassName it = (JvmClassName)element$iv;
            this.inlineFunctionsMap.remove(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getFilesToReinline() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object className2;
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        Object object = MapsKt.iterator(this.dirtyInlineFunctionsMap.getEntries());
        while (object.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            Map.Entry entry = (Map.Entry)object.next();
            Map.Entry entry2 = entry;
            className2 = (JvmClassName)$receiver$iv2.getKey();
            Map.Entry $i$f$component1 = entry;
            Collection functions2 = (Collection)$receiver$iv.getValue();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            String classFilePath = this.getClassFilePath(string);
            for (Object cache : this.getDependentsWithThis()) {
                void destination$iv$iv2;
                void $receiver$iv$iv2;
                void $receiver$iv3;
                Iterable iterable = functions2;
                void var11_11 = $receiver$iv3;
                Collection collection = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    String it = (String)element$iv$iv;
                    Object object2 = cache;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheImpl");
                    }
                    Iterable list$iv$iv = ((JpsIncrementalCacheImpl)object2).inlinedTo.get(classFilePath, it);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List targetFiles = (List)destination$iv$iv2;
                result.addAll((Collection)targetFiles);
            }
        }
        Iterable $receiver$iv = (Iterable)result;
        object = $receiver$iv;
        className2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Object cache;
            cache = (String)item$iv$iv;
            void var20_17 = destination$iv$iv;
            File file = new File((String)it);
            var20_17.add(file);
        }
        return (List)destination$iv$iv;
    }

    public final void cleanDirtyInlineFunctions() {
        this.dirtyInlineFunctionsMap.clean();
    }

    public JpsIncrementalCacheImpl(@NotNull ModuleBuildTarget target, @NotNull BuildDataPaths paths) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        File file = paths.getTargetDataRoot((BuildTarget)target);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"paths.getTargetDataRoot(target)");
        super(file, target.getOutputDir(), target);
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(JpsIncrementalCacheImpl.Companion.getINLINE_FUNCTIONS())));
        this.dirtyInlineFunctionsMap = (DirtyInlineFunctionsMap)this.registerMap((BasicMap)new DirtyInlineFunctionsMap(this.getStorageFile(JpsIncrementalCacheImpl.Companion.getDIRTY_INLINE_FUNCTIONS())));
        this.inlinedTo = (InlineFunctionsFilesMap)this.registerMap((BasicMap)new InlineFunctionsFilesMap(this.getStorageFile(JpsIncrementalCacheImpl.Companion.getINLINED_TO())));
    }

    static {
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        DIRTY_INLINE_FUNCTIONS = DIRTY_INLINE_FUNCTIONS;
        INLINED_TO = INLINED_TO;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getInlineFunctionsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "", "put", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "newMap", "remove", "", "jps-plugin"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0019"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getInlineFunctionsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "isPackage", "", "put", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "newMap", "remove", "", "jps-plugin"})
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(byte[] bytes) {
            HashMap result = new HashMap();
            Set inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames((byte[])bytes);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, 327680, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (this.this$0.$inlineFunctions.contains(jvmName) ^ true) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalCacheImplKt.md5(dummyBytes);
                            MapsKt.set((Map)this.this$0.$result, (Object)jvmName, (Object)hash);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result;
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getInlineFunctionsMap(kotlinClass.getFileContents()), isPackage);
        }

        private final CompilationResult put(JvmClassName className2, Map<String, Long> newMap, boolean isPackage) {
            Sequence sequence;
            String internalName = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = internalName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalName");
            Map map = (Map)lazyStorage.get(string);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMap = map;
            HashSet added = SetsKt.hashSetOf((Object[])new String[0]);
            HashSet changed = SetsKt.hashSetOf((Object[])new String[0]);
            Set allFunctions = SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet());
            for (String fn : allFunctions) {
                Long oldHash = (Long)oldMap.get(fn);
                Long newHash = newMap.get(fn);
                if (oldHash == null) {
                    added.add(fn);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true)) continue;
                changed.add(fn);
            }
            if (MapsKt.isNotEmpty(newMap)) {
                LazyStorage<String, Map<String, Long>> lazyStorage2 = this.getStorage();
                String string2 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
                lazyStorage2.set(string2, newMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"internalName");
                lazyStorage3.remove(string3);
            }
            if (CollectionsKt.isNotEmpty((Collection)changed)) {
                JpsIncrementalCacheImpl.this.dirtyInlineFunctionsMap.put(className2, CollectionsKt.toList((Iterable)changed));
            }
            if (IncrementalCompilation.isExperimental()) {
                FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
                sequence = SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)added), (Sequence)CollectionsKt.asSequence((Iterable)changed)), (Function1)((Function1)new Function1<String, ChangeInfo.MembersChanged>(fqName){
                    final /* synthetic */ FqName $fqName;

                    @NotNull
                    public final ChangeInfo.MembersChanged invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FqName fqName = this.$fqName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"fqName");
                        return new ChangeInfo.MembersChanged(fqName, CollectionsKt.listOf((Object)StringsKt.substringBefore$default((String)it, (String)"(", null, (int)2, null)));
                    }
                    {
                        this.$fqName = fqName;
                        super(1);
                    }
                }));
            } else {
                sequence = SequencesKt.emptySequence();
            }
            Sequence changes2 = sequence;
            return new CompilationResult(false, false, CollectionsKt.isNotEmpty((Collection)changed), CollectionsKt.isNotEmpty((Collection)added), changes2, 3, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\nJ\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$DirtyInlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getEntries", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "put", "", "className", "changedFunctions", "", "jps-plugin"})
    @KotlinClass(version={1, 1, 0}, data={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\nJ\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u00a8\u0006\u0011"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$DirtyInlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getEntries", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "put", "", "className", "changedFunctions", "", "jps-plugin"})
    private final class DirtyInlineFunctionsMap
    extends BasicStringMap<Collection<? extends String>> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<JvmClassName, Collection<String>> getEntries() {
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            Iterable $receiver$iv = this.getStorage().getKeys();
            Iterable $receiver$iv$iv = $receiver$iv;
            int capacity$iv$iv = RangesKt.coerceAtLeast((int)((int)((float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10) / 0.75f + 1.0f)), (int)16);
            Iterable iterable = $receiver$iv$iv;
            Map map = new LinkedHashMap(capacity$iv$iv);
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it;
                String p1;
                String string = (String)element$iv$iv$iv;
                void var13_9 = destination$iv$iv$iv;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
                p1 = (String)element$iv$iv$iv;
                Object v = this.getStorage().get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Collection collection = (Collection)v;
                var13_9.put(jvmClassName, collection);
            }
            return destination$iv$iv$iv;
        }

        public final void put(@NotNull JvmClassName className2, @NotNull List<String> changedFunctions) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull(changedFunctions, (String)"changedFunctions");
            LazyStorage<String, List<String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, changedFunctions);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public DirtyInlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0016\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsFilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "Lorg/jetbrains/kotlin/jps/incremental/storages/PathFunctionPair;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourcePath", "jvmSignature", "targetPath", "dumpKey", "key", "dumpValue", "value", "get", "jps-plugin"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0016\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0012"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$InlineFunctionsFilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "Lorg/jetbrains/kotlin/jps/incremental/storages/PathFunctionPair;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourcePath", "jvmSignature", "targetPath", "dumpKey", "key", "dumpValue", "value", "get", "jps-plugin"})
    private final class InlineFunctionsFilesMap
    extends BasicMap<PathFunctionPair, Collection<? extends String>> {
        public final void add(@NotNull String sourcePath, @NotNull String jvmSignature, @NotNull String targetPath) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            this.getStorage().append(key, targetPath);
        }

        @NotNull
        public final Collection<String> get(@NotNull String sourcePath, @NotNull String jvmSignature) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            Collection collection = (Collection)this.getStorage().get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            return collection;
        }

        @Override
        @NotNull
        protected String dumpKey(@NotNull PathFunctionPair key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return "(" + key.getPath() + ", " + key.getFunction() + ")";
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public InlineFunctionsFilesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, PathFunctionPairKeyDescriptor.INSTANCE, PathCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$Companion;", "", "()V", "DIRTY_INLINE_FUNCTIONS", "", "getDIRTY_INLINE_FUNCTIONS", "()Ljava/lang/String;", "INLINED_TO", "getINLINED_TO", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "jps-plugin"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl$Companion;", "", "()V", "DIRTY_INLINE_FUNCTIONS", "", "getDIRTY_INLINE_FUNCTIONS", "()Ljava/lang/String;", "INLINED_TO", "getINLINED_TO", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "jps-plugin"})
    public static final class Companion {
        private final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        private final String getDIRTY_INLINE_FUNCTIONS() {
            return DIRTY_INLINE_FUNCTIONS;
        }

        private final String getINLINED_TO() {
            return INLINED_TO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

