/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0014\u0010'\u001a\u00020\u0006*\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/utils/LibraryUtils;", "", "()V", "KOTLIN_JS_MODULE_ATTRIBUTE_NAME", "Ljava/util/jar/Attributes$Name;", "KOTLIN_JS_MODULE_NAME", "", "getKOTLIN_JS_MODULE_NAME", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANIFEST_PATH", "META_INF", "getMETA_INF", "TITLE_KOTLIN_JAVASCRIPT_LIB", "TITLE_KOTLIN_JAVASCRIPT_STDLIB", "checkAttributeValue", "", "library", "Ljava/io/File;", "expected", "attributeName", "getJarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classesRoots", "", "jarName", "getKotlinJsModuleName", "getManifestFromDirectory", "Ljava/util/jar/Manifest;", "getManifestFromJar", "getManifestFromJarOrDirectory", "getManifestMainAttributesFromJarOrDirectory", "Ljava/util/jar/Attributes;", "isKotlinJavascriptLibrary", "isKotlinJavascriptLibraryWithMetadata", "isKotlinJavascriptStdLibrary", "isOldKotlinJavascriptLibrary", "getPropertyOrFail", "Ljava/util/Properties;", "propName", "util"})
@KotlinClass(version={1, 1, 0}, data={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0014\u0010'\u001a\u00020\u0006*\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, strings={"Lorg/jetbrains/kotlin/utils/LibraryUtils;", "", "()V", "KOTLIN_JS_MODULE_ATTRIBUTE_NAME", "Ljava/util/jar/Attributes$Name;", "KOTLIN_JS_MODULE_NAME", "", "getKOTLIN_JS_MODULE_NAME", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANIFEST_PATH", "META_INF", "getMETA_INF", "TITLE_KOTLIN_JAVASCRIPT_LIB", "TITLE_KOTLIN_JAVASCRIPT_STDLIB", "checkAttributeValue", "", "library", "Ljava/io/File;", "expected", "attributeName", "getJarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classesRoots", "", "jarName", "getKotlinJsModuleName", "getManifestFromDirectory", "Ljava/util/jar/Manifest;", "getManifestFromJar", "getManifestFromJarOrDirectory", "getManifestMainAttributesFromJarOrDirectory", "Ljava/util/jar/Attributes;", "isKotlinJavascriptLibrary", "isKotlinJavascriptLibraryWithMetadata", "isKotlinJavascriptStdLibrary", "isOldKotlinJavascriptLibrary", "getPropertyOrFail", "Ljava/util/Properties;", "propName", "util"})
public final class LibraryUtils {
    private static final Logger LOG;
    @NotNull
    private static final String KOTLIN_JS_MODULE_NAME = "Kotlin-JS-Module-Name";
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    private static String TITLE_KOTLIN_JAVASCRIPT_LIB;
    @NotNull
    private static final String META_INF = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final Attributes.Name KOTLIN_JS_MODULE_ATTRIBUTE_NAME;
    public static final LibraryUtils INSTANCE;

    @NotNull
    public final String getKOTLIN_JS_MODULE_NAME() {
        return KOTLIN_JS_MODULE_NAME;
    }

    @NotNull
    public final String getMETA_INF() {
        return META_INF;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getJarFile(@NotNull List<? extends VirtualFile> classesRoots, @NotNull String jarName) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(classesRoots, (String)"classesRoots");
            Intrinsics.checkParameterIsNotNull((Object)jarName, (String)"jarName");
            Iterable $receiver$iv = classesRoots;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)jarName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final String getKotlinJsModuleName(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Attributes attributes = INSTANCE.getManifestMainAttributesFromJarOrDirectory(library);
        return attributes != null ? attributes.getValue(KOTLIN_JS_MODULE_ATTRIBUTE_NAME) : null;
    }

    @JvmStatic
    public static final boolean isOldKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Attributes.Name name = Attributes.Name.SPECIFICATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Attributes.Name.SPECIFICATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_LIB, name) && LibraryUtils.getKotlinJsModuleName(library) != null;
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibraryWithMetadata(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return CollectionsKt.isNotEmpty((Collection)KotlinJavascriptMetadataUtils.loadMetadata(library));
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return LibraryUtils.isOldKotlinJavascriptLibrary(library) || LibraryUtils.isKotlinJavascriptLibraryWithMetadata(library);
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptStdLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Attributes.Name.IMPLEMENTATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(library);
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(File library) {
        if (!library.canRead() || !library.isDirectory()) {
            return null;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (!manifestFile.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                Manifest manifest = new Manifest(inputStream);
                return manifest;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(File library) {
        Manifest manifest = this.getManifestFromJarOrDirectory(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(File library, String expected, Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value != null && Intrinsics.areEqual((Object)value, (Object)expected);
    }

    private final String getPropertyOrFail(Properties $receiver, String propName) {
        String value = $receiver.getProperty(propName);
        if (value == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $receiver.list(new PrintStream(bytes));
            LOG.error(propName + " not found." + "\n" + " " + bytes);
        }
        String string = value;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
        return string;
    }

    private LibraryUtils() {
        INSTANCE = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        KOTLIN_JS_MODULE_NAME = KOTLIN_JS_MODULE_NAME;
        META_INF = META_INF;
        MANIFEST_PATH = META_INF + "MANIFEST.MF";
        KOTLIN_JS_MODULE_ATTRIBUTE_NAME = new Attributes.Name(KOTLIN_JS_MODULE_NAME);
        String jsStdLib = "";
        String jsLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                jsStdLib = this.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
                jsLib = this.getPropertyOrFail(properties2, "manifest.spec.title.kotlin.javascript.lib");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
        TITLE_KOTLIN_JAVASCRIPT_LIB = jsLib;
    }

    static {
        new LibraryUtils();
    }
}

