/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.Classpath;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.ScriptRunner;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\u001b\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/runner/Main;", "", "()V", "KOTLIN_HOME", "Ljava/io/File;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printUsageAndExit", "printVersionAndExit", "run", "runner"})
@KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\u001b\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, strings={"Lorg/jetbrains/kotlin/runner/Main;", "", "()V", "KOTLIN_HOME", "Ljava/io/File;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printUsageAndExit", "printVersionAndExit", "run", "runner"})
public final class Main {
    private static final File KOTLIN_HOME;
    public static final Main INSTANCE;

    private final void run(String[] args) {
        Object i;
        Classpath classpath = new Classpath();
        Runner runner = null;
        boolean collectingArguments = false;
        ArrayList<String> arguments = CollectionsKt.arrayListOf(new String[0]);
        classpath.add(".");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        while (i.element < ((Object[])args).length) {
            String arg = args[i.element];
            if (collectingArguments) {
                arguments.add(arg);
                int n = i.element++;
                continue;
            }
            Function0<String> next$ = new Function0<String>((Ref.IntRef)i, args, arg){
                final /* synthetic */ Ref.IntRef $i;
                final /* synthetic */ String[] $args;
                final /* synthetic */ String $arg;

                @NotNull
                public final String invoke() {
                    Ref.IntRef intRef = this.$i;
                    ++intRef.element;
                    if (intRef.element == ((Object[])this.$args).length) {
                        throw (Throwable)new RunnerException("argument expected to " + this.$arg);
                    }
                    return this.$args[this.$i.element];
                }
                {
                    this.$i = intRef;
                    this.$args = stringArray;
                    this.$arg = string;
                    super(0);
                }
            };
            if (Intrinsics.areEqual("-help", arg) || Intrinsics.areEqual("-h", arg)) {
                this.printUsageAndExit();
            } else if (Intrinsics.areEqual("-version", arg)) {
                this.printVersionAndExit();
            } else if (Intrinsics.areEqual("-classpath", arg) || Intrinsics.areEqual("-cp", arg)) {
                classpath.add((String)next$.invoke());
            } else if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                runner = new ExpressionRunner((String)next$.invoke());
                collectingArguments = true;
            } else {
                if (StringsKt.startsWith$default(arg, "-", false, 2, null)) {
                    throw (Throwable)new RunnerException("unsupported argument: " + arg);
                }
                if (StringsKt.endsWith$default(arg, ".jar", false, 2, null)) {
                    runner = new JarRunner(arg);
                    collectingArguments = true;
                } else if (StringsKt.endsWith$default(arg, ".kts", false, 2, null)) {
                    runner = new ScriptRunner(arg);
                    collectingArguments = true;
                } else {
                    runner = new MainClassRunner(arg);
                    collectingArguments = true;
                }
            }
            int n = i.element++;
        }
        classpath.add(KOTLIN_HOME.toString() + "/lib/kotlin-runtime.jar");
        classpath.add(KOTLIN_HOME.toString() + "/lib/kotlin-reflect.jar");
        if (runner == null) {
            runner = new ReplRunner();
        }
        runner.run(classpath, (List<String>)arguments);
        i = null;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        try {
            INSTANCE.run(args);
        }
        catch (RunnerException e) {
            System.err.println("error: " + e.getMessage());
            System.exit(1);
        }
    }

    private final void printUsageAndExit() {
        ConsoleKt.println("kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> <arguments>\nwhere command may be one of:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (-classpath argument is ignored and no Kotlin runtime is added to the classpath)\n" + "and possible options include:\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\n");
        System.exit(0);
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new RunnerException("no build.txt was found at home=" + KOTLIN_HOME);
        }
        String version = string;
        ConsoleKt.println("Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ")");
        System.exit(0);
    }

    private Main() {
        INSTANCE = this;
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            System.exit(1);
        }
        KOTLIN_HOME = new File(home);
    }

    static {
        new Main();
    }
}

