/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.ArrayAsCollection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.EmptyList;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=5, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0012\"\u0004\b\u0000\u0010\u0007H\u0007\u001a-\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0012\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u0013\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007\u001a!\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0015\u001a\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a+\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a%\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a3\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u00192\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00070\u000e\"\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a+\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001b\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002\u001a%\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000eH\u0000\u00a2\u0006\u0002\u0010\"\u001aG\u0010#\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00070%2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u0006\u00a2\u0006\u0002\u0010&\u001a>\u0010#\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u00062\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060(\u001aE\u0010#\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070)*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\b2\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u0006\u00a2\u0006\u0002\u0010*\u001ad\u0010+\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007\"\u000e\b\u0001\u0010,*\b\u0012\u0004\u0012\u0002H,0)*\b\u0012\u0004\u0012\u0002H\u00070\b2\b\u0010-\u001a\u0004\u0018\u0001H,2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u00062\u0016\b\u0004\u0010.\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H,0(H\u0086\b\u00a2\u0006\u0002\u0010/\u001a\u001e\u00100\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u0007012\u0006\u00102\u001a\u00020\u0006\u001a\u001d\u00103\u001a\u0004\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u000701\u00a2\u0006\u0002\u00104\u001a\u001e\u00105\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u000701H\u0000\u001a,\u00106\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u0007012\f\u00107\u001a\b\u0012\u0004\u0012\u0002H\u000701H\u0000\u001a\"\u00108\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070101\u001a\u0016\u00109\u001a\u00020:\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u0002\u001a\u001e\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u0002\u001a\u001e\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\b\u001a\u0018\u0010<\u001a\u00020:\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u0002H\u0002\u001a\u001e\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070>H\u0007\u001a@\u0010?\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002HA0\b0@\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010A*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002HA0@01\u001a'\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000e\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000eH\u0003\u00a2\u0006\u0002\u0010C\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"!\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006D"}, d2={"indices", "Lkotlin/ranges/IntRange;", "", "getIndices", "(Ljava/util/Collection;)Lkotlin/ranges/IntRange;", "lastIndex", "", "T", "", "getLastIndex", "(Ljava/util/List;)I", "arrayListOf", "Ljava/util/ArrayList;", "elements", "", "([Ljava/lang/Object;)Ljava/util/ArrayList;", "emptyList", "linkedListOf", "Ljava/util/LinkedList;", "([Ljava/lang/Object;)Ljava/util/LinkedList;", "listOf", "element", "(Ljava/lang/Object;)Ljava/util/List;", "([Ljava/lang/Object;)Ljava/util/List;", "listOfNotNull", "", "mutableListOf", "", "rangeCheck", "", "size", "fromIndex", "toIndex", "asCollection", "([Ljava/lang/Object;)Ljava/util/Collection;", "binarySearch", "comparator", "Ljava/util/Comparator;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;II)I", "comparison", "Lkotlin/Function1;", "", "(Ljava/util/List;Ljava/lang/Comparable;II)I", "binarySearchBy", "K", "key", "selector", "(Ljava/util/List;Ljava/lang/Comparable;IILkotlin/jvm/functions/Function1;)I", "collectionSizeOrDefault", "", "default", "collectionSizeOrNull", "(Ljava/lang/Iterable;)Ljava/lang/Integer;", "convertToSetForSetOperation", "convertToSetForSetOperationWith", "source", "flatten", "isNotEmpty", "", "orEmpty", "safeToConvertToSet", "toList", "Ljava/util/Enumeration;", "unzip", "Lkotlin/Pair;", "R", "varargToArrayOfAny", "([Ljava/lang/Object;)[Ljava/lang/Object;", "kotlin-stdlib"}, xs="kotlin/collections/CollectionsKt")
@KotlinMultifileClassPart(version={1, 1, 0}, data={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0012\"\u0004\b\u0000\u0010\u0007H\u0007\u001a-\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0012\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u0013\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007\u001a!\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0015\u001a\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a+\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a%\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a3\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u00192\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00070\u000e\"\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a+\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001b\"\u0004\b\u0000\u0010\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000e\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002\u001a%\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000eH\u0000\u00a2\u0006\u0002\u0010\"\u001aG\u0010#\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00070%2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u0006\u00a2\u0006\u0002\u0010&\u001a>\u0010#\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u00062\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060(\u001aE\u0010#\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070)*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\b2\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u0006\u00a2\u0006\u0002\u0010*\u001ad\u0010+\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007\"\u000e\b\u0001\u0010,*\b\u0012\u0004\u0012\u0002H,0)*\b\u0012\u0004\u0012\u0002H\u00070\b2\b\u0010-\u001a\u0004\u0018\u0001H,2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u00062\u0016\b\u0004\u0010.\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H,0(H\u0086\b\u00a2\u0006\u0002\u0010/\u001a\u001e\u00100\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u0007012\u0006\u00102\u001a\u00020\u0006\u001a\u001d\u00103\u001a\u0004\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u000701\u00a2\u0006\u0002\u00104\u001a\u001e\u00105\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u000701H\u0000\u001a,\u00106\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u0007012\f\u00107\u001a\b\u0012\u0004\u0012\u0002H\u000701H\u0000\u001a\"\u00108\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070101\u001a\u0016\u00109\u001a\u00020:\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u0002\u001a\u001e\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0002\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\u0002\u001a\u001e\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\b\u001a\u0018\u0010<\u001a\u00020:\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u0002H\u0002\u001a\u001e\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070>H\u0007\u001a@\u0010?\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002HA0\b0@\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010A*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002HA0@01\u001a'\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000e\"\u0004\b\u0000\u0010\u0007*\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u000eH\u0003\u00a2\u0006\u0002\u0010C\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"!\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006D"}, strings={"indices", "Lkotlin/ranges/IntRange;", "", "getIndices", "(Ljava/util/Collection;)Lkotlin/ranges/IntRange;", "lastIndex", "", "T", "", "getLastIndex", "(Ljava/util/List;)I", "arrayListOf", "Ljava/util/ArrayList;", "elements", "", "([Ljava/lang/Object;)Ljava/util/ArrayList;", "emptyList", "linkedListOf", "Ljava/util/LinkedList;", "([Ljava/lang/Object;)Ljava/util/LinkedList;", "listOf", "element", "(Ljava/lang/Object;)Ljava/util/List;", "([Ljava/lang/Object;)Ljava/util/List;", "listOfNotNull", "", "mutableListOf", "", "rangeCheck", "", "size", "fromIndex", "toIndex", "asCollection", "([Ljava/lang/Object;)Ljava/util/Collection;", "binarySearch", "comparator", "Ljava/util/Comparator;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;II)I", "comparison", "Lkotlin/Function1;", "", "(Ljava/util/List;Ljava/lang/Comparable;II)I", "binarySearchBy", "K", "key", "selector", "(Ljava/util/List;Ljava/lang/Comparable;IILkotlin/jvm/functions/Function1;)I", "collectionSizeOrDefault", "", "default", "collectionSizeOrNull", "(Ljava/lang/Iterable;)Ljava/lang/Integer;", "convertToSetForSetOperation", "convertToSetForSetOperationWith", "source", "flatten", "isNotEmpty", "", "orEmpty", "safeToConvertToSet", "toList", "Ljava/util/Enumeration;", "unzip", "Lkotlin/Pair;", "R", "varargToArrayOfAny", "([Ljava/lang/Object;)[Ljava/lang/Object;", "kotlin-stdlib"}, multifileClassName="kotlin/collections/CollectionsKt")
final class CollectionsKt__JUtilKt {
    @NotNull
    public static final <T> Collection<T> asCollection(T[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ArrayAsCollection<T>($receiver);
    }

    @NotNull
    public static final <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @NotNull
    public static final <T> List<T> listOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length > 0 ? ArraysKt.asList(elements) : CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> List<T> listOf() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> List<T> listOf(T element) {
        List<T> list = Collections.singletonList(element);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.singletonList(element)");
        return list;
    }

    @Deprecated(message="Use LinkedList constructor.", replaceWith=@ReplaceWith(imports={"java.util.LinkedList"}, expression="LinkedList(listOf(*elements))"))
    @NotNull
    public static final <T> LinkedList<T> linkedListOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length == 0 ? new LinkedList() : new LinkedList((Collection)new ArrayAsCollection<T>(elements));
    }

    @Deprecated(message="Use LinkedList constructor.", replaceWith=@ReplaceWith(imports={"java.util.LinkedList"}, expression="LinkedList<T>()"))
    @NotNull
    public static final <T> LinkedList<T> linkedListOf() {
        return new LinkedList();
    }

    @NotNull
    public static final <T> List<T> mutableListOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length == 0 ? new ArrayList() : new ArrayList((Collection)new ArrayAsCollection<T>(elements));
    }

    @NotNull
    public static final <T> ArrayList<T> arrayListOf(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return elements.length == 0 ? new ArrayList() : new ArrayList((Collection)new ArrayAsCollection<T>(elements));
    }

    @NotNull
    public static final <T> List<T> listOfNotNull(@Nullable T element) {
        return element != null ? CollectionsKt.listOf(element) : CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> List<T> listOfNotNull(T ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return ArraysKt.filterNotNull(elements);
    }

    @NotNull
    public static final IntRange getIndices(Collection<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new IntRange(0, $receiver.size() - 1);
    }

    public static final <T> int getLastIndex(List<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.size() - 1;
    }

    public static final <T> boolean isNotEmpty(Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return !$receiver.isEmpty();
    }

    @NotNull
    public static final <T> Collection<T> orEmpty(Collection<? extends T> $receiver) {
        Collection collection = $receiver;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @NotNull
    public static final <T> List<T> orEmpty(List<? extends T> $receiver) {
        List<Object> list = $receiver;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> toList(Enumeration<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List list = Collections.list($receiver);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.list(this)");
        return list;
    }

    @Nullable
    public static final <T> Integer collectionSizeOrNull(Iterable<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof Collection ? Integer.valueOf(((Collection)$receiver).size()) : (Integer)null;
    }

    public static final <T> int collectionSizeOrDefault(Iterable<? extends T> $receiver, int n) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof Collection ? ((Collection)$receiver).size() : n;
    }

    private static final <T> boolean safeToConvertToSet(Collection<? extends T> $receiver) {
        return $receiver.size() > 2 && $receiver instanceof ArrayList;
    }

    @NotNull
    public static final <T> Collection<T> convertToSetForSetOperationWith(Iterable<? extends T> $receiver, @NotNull Iterable<? extends T> source) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(source, "source");
        Iterable<? extends T> iterable = $receiver;
        return iterable instanceof Set ? (Collection)$receiver : (iterable instanceof Collection ? (source instanceof Collection && ((Collection)source).size() < 2 ? (Collection)$receiver : (CollectionsKt__JUtilKt.safeToConvertToSet((Collection)$receiver) ? (Collection)CollectionsKt.toHashSet($receiver) : (Collection)$receiver)) : (Collection)CollectionsKt.toHashSet($receiver));
    }

    @NotNull
    public static final <T> Collection<T> convertToSetForSetOperation(Iterable<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable<? extends T> iterable = $receiver;
        return iterable instanceof Set ? (Collection)$receiver : (iterable instanceof Collection ? (CollectionsKt__JUtilKt.safeToConvertToSet((Collection)$receiver) ? (Collection)CollectionsKt.toHashSet($receiver) : (Collection)$receiver) : (Collection)CollectionsKt.toHashSet($receiver));
    }

    private static final <T> Object[] varargToArrayOfAny(T[] $receiver) {
        Object[] objectArray = Arrays.copyOf($receiver, $receiver.length, Object[].class);
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "Arrays.copyOf(this, this\u2026 Array<Any?>::class.java)");
        return objectArray;
    }

    public static final <T extends Comparable<? super T>> int binarySearch(List<? extends T> $receiver, @Nullable T element, int fromIndex, int toIndex) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CollectionsKt__JUtilKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable midVal = (Comparable)$receiver.get(mid);
            int cmp = ComparisonsKt.compareValues(midVal, element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, Comparable comparable, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, comparable, n, n2);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, Comparable comparable, int n, int n2, int n3) {
        return CollectionsKt__JUtilKt.binarySearch$default(list, comparable, n, n2, n3, null);
    }

    public static final <T> int binarySearch(List<? extends T> $receiver, T element, @NotNull Comparator<? super T> comparator2, int fromIndex, int toIndex) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(comparator2, "comparator");
        CollectionsKt__JUtilKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = $receiver.get(mid);
            int cmp = comparator2.compare(midVal, element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, Object object, Comparator comparator2, int n, int n2, int n3, Object object2) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, object, comparator2, n, n2);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, Object object, Comparator comparator2, int n, int n2, int n3) {
        return CollectionsKt__JUtilKt.binarySearch$default(list, object, comparator2, n, n2, n3, null);
    }

    public static final <T, K extends Comparable<? super K>> int binarySearchBy(List<? extends T> $receiver, @Nullable K key, int fromIndex, int toIndex, @NotNull Function1<? super T, ? extends K> selector) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(selector, "selector");
        return CollectionsKt.binarySearch($receiver, fromIndex, toIndex, new Function1<T, Integer>(selector, key){
            final /* synthetic */ Function1 $selector;
            final /* synthetic */ Comparable $key;

            public final int invoke(T it) {
                return ComparisonsKt.compareValues((Comparable)this.$selector.invoke(it), this.$key);
            }
            {
                this.$selector = function1;
                this.$key = comparable;
                super(1);
            }
        });
    }

    public static /* bridge */ /* synthetic */ int binarySearchBy$default(List list, Comparable comparable, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, n, n2, new /* invalid duplicate definition of identical inner class */);
    }

    public static /* bridge */ /* synthetic */ int binarySearchBy$default(List list, Comparable comparable, int n, int n2, Function1 function1, int n3) {
        return CollectionsKt__JUtilKt.binarySearchBy$default(list, comparable, n, n2, function1, n3, null);
    }

    public static final <T> int binarySearch(List<? extends T> $receiver, int fromIndex, int toIndex, @NotNull Function1<? super T, Integer> comparison) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(comparison, "comparison");
        CollectionsKt__JUtilKt.rangeCheck($receiver.size(), fromIndex, toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = $receiver.get(mid);
            int cmp = ((Number)comparison.invoke(midVal)).intValue();
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = list.size();
        }
        return CollectionsKt.binarySearch(list, n, n2, function1);
    }

    public static /* bridge */ /* synthetic */ int binarySearch$default(List list, int n, int n2, Function1 function1, int n3) {
        return CollectionsKt__JUtilKt.binarySearch$default(list, n, n2, function1, n3, null);
    }

    private static final void rangeCheck(int size, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw (Throwable)new IllegalArgumentException("fromIndex (" + fromIndex + ") is greater than toIndex (" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw (Throwable)new IndexOutOfBoundsException("fromIndex (" + fromIndex + ") is less than zero.");
        }
        if (toIndex > size) {
            throw (Throwable)new IndexOutOfBoundsException("toIndex (" + toIndex + ") is greater than size (" + size + ").");
        }
    }

    @NotNull
    public static final <T> List<T> flatten(Iterable<? extends Iterable<? extends T>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList result = new ArrayList();
        for (Iterable<T> iterable : $receiver) {
            CollectionsKt.addAll((Collection)result, iterable);
        }
        return result;
    }

    @NotNull
    public static final <T, R> Pair<List<T>, List<R>> unzip(Iterable<? extends Pair<? extends T, ? extends R>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int expectedSize = CollectionsKt.collectionSizeOrDefault($receiver, 10);
        ArrayList<T> listT = new ArrayList<T>(expectedSize);
        ArrayList<R> listR = new ArrayList<R>(expectedSize);
        for (Pair<T, R> pair : $receiver) {
            listT.add(pair.getFirst());
            listR.add(pair.getSecond());
        }
        return TuplesKt.to(listT, listR);
    }

    @NotNull
    public static final /* synthetic */ Object[] access$varargToArrayOfAny(Object[] $receiver) {
        return CollectionsKt__JUtilKt.varargToArrayOfAny($receiver);
    }
}

