/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final Map<FqName, PackageCodegen> package2codegen;
    private final Map<FqName, MultifileClassCodegen> multifileClass2codegen;
    private final Map<String, OutAndSourceFileList> generators;
    private boolean isDone;

    public ClassFileFactory(@NotNull GenerationState state, @NotNull ClassBuilderFactory builderFactory) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClassFileFactory", "<init>"));
        }
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderFactory", "org/jetbrains/kotlin/codegen/ClassFileFactory", "<init>"));
        }
        this.package2codegen = new HashMap<FqName, PackageCodegen>();
        this.multifileClass2codegen = new HashMap<FqName, MultifileClassCodegen>();
        this.generators = new LinkedHashMap<String, OutAndSourceFileList>();
        this.isDone = false;
        this.state = state;
        this.builderFactory = builderFactory;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        ClassBuilder classBuilder2 = this.newVisitor(origin, asmType, Collections.singletonList(sourceFile));
        if (classBuilder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder2;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        String outputFilePath = asmType.getInternalName() + ".class";
        List<File> ioSourceFiles = ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles);
        this.state.getProgress().reportOutput(ioSourceFiles, new File(outputFilePath));
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(outputFilePath, new ClassBuilderAndSourceFileList(answer, ioSourceFiles));
        ClassBuilder classBuilder2 = answer;
        if (classBuilder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder2;
    }

    void done() {
        if (!this.isDone) {
            this.isDone = true;
            Collection<PackageCodegen> packageCodegens = this.package2codegen.values();
            Collection<MultifileClassCodegen> multifileClassCodegens = this.multifileClass2codegen.values();
            for (MultifileClassCodegen codegen : multifileClassCodegens) {
                codegen.done();
            }
            this.writeModuleMappings(packageCodegens, multifileClassCodegens);
        }
    }

    private void writeModuleMappings(@NotNull Collection<PackageCodegen> packageCodegens, @NotNull Collection<MultifileClassCodegen> multifileClassCodegens) {
        if (packageCodegens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageCodegens", "org/jetbrains/kotlin/codegen/ClassFileFactory", "writeModuleMappings"));
        }
        if (multifileClassCodegens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multifileClassCodegens", "org/jetbrains/kotlin/codegen/ClassFileFactory", "writeModuleMappings"));
        }
        final JvmPackageTable.PackageTable.Builder builder = JvmPackageTable.PackageTable.newBuilder();
        String outputFilePath = JvmCodegenUtil.getMappingFileName(this.state.getModuleName());
        List<PackageParts> parts = ClassFileFactory.collectGeneratedPackageParts(packageCodegens, multifileClassCodegens);
        HashSet<File> sourceFiles = new HashSet<File>();
        for (PackageCodegen packageCodegen : packageCodegens) {
            sourceFiles.addAll(ClassFileFactory.toIoFilesIgnoringNonPhysical(PackagePartClassUtils.getFilesWithCallables(packageCodegen.getFiles())));
        }
        for (MultifileClassCodegen multifileClassCodegen : multifileClassCodegens) {
            sourceFiles.addAll(ClassFileFactory.toIoFilesIgnoringNonPhysical(PackagePartClassUtils.getFilesWithCallables(multifileClassCodegen.getFiles())));
        }
        for (PackageParts packageParts : ClassFileUtilsKt.addCompiledPartsAndSort(parts, this.state)) {
            PackageParts.Companion.serialize(packageParts, builder);
        }
        if (builder.getPackagePartsCount() != 0) {
            this.state.getProgress().reportOutput(sourceFiles, new File(outputFilePath));
            this.generators.put(outputFilePath, new OutAndSourceFileList(CollectionsKt.toList(sourceFiles)){

                @Override
                public byte[] asBytes(ClassBuilderFactory factory2) {
                    try {
                        ByteArrayOutputStream moduleMapping = new ByteArrayOutputStream(4096);
                        DataOutputStream dataOutStream = new DataOutputStream((OutputStream)moduleMapping);
                        int[] version = JvmMetadataVersion.INSTANCE.toArray();
                        dataOutStream.writeInt(version.length);
                        for (int number : version) {
                            dataOutStream.writeInt(number);
                        }
                        builder.build().writeTo((OutputStream)dataOutStream);
                        dataOutStream.flush();
                        return moduleMapping.toByteArray();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String asText(ClassBuilderFactory factory2) {
                    try {
                        return new String(this.asBytes(factory2), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private static List<PackageParts> collectGeneratedPackageParts(@NotNull Collection<PackageCodegen> packageCodegens, @NotNull Collection<MultifileClassCodegen> multifileClassCodegens) {
        PackageParts premergedParts;
        if (packageCodegens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageCodegens", "org/jetbrains/kotlin/codegen/ClassFileFactory", "collectGeneratedPackageParts"));
        }
        if (multifileClassCodegens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multifileClassCodegens", "org/jetbrains/kotlin/codegen/ClassFileFactory", "collectGeneratedPackageParts"));
        }
        LinkedHashMap<String, PackageParts> mergedPartsByPackageName = new LinkedHashMap<String, PackageParts>();
        for (PackageCodegen packageCodegen : packageCodegens) {
            PackageParts generatedParts = packageCodegen.getPackageParts();
            premergedParts = new PackageParts(generatedParts.getPackageFqName());
            mergedPartsByPackageName.put(generatedParts.getPackageFqName(), premergedParts);
            premergedParts.getParts().addAll(generatedParts.getParts());
        }
        for (MultifileClassCodegen multifileClassCodegen : multifileClassCodegens) {
            PackageParts multifileClassParts = multifileClassCodegen.getPackageParts();
            premergedParts = (PackageParts)mergedPartsByPackageName.get(multifileClassParts.getPackageFqName());
            if (premergedParts == null) {
                premergedParts = new PackageParts(multifileClassParts.getPackageFqName());
                mergedPartsByPackageName.put(multifileClassParts.getPackageFqName(), premergedParts);
            }
            premergedParts.getParts().addAll(multifileClassParts.getParts());
        }
        ArrayList<PackageParts> result2 = new ArrayList<PackageParts>();
        result2.addAll(mergedPartsByPackageName.values());
        return result2;
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List list2 = ContainerUtil.map(this.generators.keySet(), (Function)new Function<String, OutputFile>(){

            public OutputFile fun(String relativeClassFilePath) {
                return new OutputClassFile(relativeClassFilePath);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "asList"));
        }
        return list2;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/kotlin/codegen/ClassFileFactory", "get"));
        }
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        StringBuilder answer = new StringBuilder();
        for (OutputFile file : this.asList()) {
            answer.append("@").append(file.getRelativePath()).append('\n');
            answer.append(file.asText());
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "createText"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> createTextForEachFile() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (OutputFile file : this.asList()) {
            answer.put(file.getRelativePath(), file.asText());
        }
        LinkedHashMap<String, String> linkedHashMap = answer;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "createTextForEachFile"));
        }
        return linkedHashMap;
    }

    @NotNull
    public PackageCodegen forPackage(@NotNull FqName fqName2, @NotNull Collection<KtFile> files) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forPackage"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forPackage"));
        }
        assert (!this.isDone) : "Already done!";
        PackageCodegen codegen = this.package2codegen.get(fqName2);
        if (codegen == null) {
            codegen = new PackageCodegen(this.state, files, fqName2);
            this.package2codegen.put(fqName2, codegen);
        }
        PackageCodegen packageCodegen = codegen;
        if (packageCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forPackage"));
        }
        return packageCodegen;
    }

    @NotNull
    public MultifileClassCodegen forMultifileClass(@NotNull FqName facadeFqName, @NotNull Collection<KtFile> files) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forMultifileClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forMultifileClass"));
        }
        assert (!this.isDone) : "Already done!";
        MultifileClassCodegen codegen = this.multifileClass2codegen.get(facadeFqName);
        if (codegen == null) {
            codegen = new MultifileClassCodegen(this.state, files, facadeFqName);
            this.multifileClass2codegen.put(facadeFqName, codegen);
        }
        MultifileClassCodegen multifileClassCodegen = codegen;
        if (multifileClassCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forMultifileClass"));
        }
        return multifileClassCodegen;
    }

    @NotNull
    private static List<File> toIoFilesIgnoringNonPhysical(@NotNull Collection<? extends PsiFile> psiFiles) {
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFiles", "org/jetbrains/kotlin/codegen/ClassFileFactory", "toIoFilesIgnoringNonPhysical"));
        }
        ArrayList result2 = Lists.newArrayList();
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) continue;
            result2.add(new File(virtualFile.getPath()));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "toIoFilesIgnoringNonPhysical"));
        }
        return arrayList;
    }

    public void removeClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    public List<KtFile> getInputFiles() {
        return this.state.getFiles();
    }

    private static abstract class OutAndSourceFileList {
        protected final List<File> sourceFiles;

        private OutAndSourceFileList(List<File> sourceFiles) {
            this.sourceFiles = sourceFiles;
        }

        public abstract byte[] asBytes(ClassBuilderFactory var1);

        public abstract String asText(ClassBuilderFactory var1);
    }

    private static final class ClassBuilderAndSourceFileList
    extends OutAndSourceFileList {
        private final ClassBuilder classBuilder;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder2, List<File> sourceFiles) {
            super(sourceFiles);
            this.classBuilder = classBuilder2;
        }

        @Override
        public byte[] asBytes(ClassBuilderFactory factory2) {
            return factory2.asBytes(this.classBuilder);
        }

        @Override
        public String asText(ClassBuilderFactory factory2) {
            return factory2.asText(this.classBuilder);
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string = this.relativeClassFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "getRelativePath"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            OutAndSourceFileList pair2 = (OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair2 == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List<File> list2 = pair2.sourceFiles;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "getSourceFiles"));
            }
            return list2;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asBytes(ClassFileFactory.this.builderFactory);
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "asByteArray"));
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asText(ClassFileFactory.this.builderFactory);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "asText"));
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "toString"));
            }
            return string;
        }
    }
}

